/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultSystemBackendReactiveEngine;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.sys.VaultEnableEngineBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultListAllPluginsData;
import io.quarkus.vault.runtime.client.dto.sys.VaultListPluginsData;
import io.quarkus.vault.runtime.client.dto.sys.VaultListPolicyData;
import io.quarkus.vault.runtime.client.dto.sys.VaultPluginDetailsData;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyData;
import io.quarkus.vault.runtime.client.dto.sys.VaultRegisterPluginBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultSecretEngineInfoData;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultTuneData;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import io.quarkus.vault.sys.EnableEngineOptions;
import io.quarkus.vault.sys.EngineListingVisibility;
import io.quarkus.vault.sys.VaultHealth;
import io.quarkus.vault.sys.VaultHealthStatus;
import io.quarkus.vault.sys.VaultInit;
import io.quarkus.vault.sys.VaultPluginDetails;
import io.quarkus.vault.sys.VaultPlugins;
import io.quarkus.vault.sys.VaultSealStatus;
import io.quarkus.vault.sys.VaultSecretEngine;
import io.quarkus.vault.sys.VaultSecretEngineInfo;
import io.quarkus.vault.sys.VaultTuneInfo;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;

@ApplicationScoped
public class VaultSystemBackendManager
implements VaultSystemBackendReactiveEngine {
    @Inject
    VaultClient vaultClient;
    @Inject
    VaultBuildTimeConfig buildTimeConfig;
    @Inject
    VaultAuthManager vaultAuthManager;
    @Inject
    VaultInternalSystemBackend vaultInternalSystemBackend;

    @Override
    public Uni<VaultInit> init(int secretShares, int secretThreshold) {
        return this.vaultInternalSystemBackend.init(this.vaultClient, secretShares, secretThreshold).map(init -> new VaultInit(init.keys, init.keysBase64, init.rootToken));
    }

    @Override
    public Uni<VaultHealth> health() {
        boolean isStandByOk = this.buildTimeConfig.health().standByOk();
        boolean isPerfStandByOk = this.buildTimeConfig.health().performanceStandByOk();
        return this.health(isStandByOk, isPerfStandByOk);
    }

    @Override
    public Uni<VaultHealthStatus> healthStatus() {
        boolean isStandByOk = this.buildTimeConfig.health().standByOk();
        boolean isPerfStandByOk = this.buildTimeConfig.health().performanceStandByOk();
        return this.healthStatus(isStandByOk, isPerfStandByOk);
    }

    @Override
    public Uni<VaultSealStatus> sealStatus() {
        return this.vaultInternalSystemBackend.systemSealStatus(this.vaultClient).map(vaultSealStatusResult -> {
            VaultSealStatus vaultSealStatus = new VaultSealStatus();
            vaultSealStatus.setClusterId(vaultSealStatusResult.clusterId);
            vaultSealStatus.setClusterName(vaultSealStatusResult.clusterName);
            vaultSealStatus.setInitialized(vaultSealStatusResult.initialized);
            vaultSealStatus.setMigration(vaultSealStatusResult.migration);
            vaultSealStatus.setN(vaultSealStatusResult.n);
            vaultSealStatus.setNonce(vaultSealStatusResult.nonce);
            vaultSealStatus.setProgress(vaultSealStatusResult.progress);
            vaultSealStatus.setRecoverySeal(vaultSealStatusResult.recoverySeal);
            vaultSealStatus.setSealed(vaultSealStatusResult.sealedStatus);
            vaultSealStatus.setT(vaultSealStatusResult.t);
            vaultSealStatus.setType(vaultSealStatusResult.type);
            vaultSealStatus.setVersion(vaultSealStatusResult.version);
            return vaultSealStatus;
        });
    }

    private Uni<VaultHealthStatus> healthStatus(boolean isStandByOk, boolean isPerfStandByOk) {
        return this.vaultInternalSystemBackend.systemHealthStatus(this.vaultClient, isStandByOk, isPerfStandByOk).map(vaultHealthResult -> {
            VaultHealthStatus vaultHealthStatus = new VaultHealthStatus();
            vaultHealthStatus.setClusterId(vaultHealthResult.clusterId);
            vaultHealthStatus.setClusterName(vaultHealthResult.clusterName);
            vaultHealthStatus.setInitialized(vaultHealthResult.initialized);
            vaultHealthStatus.setPerformanceStandby(vaultHealthResult.performanceStandby);
            vaultHealthStatus.setReplicationDrMode(vaultHealthResult.replicationDrMode);
            vaultHealthStatus.setReplicationPerfMode(vaultHealthResult.replicationPerfMode);
            vaultHealthStatus.setSealed(vaultHealthResult.sealedStatus);
            vaultHealthStatus.setServerTimeUtc(vaultHealthResult.serverTimeUtc);
            vaultHealthStatus.setStandby(vaultHealthResult.standby);
            vaultHealthStatus.setVersion(vaultHealthResult.version);
            return vaultHealthStatus;
        });
    }

    private Uni<VaultHealth> health(boolean isStandByOk, boolean isPerfStandByOk) {
        return this.vaultInternalSystemBackend.systemHealth(this.vaultClient, isStandByOk, isPerfStandByOk).map(VaultHealth::new);
    }

    @Override
    public Uni<String> getPolicyRules(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getPolicy(this.vaultClient, (String)token, name).map(r -> ((VaultPolicyData)r.data).rules));
    }

    @Override
    public Uni<Void> createUpdatePolicy(String name, String policy) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.createUpdatePolicy(this.vaultClient, (String)token, name, new VaultPolicyBody(policy)));
    }

    @Override
    public Uni<Void> deletePolicy(String name) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.deletePolicy(this.vaultClient, (String)token, name));
    }

    @Override
    public Uni<List<String>> getPolicies() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.listPolicies(this.vaultClient, (String)token).map(r -> ((VaultListPolicyData)r.data).policies));
    }

    @Override
    public Uni<VaultSecretEngineInfo> getSecretEngineInfo(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getSecretEngineInfo(this.vaultClient, (String)token, mount).map(result -> {
            VaultSecretEngineInfo info = new VaultSecretEngineInfo();
            info.setDescription(((VaultSecretEngineInfoData)result.data).description);
            info.setType(((VaultSecretEngineInfoData)result.data).type);
            info.setLocal(((VaultSecretEngineInfoData)result.data).local);
            info.setExternalEntropyAccess(((VaultSecretEngineInfoData)result.data).externalEntropyAccess);
            info.setSealWrap(((VaultSecretEngineInfoData)result.data).sealWrap);
            info.setPluginVersion(((VaultSecretEngineInfoData)result.data).pluginVersion);
            info.setRunningPluginVersion(((VaultSecretEngineInfoData)result.data).runningPluginVersion);
            info.setRunningSha256(((VaultSecretEngineInfoData)result.data).runningSha256);
            info.setDefaultLeaseTimeToLive(((VaultSecretEngineInfoData)result.data).config.defaultLeaseTimeToLive);
            info.setMaxLeaseTimeToLive(((VaultSecretEngineInfoData)result.data).config.maxLeaseTimeToLive);
            info.setForceNoCache(((VaultSecretEngineInfoData)result.data).config.forceNoCache);
            info.setOptions(((VaultSecretEngineInfoData)result.data).options);
            info.setAuditNonHMACRequestKeys(((VaultSecretEngineInfoData)result.data).config.auditNonHMACRequestKeys);
            info.setAuditNonHMACResponseKeys(((VaultSecretEngineInfoData)result.data).config.auditNonHMACResponseKeys);
            info.setListingVisibility(((VaultSecretEngineInfoData)result.data).config.listingVisibility != null ? EngineListingVisibility.valueOf(((VaultSecretEngineInfoData)result.data).config.listingVisibility.toUpperCase()) : null);
            info.setPassthroughRequestHeaders(((VaultSecretEngineInfoData)result.data).config.passthroughRequestHeaders);
            info.setAllowedResponseHeaders(((VaultSecretEngineInfoData)result.data).config.allowedResponseHeaders);
            info.setAllowedManagedKeys(((VaultSecretEngineInfoData)result.data).config.allowedManagedKeys);
            return info;
        }));
    }

    @Override
    public Uni<VaultTuneInfo> getTuneInfo(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getTuneInfo(this.vaultClient, (String)token, mount).map(vaultTuneResult -> {
            VaultTuneInfo tuneInfo = new VaultTuneInfo();
            tuneInfo.setDefaultLeaseTimeToLive(((VaultTuneData)vaultTuneResult.data).defaultLeaseTimeToLive);
            tuneInfo.setMaxLeaseTimeToLive(((VaultTuneData)vaultTuneResult.data).maxLeaseTimeToLive);
            tuneInfo.setDescription(((VaultTuneData)vaultTuneResult.data).description);
            tuneInfo.setForceNoCache(((VaultTuneData)vaultTuneResult.data).forceNoCache);
            tuneInfo.setOptions(((VaultTuneData)vaultTuneResult.data).options);
            tuneInfo.setAuditNonHMACRequestKeys(((VaultTuneData)vaultTuneResult.data).auditNonHMACRequestKeys);
            tuneInfo.setAuditNonHMACResponseKeys(((VaultTuneData)vaultTuneResult.data).auditNonHMACResponseKeys);
            tuneInfo.setListingVisibility(((VaultTuneData)vaultTuneResult.data).listingVisibility != null ? EngineListingVisibility.valueOf(((VaultTuneData)vaultTuneResult.data).listingVisibility.toUpperCase()) : null);
            tuneInfo.setPassthroughRequestHeaders(((VaultTuneData)vaultTuneResult.data).passthroughRequestHeaders);
            tuneInfo.setAllowedResponseHeaders(((VaultTuneData)vaultTuneResult.data).allowedResponseHeaders);
            tuneInfo.setAllowedManagedKeys(((VaultTuneData)vaultTuneResult.data).allowedManagedKeys);
            return tuneInfo;
        }));
    }

    @Override
    public Uni<Void> updateTuneInfo(String mount, VaultTuneInfo tuneInfoUpdates) {
        VaultTuneBody body = new VaultTuneBody();
        body.description = tuneInfoUpdates.getDescription();
        body.defaultLeaseTimeToLive = tuneInfoUpdates.getDefaultLeaseTimeToLive();
        body.maxLeaseTimeToLive = tuneInfoUpdates.getMaxLeaseTimeToLive();
        body.forceNoCache = tuneInfoUpdates.getForceNoCache();
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.updateTuneInfo(this.vaultClient, (String)token, mount, body));
    }

    @Override
    public Uni<Boolean> isEngineMounted(String mount) {
        return this.getSecretEngineInfo(mount).map(i -> true).onFailure(VaultClientException.class).recoverWithUni(x -> {
            if (((VaultClientException)x).getStatus() == 405) {
                return this.getTuneInfo(mount).map(i -> true);
            }
            return Uni.createFrom().failure(x);
        }).onFailure(VaultClientException.class).recoverWithUni(x -> {
            if (((VaultClientException)x).getStatus() == 400) {
                return Uni.createFrom().item((Object)false);
            }
            return Uni.createFrom().failure(x);
        });
    }

    @Override
    public Uni<Void> enable(VaultSecretEngine engine, String mount, String description, EnableEngineOptions options) {
        return this.enable(engine.getType(), mount, description, options);
    }

    @Override
    public Uni<Void> enable(String engineType, String mount, String description, EnableEngineOptions options) {
        VaultEnableEngineBody body = new VaultEnableEngineBody();
        body.type = engineType;
        body.description = description;
        body.config = new VaultEnableEngineBody.Config();
        body.config.defaultLeaseTimeToLive = options.defaultLeaseTimeToLive;
        body.config.maxLeaseTimeToLive = options.maxLeaseTimeToLive;
        body.config.forceNoCache = options.forceNoCache;
        body.config.auditNonHMACRequestKeys = options.auditNonHMACRequestKeys;
        body.config.auditNonHMACResponseKeys = options.auditNonHMACResponseKeys;
        body.config.listingVisibility = options.listingVisibility != null ? options.listingVisibility.name().toLowerCase() : null;
        body.config.passthroughRequestHeaders = options.passthroughRequestHeaders;
        body.config.allowedResponseHeaders = options.allowedResponseHeaders;
        body.config.pluginVersion = options.pluginVersion;
        body.config.allowedManagedKeys = options.allowedManagedKeys;
        body.options = options.options;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.enableEngine(this.vaultClient, (String)token, mount, body));
    }

    @Override
    public Uni<Void> disable(String mount) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.disableEngine(this.vaultClient, (String)token, mount));
    }

    @Override
    public Uni<VaultPlugins> listPlugins() {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.listPlugins(this.vaultClient, (String)token).map(r -> new VaultPlugins().setAuth(((VaultListAllPluginsData)r.data).auth).setDatabase(((VaultListAllPluginsData)r.data).database).setSecret(((VaultListAllPluginsData)r.data).secret).setDetailed(((VaultListAllPluginsData)r.data).detailed.stream().map(d -> new VaultPluginDetails().setBuiltin(d.builtin).setDeprecationStatus(d.deprecationStatus).setName(d.name).setType(d.type).setVersion(d.version).setSha256(d.sha256).setCommand(d.command).setArgs(d.args).setEnv(d.env)).collect(Collectors.toList()))));
    }

    @Override
    public Uni<List<String>> listPlugins(String type) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.listPlugins(this.vaultClient, (String)token, type).map(r -> ((VaultListPluginsData)r.data).keys));
    }

    @Override
    public Uni<VaultPluginDetails> getPluginDetails(String type, String name, @Nullable String version) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.getPluginDetails(this.vaultClient, (String)token, type, name, version).map(r -> new VaultPluginDetails().setBuiltin(((VaultPluginDetailsData)r.data).builtin).setDeprecationStatus(((VaultPluginDetailsData)r.data).deprecationStatus).setName(((VaultPluginDetailsData)r.data).name).setType(((VaultPluginDetailsData)r.data).type).setVersion(((VaultPluginDetailsData)r.data).version).setSha256(((VaultPluginDetailsData)r.data).sha256).setCommand(((VaultPluginDetailsData)r.data).command).setArgs(((VaultPluginDetailsData)r.data).args).setEnv(((VaultPluginDetailsData)r.data).env))).onFailure(VaultClientException.class).recoverWithUni(x -> {
            VaultClientException vx = (VaultClientException)x;
            if (vx.getStatus() == 404) {
                return Uni.createFrom().nullItem();
            }
            return Uni.createFrom().failure(x);
        });
    }

    @Override
    public Uni<Void> registerPlugin(String type, String name, @Nullable String version, String sha256, String command, @Nullable List<String> args, @Nullable List<String> env) {
        VaultRegisterPluginBody body = new VaultRegisterPluginBody();
        body.version = version;
        body.sha256 = sha256;
        body.command = command;
        body.args = args;
        body.env = env;
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.registerPlugin(this.vaultClient, (String)token, type, name, body));
    }

    @Override
    public Uni<Void> removePlugin(String type, String name, @Nullable String version) {
        return this.vaultAuthManager.getClientToken(this.vaultClient).flatMap(token -> this.vaultInternalSystemBackend.removePlugin(this.vaultClient, (String)token, type, name, version));
    }
}

