/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.MutinyVertxClientFactory;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.client.Shared;
import io.quarkus.vault.runtime.client.VertxVaultClient;
import io.vertx.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;

@Singleton
@Shared
public class SharedVertxVaultClient
extends VertxVaultClient {
    private final AtomicReference<WebClient> webClient = new AtomicReference();

    @Produces
    @Dependent
    public static VertxVaultClient createSharedVaultClient(Instance<io.vertx.mutiny.core.Vertx> vertx) {
        AnnotationLiteral clientType = vertx.isResolvable() ? Shared.Literal.INSTANCE : Private.Literal.INSTANCE;
        return (VertxVaultClient)Arc.container().select(VertxVaultClient.class, new Annotation[]{clientType}).get();
    }

    public SharedVertxVaultClient(VaultConfigHolder vaultConfigHolder, io.vertx.mutiny.core.Vertx quarkusMutinyVertx, TlsConfig tlsConfig) {
        super(vaultConfigHolder.getVaultRuntimeConfig().url().orElseThrow(() -> new VaultException("no vault url provided")), vaultConfigHolder.getVaultRuntimeConfig().enterprise().namespace(), vaultConfigHolder.getVaultRuntimeConfig().readTimeout());
        io.vertx.mutiny.core.Vertx vertx = io.vertx.mutiny.core.Vertx.newInstance((Vertx)quarkusMutinyVertx.getDelegate());
        this.webClient.set(MutinyVertxClientFactory.createHttpClient(vertx, vaultConfigHolder.getVaultRuntimeConfig(), tlsConfig));
    }

    @Override
    protected WebClient getWebClient() {
        return this.webClient.get();
    }

    @Override
    @PreDestroy
    public void close() {
        WebClient webClient = this.webClient.getAndSet(null);
        if (webClient != null) {
            webClient.close();
        }
    }
}

