/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvListSecrets;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretJsonV1;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.util.Map;

@Singleton
public class VaultInternalKvV1SecretEngine
extends VaultInternalBase {
    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [KV (v1)]";
    }

    public Uni<Void> deleteSecret(VaultClient vaultClient, String token, String secretEnginePath, String path) {
        return vaultClient.delete(this.opName("Delete Secret"), secretEnginePath + "/" + path, token, 204);
    }

    public Uni<Void> writeSecret(VaultClient vaultClient, String token, String secretEnginePath, String path, Map<String, String> secret) {
        return vaultClient.post(this.opName("Write Secret"), secretEnginePath + "/" + path, token, secret, null, 204);
    }

    public Uni<VaultKvSecretJsonV1> getSecretJson(VaultClient vaultClient, String token, String secretEnginePath, String path) {
        return vaultClient.get(this.opName("Get Secret"), secretEnginePath + "/" + path, token, VaultKvSecretJsonV1.class);
    }

    public Uni<VaultKvListSecrets> listSecrets(VaultClient vaultClient, String token, String secretEnginePath, String path) {
        return vaultClient.list(this.opName("List Secrets"), secretEnginePath + "/" + path, token, VaultKvListSecrets.class);
    }
}

