/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICRLRotateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateListResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCRLData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCRLResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigURLsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigURLsResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRoleOptionsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRoleReadResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRolesListResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISetSignedIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKITidyBody;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.buffer.Buffer;
import jakarta.inject.Singleton;

@Singleton
public class VaultInternalPKISecretEngine
extends VaultInternalBase {
    @Override
    protected String opNamePrefix() {
        return super.opNamePrefix() + " [PKI]";
    }

    private String getPath(String mount, String path) {
        return mount + "/" + path;
    }

    public Uni<Buffer> getCertificateAuthority(VaultClient vaultClient, String token, String mount, String format) {
        return this.getRaw(vaultClient, this.opName("Get CA"), token, mount, "ca", format);
    }

    public Uni<Buffer> getCertificateRevocationList(VaultClient vaultClient, String token, String mount, String format) {
        return this.getRaw(vaultClient, this.opName("Get CRL"), token, mount, "crl", format);
    }

    public Uni<Buffer> getCertificateAuthorityChain(VaultClient vaultClient, String token, String mount) {
        return this.getRaw(vaultClient, this.opName("Get CA Chain"), token, mount, "ca_chain", null);
    }

    private Uni<Buffer> getRaw(VaultClient vaultClient, String operationName, String token, String mount, String path, String format) {
        Object suffix = format != null ? "/" + format : "";
        return vaultClient.get(operationName, this.getPath(mount, path + (String)suffix), token).replaceIfNullWith((Object)Buffer.buffer());
    }

    public Uni<VaultPKICertificateResult> getCertificate(VaultClient vaultClient, String token, String mount, String serial) {
        return vaultClient.get(this.opName("Get Certificate"), this.getPath(mount, "cert/" + serial), token, VaultPKICertificateResult.class);
    }

    public Uni<VaultPKICertificateListResult> listCertificates(VaultClient vaultClient, String token, String mount) {
        return vaultClient.list(this.opName("List Certificates"), this.getPath(mount, "certs"), token, VaultPKICertificateListResult.class);
    }

    public Uni<Void> configCertificateAuthority(VaultClient vaultClient, String token, String mount, VaultPKIConfigCABody body) {
        return vaultClient.post(this.opName("Configure CA"), this.getPath(mount, "config/ca"), token, (Object)body, 204);
    }

    public Uni<VaultPKICRLRotateResult> rotateCertificateRevocationList(VaultClient vaultClient, String token, String mount) {
        return vaultClient.get(this.opName("Rotate CRL"), this.getPath(mount, "crl/rotate"), token, VaultPKICRLRotateResult.class);
    }

    public Uni<VaultPKIGenerateCertificateResult> generateCertificate(VaultClient vaultClient, String token, String mount, String role, VaultPKIGenerateCertificateBody body) {
        return vaultClient.post(this.opName("Issue Certificate"), this.getPath(mount, "issue/" + role), token, (Object)body, VaultPKIGenerateCertificateResult.class);
    }

    public Uni<VaultPKISignCertificateRequestResult> signCertificate(VaultClient vaultClient, String token, String mount, String role, VaultPKISignCertificateRequestBody body) {
        return vaultClient.post(this.opName("Sign Certificate"), this.getPath(mount, "sign/" + role), token, (Object)body, VaultPKISignCertificateRequestResult.class);
    }

    public Uni<VaultPKIRevokeCertificateResult> revokeCertificate(VaultClient vaultClient, String token, String mount, VaultPKIRevokeCertificateBody body) {
        return vaultClient.post(this.opName("Revoke Certificate"), this.getPath(mount, "revoke"), token, (Object)body, VaultPKIRevokeCertificateResult.class);
    }

    public Uni<Void> updateRole(VaultClient vaultClient, String token, String mount, String role, VaultPKIRoleOptionsData body) {
        return vaultClient.post(this.opName("Update Role"), this.getPath(mount, "roles/" + role), token, (Object)body, 204);
    }

    public Uni<VaultPKIRoleReadResult> readRole(VaultClient vaultClient, String token, String mount, String role) {
        return vaultClient.get(this.opName("Read Role"), this.getPath(mount, "roles/" + role), token, VaultPKIRoleReadResult.class);
    }

    public Uni<VaultPKIRolesListResult> listRoles(VaultClient vaultClient, String token, String mount) {
        return vaultClient.list(this.opName("List Roles"), this.getPath(mount, "roles"), token, VaultPKIRolesListResult.class);
    }

    public Uni<Void> deleteRole(VaultClient vaultClient, String token, String mount, String role) {
        return vaultClient.delete(this.opName("Delete Role"), this.getPath(mount, "roles/" + role), token, 204);
    }

    public Uni<VaultPKIGenerateRootResult> generateRoot(VaultClient vaultClient, String token, String mount, String type, VaultPKIGenerateRootBody body) {
        return vaultClient.post(this.opName("Generate Root CA"), this.getPath(mount, "root/generate/" + type), token, (Object)body, VaultPKIGenerateRootResult.class);
    }

    public Uni<Void> deleteRoot(VaultClient vaultClient, String token, String mount) {
        return vaultClient.delete(this.opName("Delete Root CA"), this.getPath(mount, "root"), token, 204);
    }

    public Uni<VaultPKISignCertificateRequestResult> signIntermediateCA(VaultClient vaultClient, String token, String mount, VaultPKISignIntermediateCABody body) {
        return vaultClient.post(this.opName("Sign Intermediate CA"), this.getPath(mount, "root/sign-intermediate"), token, (Object)body, VaultPKISignCertificateRequestResult.class);
    }

    public Uni<VaultPKIGenerateIntermediateCSRResult> generateIntermediateCSR(VaultClient vaultClient, String token, String mount, String type, VaultPKIGenerateIntermediateCSRBody body) {
        return vaultClient.post(this.opName("Generate Intermediate CSR"), this.getPath(mount, "intermediate/generate/" + type), token, (Object)body, VaultPKIGenerateIntermediateCSRResult.class);
    }

    public Uni<Void> setSignedIntermediateCA(VaultClient vaultClient, String token, String mount, VaultPKISetSignedIntermediateCABody body) {
        return vaultClient.post(this.opName("Update Signed Intermediate CA"), this.getPath(mount, "intermediate/set-signed"), token, (Object)body, 204);
    }

    public Uni<Void> tidy(VaultClient vaultClient, String token, String mount, VaultPKITidyBody body) {
        return vaultClient.post(this.opName("Tidy"), this.getPath(mount, "tidy"), token, (Object)body, 202);
    }

    public Uni<Void> configURLs(VaultClient vaultClient, String token, String mount, VaultPKIConfigURLsData body) {
        return vaultClient.post(this.opName("Configure URLs"), this.getPath(mount, "config/urls"), token, (Object)body, 204);
    }

    public Uni<VaultPKIConfigURLsResult> readURLs(VaultClient vaultClient, String token, String mount) {
        return vaultClient.get(this.opName("Read URLs"), this.getPath(mount, "config/urls"), token, VaultPKIConfigURLsResult.class);
    }

    public Uni<Void> configCRL(VaultClient vaultClient, String token, String mount, VaultPKIConfigCRLData body) {
        return vaultClient.post(this.opName("Configure CRL"), this.getPath(mount, "config/crl"), token, (Object)body, 204);
    }

    public Uni<VaultPKIConfigCRLResult> readCRL(VaultClient vaultClient, String token, String mount) {
        return vaultClient.get(this.opName("Read CRL"), this.getPath(mount, "config/crl"), token, VaultPKIConfigCRLResult.class);
    }
}

