/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKubernetesAuthReactiveService;
import io.quarkus.vault.auth.VaultKubernetesAuthConfig;
import io.quarkus.vault.auth.VaultKubernetesAuthRole;
import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetes;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesConfigureParams;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultTokenType;
import io.quarkus.vault.runtime.DurationHelper;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;

@ApplicationScoped
public class VaultKubernetesAuthManager
implements VaultKubernetesAuthReactiveService {
    private final VaultAuthKubernetes k8s;

    @Inject
    public VaultKubernetesAuthManager(VaultClient client, VaultConfigHolder configHolder) {
        this.k8s = client.auth().kubernetes(configHolder.getVaultRuntimeConfig().authentication().kubernetes().authMountPath());
    }

    @Override
    public Uni<Void> configure(VaultKubernetesAuthConfig config) {
        VaultAuthKubernetesConfigureParams params = new VaultAuthKubernetesConfigureParams().setIssuer(config.issuer).setKubernetesCaCert(config.kubernetesCaCert).setKubernetesHost(config.kubernetesHost).setPemKeys(config.pemKeys).setTokenReviewerJwt(config.tokenReviewerJwt);
        return Uni.createFrom().completionStage(this.k8s.configure(params));
    }

    @Override
    public Uni<VaultKubernetesAuthConfig> getConfig() {
        return Uni.createFrom().completionStage(this.k8s.readConfig()).map(result -> new VaultKubernetesAuthConfig().setKubernetesCaCert(result.getKubernetesCaCert()).setKubernetesHost(result.getKubernetesHost()).setIssuer(result.getIssuer()).setPemKeys(result.getPemKeys()).setTokenReviewerJwt(result.getTokenReviewerJwt()));
    }

    @Override
    public Uni<VaultKubernetesAuthRole> getRole(String name) {
        return Uni.createFrom().completionStage(this.k8s.readRole(name)).map(result -> new VaultKubernetesAuthRole().setBoundServiceAccountNames(result.getBoundServiceAccountNames()).setBoundServiceAccountNamespaces(result.getBoundServiceAccountNamespaces()).setAudience(result.getAudience()).setTokenTtl(DurationHelper.toDurationSeconds(result.getTokenTtl())).setTokenMaxTtl(DurationHelper.toDurationSeconds(result.getTokenMaxTtl())).setTokenPolicies(result.getTokenPolicies()).setTokenBoundCidrs(result.getTokenBoundCidrs()).setTokenExplicitMaxTtl(DurationHelper.toDurationSeconds(result.getTokenExplicitMaxTtl())).setTokenNoDefaultPolicy(result.isTokenNoDefaultPolicy()).setTokenNumUses(result.getTokenNumUses()).setTokenPeriod(DurationHelper.toDurationSeconds(result.getTokenPeriod())).setTokenType(result.getTokenType() != null ? result.getTokenType().getValue() : null));
    }

    @Override
    public Uni<Void> createRole(String name, VaultKubernetesAuthRole role) {
        VaultAuthKubernetesUpdateRoleParams params = new VaultAuthKubernetesUpdateRoleParams().setBoundServiceAccountNames(role.boundServiceAccountNames).setBoundServiceAccountNamespaces(role.boundServiceAccountNamespaces).setAudience(role.audience).setTokenTtl(DurationHelper.fromVaultDuration(role.tokenTtl)).setTokenMaxTtl(DurationHelper.fromVaultDuration(role.tokenMaxTtl)).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(DurationHelper.fromVaultDuration(role.tokenExplicitMaxTtl)).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(DurationHelper.fromVaultDuration(role.tokenPeriod)).setTokenType(VaultTokenType.from((String)role.tokenType));
        return Uni.createFrom().completionStage(this.k8s.updateRole(name, params));
    }

    @Override
    public Uni<List<String>> getRoles() {
        return Uni.createFrom().completionStage(this.k8s.listRoles());
    }

    @Override
    public Uni<Void> deleteRole(String name) {
        return Uni.createFrom().completionStage(this.k8s.deleteRole(name));
    }
}

