/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.client.auth.VaultAppRoleAuthOptions;
import io.quarkus.vault.client.auth.VaultKubernetesAuthOptions;
import io.quarkus.vault.client.auth.VaultStaticClientTokenAuthOptions;
import io.quarkus.vault.client.auth.VaultUserPassAuthOptions;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.http.VaultHttpClient;
import io.quarkus.vault.client.http.jdk.JDKVaultHttpClient;
import io.quarkus.vault.client.http.vertx.VertxVaultHttpClient;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.JDKClientFactory;
import io.quarkus.vault.runtime.client.MutinyVertxClientFactory;
import io.quarkus.vault.runtime.client.Private;
import io.quarkus.vault.runtime.config.VaultAppRoleAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultKubernetesAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.quarkus.vault.runtime.config.VaultUserpassAuthenticationConfig;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.net.http.HttpClient;
import java.nio.file.Path;

@Singleton
public class VaultClientProducer {
    @Produces
    @Singleton
    @Private
    public VaultClient privateVaultClient(VaultConfigHolder vaultConfigHolder, TlsConfig tlsConfig) {
        VaultRuntimeConfig config = vaultConfigHolder.getVaultRuntimeConfig();
        HttpClient httpClient = JDKClientFactory.createHttpClient(config, tlsConfig);
        JDKVaultHttpClient vaultHttpClient = new JDKVaultHttpClient(httpClient);
        return this.createVaultClient((VaultHttpClient)vaultHttpClient, config);
    }

    @Produces
    @Singleton
    public VaultClient sharedVaultClient(Vertx vertx, VaultConfigHolder vaultConfigHolder, TlsConfig tlsConfig) {
        VaultRuntimeConfig config = vaultConfigHolder.getVaultRuntimeConfig();
        WebClient webClient = MutinyVertxClientFactory.createHttpClient(vertx, config, tlsConfig);
        VertxVaultHttpClient vaultHttpClient = new VertxVaultHttpClient(webClient);
        return this.createVaultClient((VaultHttpClient)vaultHttpClient, config);
    }

    VaultClient createVaultClient(VaultHttpClient vaultHttpClient, VaultRuntimeConfig config) {
        VaultClient.Builder vaultClientBuilder = VaultClient.builder().baseUrl(config.url().orElseThrow(() -> new VaultException("no vault url provided"))).executor((VaultRequestExecutor)vaultHttpClient).requestTimeout(config.readTimeout()).logConfidentialityLevel(config.logConfidentialityLevel());
        this.configureAuthentication(vaultClientBuilder, config);
        if (config.enterprise().namespace().isPresent()) {
            vaultClientBuilder.namespace(config.enterprise().namespace().orElseThrow());
        }
        return vaultClientBuilder.build();
    }

    void configureAuthentication(VaultClient.Builder builder, VaultRuntimeConfig config) {
        VaultAuthenticationConfig authConfig = config.authentication();
        if (authConfig.isDirectClientToken()) {
            if (authConfig.clientTokenWrappingToken().isPresent()) {
                builder.clientToken(VaultStaticClientTokenAuthOptions.builder().unwrappingToken(authConfig.clientTokenWrappingToken().orElseThrow()).build());
            } else {
                builder.clientToken(authConfig.clientToken().orElseThrow());
            }
        } else {
            switch (config.getAuthenticationType()) {
                case KUBERNETES: {
                    VaultKubernetesAuthenticationConfig k8sConfig = authConfig.kubernetes();
                    builder.kubernetes(VaultKubernetesAuthOptions.builder().mountPath(k8sConfig.authMountPath()).role(k8sConfig.role().orElseThrow()).jwtTokenPath(Path.of(k8sConfig.jwtTokenPath(), new String[0])).caching(config.renewGracePeriod()).build());
                    break;
                }
                case APPROLE: {
                    VaultAppRoleAuthenticationConfig appRoleConfig = authConfig.appRole();
                    VaultAppRoleAuthOptions.Builder appRoleOptions = VaultAppRoleAuthOptions.builder().mountPath(appRoleConfig.authMountPath()).roleId(appRoleConfig.roleId().orElseThrow());
                    if (appRoleConfig.secretIdWrappingToken().isPresent()) {
                        appRoleOptions.unwrappingSecretId(appRoleConfig.secretIdWrappingToken().orElseThrow());
                    } else {
                        appRoleOptions.secretId(appRoleConfig.secretId().orElseThrow());
                    }
                    builder.appRole(appRoleOptions.build());
                    break;
                }
                case USERPASS: {
                    VaultUserpassAuthenticationConfig userPassConfig = authConfig.userpass();
                    VaultUserPassAuthOptions.Builder userPassOptions = VaultUserPassAuthOptions.builder().mountPath(userPassConfig.authMountPath()).username(userPassConfig.username().orElseThrow());
                    if (userPassConfig.passwordWrappingToken().isPresent()) {
                        userPassOptions.unwrappingPassword(userPassConfig.passwordWrappingToken().orElseThrow(), config.kvSecretEngineVersion());
                    } else {
                        userPassOptions.password(userPassConfig.password().orElseThrow());
                    }
                    userPassOptions.caching(config.renewGracePeriod());
                    builder.userPass(userPassOptions.build());
                    break;
                }
                default: {
                    throw new VaultException("Unsupported authentication type: " + config.getAuthenticationType());
                }
            }
        }
    }
}

