/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.api.common.VaultAnyResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.common.VaultResultExtractor;
import io.quarkus.vault.runtime.LeaseBase;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicCredentials;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

@Singleton
public class VaultDynamicCredentialsManager {
    private static final Logger log = Logger.getLogger((String)VaultDynamicCredentialsManager.class.getName());
    private final ConcurrentHashMap<String, VaultDynamicCredentials> credentialsCache = new ConcurrentHashMap();
    private final VaultClient vaultClient;
    private final VaultConfigHolder vaultConfigHolder;

    public VaultDynamicCredentialsManager(VaultClient vaultClient, VaultConfigHolder vaultConfigHolder) {
        this.vaultClient = vaultClient;
        this.vaultConfigHolder = vaultConfigHolder;
    }

    private String getCredentialsPath(String mount, String requestPath) {
        return mount + "/" + requestPath;
    }

    private String getCredentialsCacheKey(String mount, String requestPath, String role) {
        return this.getCredentialsPath(mount, requestPath) + "@" + role;
    }

    VaultDynamicCredentials getCachedCredentials(String mount, String requestPath, String role) {
        return this.credentialsCache.get(this.getCredentialsCacheKey(mount, requestPath, role));
    }

    void putCachedCredentials(String mount, String requestPath, String role, VaultDynamicCredentials credentials) {
        this.credentialsCache.put(this.getCredentialsCacheKey(mount, requestPath, role), credentials);
    }

    private VaultRuntimeConfig getConfig() {
        return this.vaultConfigHolder.getVaultRuntimeConfig();
    }

    public Uni<Map<String, String>> getDynamicCredentials(String mount, String requestPath, String role) {
        VaultDynamicCredentials currentCredentials = this.getCachedCredentials(mount, requestPath, role);
        return this.getCredentials(currentCredentials, mount, requestPath, role).map(credentials -> {
            this.putCachedCredentials(mount, requestPath, role, (VaultDynamicCredentials)credentials);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("user", credentials.username);
            properties.put("password", credentials.password);
            properties.put("expires-at", credentials.getExpireInstant().toString());
            return properties;
        });
    }

    public Uni<VaultDynamicCredentials> getCredentials(VaultDynamicCredentials currentCredentials, String mount, String requestPath, String role) {
        return Uni.createFrom().item(Optional.ofNullable(currentCredentials)).flatMap(this::validate).flatMap(credentials -> {
            if (credentials.isPresent() && ((VaultDynamicCredentials)credentials.get()).shouldExtend(this.getConfig().renewGracePeriod())) {
                return this.extend((VaultDynamicCredentials)credentials.get(), mount, requestPath, role).map(Optional::of);
            }
            return Uni.createFrom().item(credentials);
        }).flatMap(credentials -> {
            if (credentials.isEmpty() || ((VaultDynamicCredentials)credentials.get()).isExpired() || ((VaultDynamicCredentials)credentials.get()).expiresSoon(this.getConfig().renewGracePeriod())) {
                return this.create(mount, requestPath, role);
            }
            return Uni.createFrom().item((Object)((VaultDynamicCredentials)credentials.get()));
        });
    }

    private Uni<Optional<VaultDynamicCredentials>> validate(Optional<VaultDynamicCredentials> credentials) {
        if (credentials.isEmpty()) {
            return Uni.createFrom().item(Optional.empty());
        }
        return Uni.createFrom().completionStage(this.vaultClient.sys().leases().read(credentials.get().leaseId)).map(ignored -> credentials).onFailure(VaultClientException.class).recoverWithUni(e -> {
            if (((VaultClientException)e).getStatus() == 400) {
                log.debug((Object)("lease " + ((VaultDynamicCredentials)credentials.get()).leaseId + " has become invalid"));
                return Uni.createFrom().item(Optional.empty());
            }
            return Uni.createFrom().failure(e);
        });
    }

    private Uni<VaultDynamicCredentials> extend(VaultDynamicCredentials currentCredentials, String mount, String requestPath, String role) {
        return Uni.createFrom().completionStage(this.vaultClient.sys().leases().renew(currentCredentials.leaseId, null)).map(vaultRenewLease -> {
            LeaseBase lease = new LeaseBase(vaultRenewLease.getLeaseId(), vaultRenewLease.isRenewable(), vaultRenewLease.getLeaseDuration().toSeconds());
            VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, currentCredentials.username, currentCredentials.password);
            this.sanityCheck(credentials, mount, requestPath, role);
            log.debug((Object)("extended " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel())));
            return credentials;
        });
    }

    private Uni<VaultDynamicCredentials> create(String mount, String requestPath, String role) {
        VaultRequest request = VaultRequest.get((String)String.format("[DYN-CREDS (%s)] Generate for %s", mount, role)).path(new Object[]{mount, requestPath, role}).expectOkStatus().build((VaultResultExtractor)VaultLeasedResultExtractor.of(VaultAnyResult.class));
        return Uni.createFrom().completionStage(this.vaultClient.execute(request)).map(VaultResponse::getResult).map(creds -> {
            Map data = (Map)creds.getData();
            LeaseBase lease = new LeaseBase(creds.getLeaseId(), creds.isRenewable(), creds.getLeaseDuration().toSeconds());
            VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, data.get("username").toString(), data.get("password").toString());
            log.debug((Object)("generated " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel())));
            this.sanityCheck(credentials, mount, requestPath, role);
            return credentials;
        });
    }

    private void sanityCheck(VaultDynamicCredentials credentials, String mount, String requestPath, String role) {
        credentials.leaseDurationSanityCheck(role + " (" + this.getCredentialsPath(mount, requestPath) + ")", this.getConfig().renewGracePeriod());
    }
}

