/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.transit;

import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.runtime.transit.VaultTransitBatchResult;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class VaultBatchException
extends VaultException {
    protected <K, V extends VaultTransitBatchResult, T> Map<K, T> filter(Map<K, V> results, Predicate<V> predicate, Function<V, T> function) {
        return results.entrySet().stream().filter(entry -> predicate.test((VaultTransitBatchResult)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> function.apply((VaultTransitBatchResult)entry.getValue())));
    }

    protected <K, V extends VaultTransitBatchResult> Map<K, String> getErrors(Map<K, V> results) {
        return this.filter(results, VaultTransitBatchResult::isInError, VaultTransitBatchResult::getError);
    }

    protected <K, V extends VaultTransitBatchResult, T> Map<K, T> getValid(Map<K, V> results) {
        return this.filter(results, VaultTransitBatchResult::isValid, VaultTransitBatchResult::getValue);
    }

    public VaultBatchException(String message) {
        super(message);
    }
}

