/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultKVSecretReactiveEngine;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class VaultKVSecretEngine {
    private final VaultKVSecretReactiveEngine engine;

    @Inject
    public VaultKVSecretEngine(VaultKVSecretReactiveEngine engine) {
        this.engine = engine;
    }

    public Map<String, String> readSecret(String path) {
        return (Map)this.engine.readSecret(path).await().indefinitely();
    }

    public Map<String, Object> readSecretJson(String path) {
        return (Map)this.engine.readSecretJson(path).await().indefinitely();
    }

    public void writeSecret(String path, Map<String, String> secret) {
        this.engine.writeSecret(path, secret).await().indefinitely();
    }

    public void deleteSecret(String path) {
        this.engine.deleteSecret(path).await().indefinitely();
    }

    public List<String> listSecrets(String path) {
        return (List)this.engine.listSecrets(path).await().indefinitely();
    }
}

