/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.vault.VaultTransitSecretReactiveEngine;
import io.quarkus.vault.transit.ClearData;
import io.quarkus.vault.transit.DecryptionRequest;
import io.quarkus.vault.transit.EncryptionRequest;
import io.quarkus.vault.transit.KeyConfigRequestDetail;
import io.quarkus.vault.transit.KeyCreationRequestDetail;
import io.quarkus.vault.transit.RewrappingRequest;
import io.quarkus.vault.transit.SignVerifyOptions;
import io.quarkus.vault.transit.SigningInput;
import io.quarkus.vault.transit.SigningRequest;
import io.quarkus.vault.transit.TransitContext;
import io.quarkus.vault.transit.VaultTransitDataKey;
import io.quarkus.vault.transit.VaultTransitDataKeyRequestDetail;
import io.quarkus.vault.transit.VaultTransitDataKeyType;
import io.quarkus.vault.transit.VaultTransitExportKeyType;
import io.quarkus.vault.transit.VaultTransitKeyDetail;
import io.quarkus.vault.transit.VaultTransitKeyExportDetail;
import io.quarkus.vault.transit.VerificationRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ApplicationScoped
public class VaultTransitSecretEngine {
    private final VaultTransitSecretReactiveEngine engine;

    @Inject
    public VaultTransitSecretEngine(VaultTransitSecretReactiveEngine engine) {
        this.engine = engine;
    }

    public String encrypt(String keyName, String clearData) {
        return (String)this.engine.encrypt(keyName, clearData).await().indefinitely();
    }

    public String encrypt(String keyName, ClearData clearData, TransitContext transitContext) {
        return (String)this.engine.encrypt(keyName, clearData, transitContext).await().indefinitely();
    }

    public Map<EncryptionRequest, String> encrypt(String keyName, List<EncryptionRequest> requests) {
        return (Map)this.engine.encrypt(keyName, requests).await().indefinitely();
    }

    public ClearData decrypt(String keyName, String ciphertext) {
        return (ClearData)this.engine.decrypt(keyName, ciphertext).await().indefinitely();
    }

    public ClearData decrypt(String keyName, String ciphertext, TransitContext transitContext) {
        return (ClearData)this.engine.decrypt(keyName, ciphertext, transitContext).await().indefinitely();
    }

    public Map<DecryptionRequest, ClearData> decrypt(String keyName, List<DecryptionRequest> requests) {
        return (Map)this.engine.decrypt(keyName, requests).await().indefinitely();
    }

    public String rewrap(String keyName, String ciphertext) {
        return (String)this.engine.rewrap(keyName, ciphertext).await().indefinitely();
    }

    public String rewrap(String keyName, String ciphertext, TransitContext transitContext) {
        return (String)this.engine.rewrap(keyName, ciphertext, transitContext).await().indefinitely();
    }

    public Map<RewrappingRequest, String> rewrap(String keyName, List<RewrappingRequest> requests) {
        return (Map)this.engine.rewrap(keyName, requests).await().indefinitely();
    }

    public String sign(String keyName, String input) {
        return (String)this.engine.sign(keyName, input).await().indefinitely();
    }

    public String sign(String keyName, SigningInput input, TransitContext transitContext) {
        return (String)this.engine.sign(keyName, input, transitContext).await().indefinitely();
    }

    public String sign(String keyName, SigningInput input, SignVerifyOptions options, TransitContext transitContext) {
        return (String)this.engine.sign(keyName, input, options, transitContext).await().indefinitely();
    }

    public Map<SigningRequest, String> sign(String keyName, List<SigningRequest> requests) {
        return (Map)this.engine.sign(keyName, requests).await().indefinitely();
    }

    public Map<SigningRequest, String> sign(String keyName, List<SigningRequest> requests, SignVerifyOptions options) {
        return (Map)this.engine.sign(keyName, requests, options).await().indefinitely();
    }

    public void verifySignature(String keyName, String signature, String input) {
        this.engine.verifySignature(keyName, signature, input).await().indefinitely();
    }

    public void verifySignature(String keyName, String signature, SigningInput input, TransitContext transitContext) {
        this.engine.verifySignature(keyName, signature, input, transitContext).await().indefinitely();
    }

    public void verifySignature(String keyName, String signature, SigningInput input, SignVerifyOptions options, TransitContext transitContext) {
        this.engine.verifySignature(keyName, signature, input, options, transitContext).await().indefinitely();
    }

    public void verifySignature(String keyName, List<VerificationRequest> requests) {
        this.engine.verifySignature(keyName, requests).await().indefinitely();
    }

    public void verifySignature(String keyName, List<VerificationRequest> requests, SignVerifyOptions options) {
        this.engine.verifySignature(keyName, requests, options).await().indefinitely();
    }

    public void createKey(String keyName, KeyCreationRequestDetail detail) {
        this.engine.createKey(keyName, detail).await().indefinitely();
    }

    public void updateKeyConfiguration(String keyName, KeyConfigRequestDetail detail) {
        this.engine.updateKeyConfiguration(keyName, detail).await().indefinitely();
    }

    public void rotateKey(String keyName) {
        this.engine.rotateKey(keyName).await().indefinitely();
    }

    public void deleteKey(String keyName) {
        this.engine.deleteKey(keyName).await().indefinitely();
    }

    public VaultTransitKeyExportDetail exportKey(String keyName, VaultTransitExportKeyType keyType, String keyVersion) {
        return (VaultTransitKeyExportDetail)this.engine.exportKey(keyName, keyType, keyVersion).await().indefinitely();
    }

    public Optional<VaultTransitKeyDetail<?>> readKey(String keyName) {
        return (Optional)this.engine.readKey(keyName).await().indefinitely();
    }

    public List<String> listKeys() {
        return (List)this.engine.listKeys().await().indefinitely();
    }

    public VaultTransitDataKey generateDataKey(VaultTransitDataKeyType type, String keyName, VaultTransitDataKeyRequestDetail detail) {
        return (VaultTransitDataKey)this.engine.generateDataKey(type, keyName, detail).await().indefinitely();
    }
}

