/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public abstract class TimeLimitedBase {
    private static final Logger log = Logger.getLogger((String)TimeLimitedBase.class.getName());
    Supplier<Instant> nowSupplier = () -> Instant.now();
    Instant created = this.created();
    public boolean renewable;
    public long leaseDurationSecs;

    public TimeLimitedBase(boolean renewable, long leaseDurationSecs) {
        this.renewable = renewable;
        this.leaseDurationSecs = leaseDurationSecs;
    }

    public TimeLimitedBase(TimeLimitedBase other) {
        this.renewable = other.renewable;
        this.leaseDurationSecs = other.leaseDurationSecs;
    }

    public boolean isExpired() {
        return this.now().isAfter(this.getExpireInstant());
    }

    public boolean shouldExtend(Duration gracePeriod) {
        return !this.isExpired() && this.renewable && this.now().plus(gracePeriod).isAfter(this.getExpireInstant());
    }

    private Instant created() {
        return this.now();
    }

    private Instant now() {
        return this.nowSupplier.get();
    }

    public Instant getExpireInstant() {
        return this.created.plusSeconds(this.leaseDurationSecs);
    }

    public Date getExpiredDate() {
        return new Date(this.getExpireInstant().toEpochMilli());
    }

    public boolean expiresSoon(Duration gracePeriod) {
        return this.leaseDurationSecs < gracePeriod.getSeconds();
    }

    public String info() {
        return "renewable: " + this.renewable + ", leaseDuration: " + this.leaseDurationSecs + "s, valid_until: " + String.valueOf(this.getExpiredDate());
    }

    public void leaseDurationSanityCheck(String nickname, Duration gracePeriod) {
        if (this.leaseDurationSecs < gracePeriod.getSeconds()) {
            log.warn((Object)(nickname + " lease duration " + this.leaseDurationSecs + "s is smaller than the renew grace period " + gracePeriod.getSeconds() + "s"));
        }
    }
}

