/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultPKISecretReactiveEngine;
import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKI;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigCrlParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigUrlsParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIExtKeyUsage;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIFormat;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateCsrParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateRootParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIIssueParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIKeyBits;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIKeyType;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIKeyUsage;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIManageType;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIPrivateKeyFormat;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignIntermediateParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKITidyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateRoleParams;
import io.quarkus.vault.pki.CAChainData;
import io.quarkus.vault.pki.CRLData;
import io.quarkus.vault.pki.CSRData;
import io.quarkus.vault.pki.CertificateData;
import io.quarkus.vault.pki.CertificateExtendedKeyUsage;
import io.quarkus.vault.pki.CertificateKeyType;
import io.quarkus.vault.pki.CertificateKeyUsage;
import io.quarkus.vault.pki.ConfigCRLOptions;
import io.quarkus.vault.pki.ConfigURLsOptions;
import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.GenerateCertificateOptions;
import io.quarkus.vault.pki.GenerateIntermediateCSROptions;
import io.quarkus.vault.pki.GenerateRootOptions;
import io.quarkus.vault.pki.GeneratedCertificate;
import io.quarkus.vault.pki.GeneratedIntermediateCSRResult;
import io.quarkus.vault.pki.GeneratedRootCertificate;
import io.quarkus.vault.pki.PrivateKeyData;
import io.quarkus.vault.pki.PrivateKeyEncoding;
import io.quarkus.vault.pki.RoleOptions;
import io.quarkus.vault.pki.SignIntermediateCAOptions;
import io.quarkus.vault.pki.SignedCertificate;
import io.quarkus.vault.pki.TidyOptions;
import io.quarkus.vault.runtime.DurationHelper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@ApplicationScoped
public class VaultPKIManager
implements VaultPKISecretReactiveEngine {
    private final VaultSecretsPKI pki;

    @Inject
    public VaultPKIManager(VaultClient vaultClient) {
        this(vaultClient, "pki");
    }

    VaultPKIManager(VaultClient vaultClient, String mount) {
        this.pki = vaultClient.secrets().pki(mount);
    }

    @Override
    public Uni<CertificateData.PEM> getCertificateAuthority() {
        return this.getCertificateAuthority(DataFormat.PEM).map(r -> (CertificateData.PEM)r);
    }

    @Override
    public Uni<CertificateData> getCertificateAuthority(DataFormat format) {
        return Uni.createFrom().completionStage(this.pki.readIssuerCaCert()).map(Unchecked.function(result -> {
            CertificateData.PEM certData = new CertificateData.PEM(result.getCertificate());
            if (format == DataFormat.PEM) {
                return certData;
            }
            return new CertificateData.DER(certData.getCertificate().getEncoded());
        }));
    }

    @Override
    public Uni<Void> configCertificateAuthority(String pemBundle) {
        return Uni.createFrom().completionStage(this.pki.configCa(pemBundle)).map(r -> null);
    }

    @Override
    public Uni<Void> configURLs(ConfigURLsOptions options) {
        VaultSecretsPKIConfigUrlsParams params = new VaultSecretsPKIConfigUrlsParams().setIssuingCertificates(options.issuingCertificates).setCrlDistributionPoints(options.crlDistributionPoints).setOcspServers(options.ocspServers);
        return Uni.createFrom().completionStage(this.pki.configUrls(params));
    }

    @Override
    public Uni<ConfigURLsOptions> readURLsConfig() {
        return Uni.createFrom().completionStage(this.pki.readUrlsConfig()).map(result -> {
            ConfigURLsOptions options = new ConfigURLsOptions();
            options.issuingCertificates = result.getIssuingCertificates();
            options.crlDistributionPoints = result.getCrlDistributionPoints();
            options.ocspServers = result.getOcspServers();
            return options;
        });
    }

    @Override
    public Uni<Void> configCRL(ConfigCRLOptions options) {
        VaultSecretsPKIConfigCrlParams params = new VaultSecretsPKIConfigCrlParams().setExpiry(DurationHelper.fromVaultDuration(options.expiry)).setDisable(options.disable);
        return Uni.createFrom().completionStage(this.pki.configCrl(params));
    }

    @Override
    public Uni<ConfigCRLOptions> readCRLConfig() {
        return Uni.createFrom().completionStage(this.pki.readCrlConfig()).map(result -> {
            ConfigCRLOptions options = new ConfigCRLOptions();
            options.expiry = DurationHelper.toVaultDuration(result.getExpiry());
            options.disable = result.isDisable();
            return options;
        });
    }

    @Override
    public Uni<CAChainData.PEM> getCertificateAuthorityChain() {
        return Uni.createFrom().completionStage(this.pki.readIssuerCaChain()).map(CAChainData.PEM::new);
    }

    @Override
    public Uni<CRLData.PEM> getCertificateRevocationList() {
        return this.getCertificateRevocationList(DataFormat.PEM).map(r -> (CRLData.PEM)r);
    }

    @Override
    public Uni<CRLData> getCertificateRevocationList(DataFormat format) {
        return Uni.createFrom().completionStage(this.pki.readIssuerCrl()).map(Unchecked.function(result -> {
            CRLData.PEM crlData = new CRLData.PEM((String)result);
            if (format == DataFormat.PEM) {
                return crlData;
            }
            return new CRLData.DER(crlData.getCRL().getEncoded());
        }));
    }

    @Override
    public Uni<Boolean> rotateCertificateRevocationList() {
        return Uni.createFrom().completionStage(this.pki.rotateCrl()).map(VaultSecretsPKIRotateCrlResultData::isSuccess);
    }

    @Override
    public Uni<List<String>> getCertificates() {
        return Uni.createFrom().completionStage(this.pki.listCertificates()).map(results -> {
            ArrayList<String> serials = new ArrayList<String>();
            for (String serial : results) {
                serials.add(serial.replaceAll("-", ":"));
            }
            return serials;
        });
    }

    @Override
    public Uni<CertificateData.PEM> getCertificate(String serial) {
        return Uni.createFrom().completionStage(this.pki.readCertificate(serial)).map(result -> new CertificateData.PEM(result.getCertificate()));
    }

    @Override
    public Uni<GeneratedCertificate> generateCertificate(String role, GenerateCertificateOptions options) {
        VaultSecretsPKIIssueParams params = new VaultSecretsPKIIssueParams().setFormat(this.dataFormatToFormat(options.format)).setPrivateKeyFormat(this.privateKeyFormat(options.privateKeyEncoding)).setCommonName(options.subjectCommonName).setAltNames(options.subjectAlternativeNames).setIpSans(options.ipSubjectAlternativeNames).setUriSans(options.uriSubjectAlternativeNames).setOtherSans(options.otherSubjectAlternativeNames).setTtl(DurationHelper.fromVaultDuration(options.timeToLive)).setExcludeCommonNameFromSubjectAlternativeNames(options.excludeCommonNameFromSubjectAlternativeNames);
        return Uni.createFrom().completionStage(this.pki.issue(role, params)).map(data -> {
            GeneratedCertificate result = new GeneratedCertificate();
            result.certificate = this.createCertificateData(data.getCertificate(), params.getFormat());
            result.issuingCA = this.createCertificateData(data.getIssuingCa(), params.getFormat());
            result.caChain = this.createCertificateDataList(data.getCaChain(), params.getFormat());
            result.serialNumber = data.getSerialNumber();
            result.privateKeyType = this.stringToCertificateKeyType(data.getPrivateKeyType());
            result.privateKey = this.createPrivateKeyData(data.getPrivateKey(), params.getFormat(), params.getPrivateKeyFormat());
            return result;
        });
    }

    @Override
    public Uni<SignedCertificate> signRequest(String role, String pemSigningRequest, GenerateCertificateOptions options) {
        VaultSecretsPKISignParams params = new VaultSecretsPKISignParams().setFormat(this.dataFormatToFormat(options.format)).setCsr(pemSigningRequest).setCommonName(options.subjectCommonName).setAltNames(options.subjectAlternativeNames).setIpSans(options.ipSubjectAlternativeNames).setUriSans(options.uriSubjectAlternativeNames).setOtherSans(options.otherSubjectAlternativeNames).setTtl(DurationHelper.fromVaultDuration(options.timeToLive)).setExcludeCommonNameFromSubjectAlternativeNames(options.excludeCommonNameFromSubjectAlternativeNames);
        return Uni.createFrom().completionStage(this.pki.sign(role, params)).map(data -> {
            SignedCertificate result = new SignedCertificate();
            result.certificate = this.createCertificateData(data.getCertificate(), params.getFormat());
            result.issuingCA = this.createCertificateData(data.getIssuingCa(), params.getFormat());
            result.caChain = this.createCertificateDataList(data.getCaChain(), params.getFormat());
            result.serialNumber = data.getSerialNumber();
            return result;
        });
    }

    @Override
    public Uni<OffsetDateTime> revokeCertificate(String serialNumber) {
        VaultSecretsPKIRevokeParams params = new VaultSecretsPKIRevokeParams().setSerialNumber(serialNumber);
        return Uni.createFrom().completionStage(this.pki.revoke(params)).map(VaultSecretsPKIRevokeResultData::getRevocationTime);
    }

    @Override
    public Uni<Void> updateRole(String role, RoleOptions options) {
        VaultSecretsPKIUpdateRoleParams params = new VaultSecretsPKIUpdateRoleParams().setTtl(DurationHelper.fromVaultDuration(options.timeToLive)).setMaxTtl(DurationHelper.fromVaultDuration(options.maxTimeToLive)).setAllowLocalhost(options.allowLocalhost).setAllowedDomains(options.allowedDomains).setAllowedDomainsTemplate(options.allowTemplatesInAllowedDomains).setAllowBareDomains(options.allowBareDomains).setAllowSubdomains(options.allowSubdomains).setAllowGlobDomains(options.allowGlobsInAllowedDomains).setAllowAnyName(options.allowAnyName).setEnforceHostnames(options.enforceHostnames).setAllowIpSans(options.allowIpSubjectAlternativeNames).setAllowedUriSans(options.allowedUriSubjectAlternativeNames).setAllowedOtherSans(options.allowedOtherSubjectAlternativeNames).setServerFlag(options.serverFlag).setClientFlag(options.clientFlag).setCodeSigningFlag(options.codeSigningFlag).setEmailProtectionFlag(options.emailProtectionFlag).setKeyType(options.keyType != null ? VaultSecretsPKIKeyType.from((String)options.keyType.name().toLowerCase(Locale.ROOT)) : null).setKeyBits(options.keyBits != null ? VaultSecretsPKIKeyBits.fromBits((Integer)options.keyBits) : null).setKeyUsage(VaultPKIManager.mapKeyUsagesToClient(options.keyUsages)).setExtKeyUsage(VaultPKIManager.mapExtKeyUsagesToClient(options.extendedKeyUsages)).setExtKeyUsageOids(options.extendedKeyUsageOIDs).setUseCsrCommonName(options.useCSRCommonName).setUseCsrSans(options.useCSRSubjectAlternativeNames).setOrganization(this.commaStringToStringList(options.subjectOrganization)).setOu(this.commaStringToStringList(options.subjectOrganizationalUnit)).setStreetAddress(this.commaStringToStringList(options.subjectStreetAddress)).setPostalCode(this.commaStringToStringList(options.subjectPostalCode)).setLocality(this.commaStringToStringList(options.subjectLocality)).setProvince(this.commaStringToStringList(options.subjectProvince)).setCountry(this.commaStringToStringList(options.subjectCountry)).setAllowedSerialNumbers(options.allowedSubjectSerialNumbers).setGenerateLease(options.generateLease).setNoStore(options.noStore).setRequireCn(options.requireCommonName).setPolicyIdentifiers(options.policyOIDs).setBasicConstraintsValidForNonCa(options.basicConstraintsValidForNonCA).setNotBefore(DurationHelper.fromVaultDuration(options.notBeforeDuration));
        return Uni.createFrom().completionStage(this.pki.updateRole(role, params));
    }

    @Override
    public Uni<RoleOptions> getRole(String role) {
        return Uni.createFrom().completionStage(this.pki.readRole(role)).map(info -> {
            RoleOptions result = new RoleOptions();
            result.timeToLive = DurationHelper.toStringDurationSeconds(info.getTtl());
            result.maxTimeToLive = DurationHelper.toStringDurationSeconds(info.getMaxTtl());
            result.allowLocalhost = info.isAllowLocalhost();
            result.allowedDomains = info.getAllowedDomains();
            result.allowTemplatesInAllowedDomains = info.isAllowedDomainsTemplate();
            result.allowBareDomains = info.isAllowBareDomains();
            result.allowSubdomains = info.isAllowSubdomains();
            result.allowGlobsInAllowedDomains = info.isAllowGlobDomains();
            result.allowAnyName = info.isAllowAnyName();
            result.enforceHostnames = info.isEnforceHostnames();
            result.allowIpSubjectAlternativeNames = info.isAllowIpSans();
            result.allowedUriSubjectAlternativeNames = info.getAllowedUriSans();
            result.allowedOtherSubjectAlternativeNames = info.getAllowedOtherSans();
            result.serverFlag = info.isServerFlag();
            result.clientFlag = info.isClientFlag();
            result.codeSigningFlag = info.isCodeSigningFlag();
            result.emailProtectionFlag = info.isEmailProtectionFlag();
            result.keyType = this.stringToCertificateKeyType(info.getKeyType());
            result.keyBits = info.getKeyBits().getBits();
            result.keyUsages = VaultPKIManager.mapKeyUsagesFromClient(info.getKeyUsage());
            result.extendedKeyUsages = VaultPKIManager.mapExtKeyUsagesFromClient(info.getExtKeyUsage());
            result.extendedKeyUsageOIDs = info.getExtKeyUsageOids();
            result.useCSRCommonName = info.isUseCsrCommonName();
            result.useCSRSubjectAlternativeNames = info.isUseCsrSans();
            result.subjectOrganization = this.stringListToCommaString(info.getOrganization());
            result.subjectOrganizationalUnit = this.stringListToCommaString(info.getOu());
            result.subjectStreetAddress = this.stringListToCommaString(info.getStreetAddress());
            result.subjectPostalCode = this.stringListToCommaString(info.getPostalCode());
            result.subjectLocality = this.stringListToCommaString(info.getLocality());
            result.subjectProvince = this.stringListToCommaString(info.getProvince());
            result.subjectCountry = this.stringListToCommaString(info.getCountry());
            result.allowedSubjectSerialNumbers = info.getAllowedSerialNumbers();
            result.generateLease = info.isGenerateLease();
            result.noStore = info.isNoStore();
            result.requireCommonName = info.isRequireCn();
            result.policyOIDs = info.getPolicyIdentifiers();
            result.basicConstraintsValidForNonCA = info.isBasicConstraintsValidForNonCa();
            result.notBeforeDuration = DurationHelper.toStringDurationSeconds(info.getNotBefore());
            return result;
        });
    }

    @Override
    public Uni<List<String>> getRoles() {
        return Uni.createFrom().completionStage(this.pki.listRoles()).onFailure(VaultClientException.class).recoverWithUni(x -> {
            VaultClientException vx = (VaultClientException)((Object)x);
            if (vx.getStatus() == 404) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            return Uni.createFrom().failure(x);
        });
    }

    @Override
    public Uni<Void> deleteRole(String role) {
        return Uni.createFrom().completionStage(this.pki.deleteRole(role));
    }

    @Override
    public Uni<GeneratedRootCertificate> generateRoot(GenerateRootOptions options) {
        VaultSecretsPKIGenerateRootParams params = new VaultSecretsPKIGenerateRootParams().setFormat(this.dataFormatToFormat(options.format)).setPrivateKeyFormat(this.privateKeyFormat(options.privateKeyEncoding)).setCommonName(options.subjectCommonName).setAltNames(options.subjectAlternativeNames).setIpSans(options.ipSubjectAlternativeNames).setUriSans(options.uriSubjectAlternativeNames).setOtherSans(options.otherSubjectAlternativeNames).setTtl(DurationHelper.fromVaultDuration(options.timeToLive)).setKeyType(options.keyType != null ? VaultSecretsPKIKeyType.from((String)options.keyType.name().toLowerCase(Locale.ROOT)) : null).setKeyBits(VaultSecretsPKIKeyBits.fromBits((Integer)options.keyBits)).setMaxPathLength(options.maxPathLength).setExcludeCommonNameFromSubjectAlternativeNames(options.excludeCommonNameFromSubjectAlternativeNames).setPermittedDnsDomains(options.permittedDnsDomains).setOrganization(this.commaStringToStringList(options.subjectOrganization)).setOu(this.commaStringToStringList(options.subjectOrganizationalUnit)).setStreetAddress(this.commaStringToStringList(options.subjectStreetAddress)).setPostalCode(this.commaStringToStringList(options.subjectPostalCode)).setLocality(this.commaStringToStringList(options.subjectLocality)).setProvince(this.commaStringToStringList(options.subjectProvince)).setCountry(this.commaStringToStringList(options.subjectCountry)).setSerialNumber(options.subjectSerialNumber);
        return Uni.createFrom().completionStage(this.pki.generateRoot(options.exportPrivateKey ? VaultSecretsPKIManageType.EXPORTED : VaultSecretsPKIManageType.INTERNAL, params)).map(data -> {
            GeneratedRootCertificate result = new GeneratedRootCertificate();
            result.certificate = this.createCertificateData(data.getCertificate(), params.getFormat());
            result.issuingCA = this.createCertificateData(data.getIssuingCa(), params.getFormat());
            result.serialNumber = data.getSerialNumber();
            result.privateKeyType = this.stringToCertificateKeyType(data.getPrivateKeyType());
            result.privateKey = this.createPrivateKeyData(data.getPrivateKey(), params.getFormat(), params.getPrivateKeyFormat());
            return result;
        });
    }

    @Override
    public Uni<Void> deleteRoot() {
        return Uni.createFrom().completionStage(this.pki.deleteIssuer("default"));
    }

    @Override
    public Uni<SignedCertificate> signIntermediateCA(String pemSigningRequest, SignIntermediateCAOptions options) {
        VaultSecretsPKISignIntermediateParams params = new VaultSecretsPKISignIntermediateParams().setFormat(this.dataFormatToFormat(options.format)).setCsr(pemSigningRequest).setCommonName(options.subjectCommonName).setAltNames(options.subjectAlternativeNames).setIpSans(options.ipSubjectAlternativeNames).setUriSans(options.uriSubjectAlternativeNames).setOtherSans(options.otherSubjectAlternativeNames).setTtl(DurationHelper.fromVaultDuration(options.timeToLive)).setMaxPathLength(options.maxPathLength).setExcludeCommonNameFromSubjectAlternativeNames(options.excludeCommonNameFromSubjectAlternativeNames).setUseCsrValues(options.useCSRValues).setPermittedDnsDomains(options.permittedDnsDomains).setOrganization(this.commaStringToStringList(options.subjectOrganization)).setOu(this.commaStringToStringList(options.subjectOrganizationalUnit)).setStreetAddress(this.commaStringToStringList(options.subjectStreetAddress)).setPostalCode(this.commaStringToStringList(options.subjectPostalCode)).setLocality(this.commaStringToStringList(options.subjectLocality)).setProvince(this.commaStringToStringList(options.subjectProvince)).setCountry(this.commaStringToStringList(options.subjectCountry)).setSerialNumber(options.subjectSerialNumber);
        return Uni.createFrom().completionStage(this.pki.signIntermediate(params)).map(data -> {
            SignedCertificate result = new SignedCertificate();
            result.certificate = this.createCertificateData(data.getCertificate(), params.getFormat());
            result.issuingCA = this.createCertificateData(data.getIssuingCa(), params.getFormat());
            result.caChain = this.createCertificateDataList(data.getCaChain(), params.getFormat());
            result.serialNumber = data.getSerialNumber();
            return result;
        });
    }

    @Override
    public Uni<GeneratedIntermediateCSRResult> generateIntermediateCSR(GenerateIntermediateCSROptions options) {
        VaultSecretsPKIGenerateCsrParams params = new VaultSecretsPKIGenerateCsrParams().setFormat(this.dataFormatToFormat(options.format)).setPrivateKeyFormat(this.privateKeyFormat(options.privateKeyEncoding)).setCommonName(options.subjectCommonName).setAltNames(options.subjectAlternativeNames).setIpSans(options.ipSubjectAlternativeNames).setUriSans(options.uriSubjectAlternativeNames).setOtherSans(options.otherSubjectAlternativeNames).setKeyType(options.keyType != null ? VaultSecretsPKIKeyType.from((String)options.keyType.name().toLowerCase(Locale.ROOT)) : null).setKeyBits(VaultSecretsPKIKeyBits.fromBits((Integer)options.keyBits)).setExcludeCommonNameFromSubjectAlternativeNames(options.excludeCommonNameFromSubjectAlternativeNames).setOrganization(this.commaStringToStringList(options.subjectOrganization)).setOu(this.commaStringToStringList(options.subjectOrganizationalUnit)).setStreetAddress(this.commaStringToStringList(options.subjectStreetAddress)).setPostalCode(this.commaStringToStringList(options.subjectPostalCode)).setLocality(this.commaStringToStringList(options.subjectLocality)).setProvince(this.commaStringToStringList(options.subjectProvince)).setCountry(this.commaStringToStringList(options.subjectCountry)).setSerialNumber(options.subjectSerialNumber);
        return Uni.createFrom().completionStage(this.pki.generateIntermediateCsr(options.exportPrivateKey ? VaultSecretsPKIManageType.EXPORTED : VaultSecretsPKIManageType.INTERNAL, params)).map(data -> {
            GeneratedIntermediateCSRResult result = new GeneratedIntermediateCSRResult();
            result.csr = this.createCSRData(data.getCsr(), params.getFormat());
            result.privateKeyType = this.stringToCertificateKeyType(data.getPrivateKeyType());
            result.privateKey = this.createPrivateKeyData(data.getPrivateKey(), params.getFormat(), params.getPrivateKeyFormat());
            return result;
        });
    }

    @Override
    public Uni<Void> setSignedIntermediateCA(String pemCert) {
        return Uni.createFrom().completionStage(this.pki.setSignedIntermediate(pemCert)).map(r -> null);
    }

    @Override
    public Uni<Void> tidy(TidyOptions options) {
        VaultSecretsPKITidyParams params = new VaultSecretsPKITidyParams().setTidyCertStore(options.tidyCertStore).setTidyRevokedCerts(options.tidyRevokedCerts).setSafetyBuffer(DurationHelper.fromVaultDuration(options.safetyBuffer));
        return Uni.createFrom().completionStage(this.pki.tidy(params));
    }

    private String stringListToCommaString(List<String> values) {
        if (values == null) {
            return null;
        }
        return String.join((CharSequence)",", values);
    }

    private List<String> commaStringToStringList(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(","));
    }

    private CertificateKeyType stringToCertificateKeyType(VaultSecretsPKIKeyType value) {
        if (value == null) {
            return null;
        }
        return CertificateKeyType.valueOf(value.getValue().toUpperCase(Locale.ROOT));
    }

    private VaultSecretsPKIFormat dataFormatToFormat(DataFormat format) {
        if (format == null) {
            return VaultSecretsPKIFormat.PEM;
        }
        return VaultSecretsPKIFormat.from((String)format.name().toLowerCase(Locale.ROOT));
    }

    private VaultSecretsPKIFormat nonNullFormat(VaultSecretsPKIFormat format) {
        if (format == null) {
            return VaultSecretsPKIFormat.PEM;
        }
        return format;
    }

    private VaultSecretsPKIPrivateKeyFormat privateKeyFormat(PrivateKeyEncoding privateKeyEncoding) {
        if (privateKeyEncoding == null || privateKeyEncoding == PrivateKeyEncoding.PKCS8) {
            return VaultSecretsPKIPrivateKeyFormat.PKCS8;
        }
        return VaultSecretsPKIPrivateKeyFormat.DER;
    }

    private CertificateData createCertificateData(String data, VaultSecretsPKIFormat format) {
        if (data == null) {
            return null;
        }
        return switch (this.nonNullFormat(format)) {
            case VaultSecretsPKIFormat.DER -> new CertificateData.DER(Base64.getDecoder().decode(data));
            case VaultSecretsPKIFormat.PEM -> new CertificateData.PEM(data);
            default -> throw new VaultException("Unsupported certificate format");
        };
    }

    private List<CertificateData> createCertificateDataList(List<String> datas, VaultSecretsPKIFormat format) {
        if (datas == null) {
            return null;
        }
        ArrayList<CertificateData> result = new ArrayList<CertificateData>(datas.size());
        for (String data : datas) {
            result.add(this.createCertificateData(data, format));
        }
        return result;
    }

    private CSRData createCSRData(String data, VaultSecretsPKIFormat format) {
        if (data == null) {
            return null;
        }
        return switch (this.nonNullFormat(format)) {
            case VaultSecretsPKIFormat.DER -> new CSRData.DER(Base64.getDecoder().decode(data));
            case VaultSecretsPKIFormat.PEM -> new CSRData.PEM(data);
            default -> throw new VaultException("Unsupported certification request format");
        };
    }

    private PrivateKeyData createPrivateKeyData(String data, VaultSecretsPKIFormat format, VaultSecretsPKIPrivateKeyFormat privateKeyFormat) {
        if (data == null) {
            return null;
        }
        boolean pkcs8 = privateKeyFormat == VaultSecretsPKIPrivateKeyFormat.PKCS8;
        return switch (this.nonNullFormat(format)) {
            case VaultSecretsPKIFormat.DER -> new PrivateKeyData.DER(Base64.getDecoder().decode(data), pkcs8);
            case VaultSecretsPKIFormat.PEM -> new PrivateKeyData.PEM(data, pkcs8);
            default -> throw new VaultException("Unsupported private key format");
        };
    }

    private static List<VaultSecretsPKIKeyUsage> mapKeyUsagesToClient(List<CertificateKeyUsage> keyUsages) {
        if (keyUsages == null) {
            return null;
        }
        return keyUsages.stream().map(e -> VaultSecretsPKIKeyUsage.from((String)e.name())).collect(Collectors.toList());
    }

    private static List<CertificateKeyUsage> mapKeyUsagesFromClient(List<VaultSecretsPKIKeyUsage> keyUsages) {
        if (keyUsages == null) {
            return null;
        }
        return keyUsages.stream().map(e -> CertificateKeyUsage.valueOf(e.getValue())).collect(Collectors.toList());
    }

    private static List<VaultSecretsPKIExtKeyUsage> mapExtKeyUsagesToClient(List<CertificateExtendedKeyUsage> keyUsages) {
        if (keyUsages == null) {
            return null;
        }
        return keyUsages.stream().map(e -> VaultSecretsPKIExtKeyUsage.from((String)e.name())).collect(Collectors.toList());
    }

    private static List<CertificateExtendedKeyUsage> mapExtKeyUsagesFromClient(List<VaultSecretsPKIExtKeyUsage> keyUsages) {
        if (keyUsages == null) {
            return null;
        }
        return keyUsages.stream().map(e -> CertificateExtendedKeyUsage.valueOf(e.getValue())).collect(Collectors.toList());
    }
}

