/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.pki.X509Parsing;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.quarkus.vault.runtime.config.VaultTlsConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public class JDKClientFactory {
    public static HttpClient createHttpClient(VaultRuntimeConfig vaultRuntimeConfig, boolean globalTrustAll) {
        SSLContext sslContext;
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(vaultRuntimeConfig.connectTimeout()).followRedirects(HttpClient.Redirect.NORMAL);
        if (vaultRuntimeConfig.proxyHost().isPresent()) {
            InetSocketAddress proxyAddress = new InetSocketAddress(vaultRuntimeConfig.proxyHost().get(), (int)vaultRuntimeConfig.proxyPort());
            List<String> nonProxyHosts = vaultRuntimeConfig.nonProxyHosts().orElse(List.of());
            builder = builder.proxy(new NonProxyHostsSupportingProxySelector(proxyAddress, nonProxyHosts));
        }
        if ((sslContext = JDKClientFactory.createSSLContext(vaultRuntimeConfig, globalTrustAll)) != null) {
            builder.sslContext(sslContext);
        }
        return builder.build();
    }

    private static SSLContext createSSLContext(VaultRuntimeConfig config, boolean globalTrustAll) {
        VaultTlsConfig tlsConfig = config.tls();
        boolean trustAll = tlsConfig.skipVerify().orElseGet(() -> globalTrustAll);
        if (trustAll) {
            return JDKClientFactory.skipVerify();
        }
        if (tlsConfig.caCert().isPresent()) {
            return JDKClientFactory.buildSslContextFromPem(tlsConfig.caCert().get());
        }
        if (config.getAuthenticationType() == VaultAuthenticationType.KUBERNETES && tlsConfig.useKubernetesCaCert()) {
            return JDKClientFactory.buildSslContextFromPem("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        }
        return null;
    }

    private static SSLContext buildSslContextFromPem(String file) throws VaultException {
        try {
            X509Certificate certificate = X509Parsing.parsePEMCertificate(Files.readString(Paths.get(file, new String[0]), StandardCharsets.UTF_8));
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry("caCert", certificate);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new VaultException((Throwable)e);
        }
    }

    private static SSLContext skipVerify() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new VaultException((Throwable)e);
        }
    }

    static class NonProxyHostsSupportingProxySelector
    extends ProxySelector {
        private final ProxySelector delegate;
        private final List<String> nonProxyHosts;

        public NonProxyHostsSupportingProxySelector(InetSocketAddress proxyAddress, List<String> nonProxyHosts) {
            this.delegate = ProxySelector.of(proxyAddress);
            this.nonProxyHosts = nonProxyHosts;
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (this.nonProxyHosts.stream().anyMatch(uri.getHost()::matches)) {
                return List.of(Proxy.NO_PROXY);
            }
            return this.delegate.select(uri);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            this.delegate.connectFailed(uri, sa, ioe);
        }
    }

    static class TrustAllManager
    extends X509ExtendedTrustManager {
        TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }
    }
}

