/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.vault.runtime.config.VaultAppRoleAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultKubernetesAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultUserpassAuthenticationConfig;
import java.util.Optional;

@ConfigGroup
public interface VaultAuthenticationConfig {
    public Optional<String> clientToken();

    public Optional<String> clientTokenWrappingToken();

    public VaultAppRoleAuthenticationConfig appRole();

    public VaultUserpassAuthenticationConfig userpass();

    public VaultKubernetesAuthenticationConfig kubernetes();

    default public boolean isDirectClientToken() {
        return this.clientToken().isPresent() || this.clientTokenWrappingToken().isPresent();
    }

    default public boolean isAppRole() {
        return this.appRole().roleId().isPresent() && (this.appRole().secretId().isPresent() || this.appRole().secretIdWrappingToken().isPresent());
    }

    default public boolean isUserpass() {
        return this.userpass().username().isPresent() && (this.userpass().password().isPresent() || this.userpass().passwordWrappingToken().isPresent());
    }
}

