/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.health;

import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.api.sys.health.VaultHealthStatus;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@Singleton
public class VaultHealthCheck
implements HealthCheck {
    @Inject
    VaultClient client;
    @Inject
    VaultBuildTimeConfig buildTimeConfig;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Vault connection health check");
        try {
            boolean isStandByOk = this.buildTimeConfig.health().standByOk();
            boolean isPerfStandByOk = this.buildTimeConfig.health().performanceStandByOk();
            VaultHealthStatus status = (VaultHealthStatus)this.client.sys().health().status(Boolean.valueOf(isStandByOk), Boolean.valueOf(isPerfStandByOk)).toCompletableFuture().get();
            switch (status) {
                case INITIALIZED_UNSEALED_ACTIVE: {
                    builder.up();
                    break;
                }
                case UNSEALED_STANDBY: {
                    builder.down().withData("reason", "Unsealed and Standby");
                    break;
                }
                case RECOVERY_REPLICATION_SECONDARY_ACTIVE: {
                    builder.down().withData("reason", "Disaster recovery mode replication secondary and active");
                    break;
                }
                case PERFORMANCE_STANDBY: {
                    builder.down().withData("reason", "Performance standby");
                    break;
                }
                case NOT_INITIALIZED: {
                    builder.down().withData("reason", "Not initialized");
                    break;
                }
                case SEALED: {
                    builder.down().withData("reason", "Sealed");
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            return builder.down().withData("reason", e.getMessage()).build();
        }
    }
}

