/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.pki;

import io.quarkus.vault.pki.DataFormat;

public interface CSRData {
    public DataFormat getFormat();

    public Object getData();

    public static class PEM
    implements CSRData {
        private final String pemData;

        public PEM(String pemData) {
            this.pemData = pemData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.PEM;
        }

        @Override
        public String getData() {
            return this.pemData;
        }
    }

    public static class DER
    implements CSRData {
        private final byte[] derData;

        public DER(byte[] derData) {
            this.derData = derData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.DER;
        }

        public byte[] getData() {
            return this.derData;
        }
    }
}

