/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultTransitSecretReactiveEngine;
import io.quarkus.vault.client.VaultClient;
import io.quarkus.vault.client.VaultException;
import io.quarkus.vault.client.api.common.VaultHashAlgorithm;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransit;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitCreateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDataKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptResultData;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitExportKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitGenerateDataKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyInfo;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitKeyVersion;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitMarshalingAlgorithm;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRotateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignResultBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignatureAlgorithm;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchItem;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchParams;
import io.quarkus.vault.runtime.SigningRequestResultPair;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.config.TransitKeyConfig;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.quarkus.vault.runtime.transit.DecryptionResult;
import io.quarkus.vault.runtime.transit.EncryptionResult;
import io.quarkus.vault.runtime.transit.SigningResult;
import io.quarkus.vault.runtime.transit.VaultTransitBatchResult;
import io.quarkus.vault.runtime.transit.VerificationResult;
import io.quarkus.vault.transit.ClearData;
import io.quarkus.vault.transit.DecryptionRequest;
import io.quarkus.vault.transit.EncryptionRequest;
import io.quarkus.vault.transit.KeyConfigRequestDetail;
import io.quarkus.vault.transit.KeyCreationRequestDetail;
import io.quarkus.vault.transit.RewrappingRequest;
import io.quarkus.vault.transit.SignVerifyOptions;
import io.quarkus.vault.transit.SigningInput;
import io.quarkus.vault.transit.SigningRequest;
import io.quarkus.vault.transit.TransitContext;
import io.quarkus.vault.transit.VaultDecryptionBatchException;
import io.quarkus.vault.transit.VaultEncryptionBatchException;
import io.quarkus.vault.transit.VaultRewrappingBatchException;
import io.quarkus.vault.transit.VaultSigningBatchException;
import io.quarkus.vault.transit.VaultTransitAsymmetricKeyDetail;
import io.quarkus.vault.transit.VaultTransitAsymmetricKeyVersion;
import io.quarkus.vault.transit.VaultTransitDataKey;
import io.quarkus.vault.transit.VaultTransitDataKeyRequestDetail;
import io.quarkus.vault.transit.VaultTransitDataKeyType;
import io.quarkus.vault.transit.VaultTransitExportKeyType;
import io.quarkus.vault.transit.VaultTransitKeyDetail;
import io.quarkus.vault.transit.VaultTransitKeyExportDetail;
import io.quarkus.vault.transit.VaultTransitKeyVersion;
import io.quarkus.vault.transit.VaultTransitSymmetricKeyDetail;
import io.quarkus.vault.transit.VaultTransitSymmetricKeyVersion;
import io.quarkus.vault.transit.VaultVerificationBatchException;
import io.quarkus.vault.transit.VerificationRequest;
import io.quarkus.vault.utils.Plugs;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@ApplicationScoped
public class VaultTransitManager
implements VaultTransitSecretReactiveEngine {
    private final VaultSecretsTransit transit;
    private final VaultConfigHolder vaultConfigHolder;

    @Inject
    public VaultTransitManager(VaultClient client, VaultConfigHolder configHolder) {
        this.transit = client.secrets().transit(configHolder.getVaultRuntimeConfig().transitSecretEngineMountPath());
        this.vaultConfigHolder = configHolder;
    }

    private VaultRuntimeConfig getConfig() {
        return this.vaultConfigHolder.getVaultRuntimeConfig();
    }

    @Override
    public Uni<String> encrypt(String keyName, String clearData) {
        return this.encrypt(keyName, new ClearData(clearData), null);
    }

    @Override
    public Uni<String> encrypt(String keyName, ClearData clearData, TransitContext transitContext) {
        EncryptionRequest item = new EncryptionRequest(clearData, transitContext);
        return this.encryptBatch(keyName, Collections.singletonList(item)).map(results -> (String)((EncryptionResult)results.get(0)).getValueOrElseError());
    }

    private Uni<String> encrypt(String keyName, EncryptionRequest request) {
        String configKeyName;
        VaultSecretsTransitEncryptParams params = new VaultSecretsTransitEncryptParams().setPlaintext(request.getData().getValue()).setContext(request.getContext()).setKeyVersion(request.getKeyVersion());
        TransitKeyConfig config = this.getTransitConfig(keyName);
        if (config != null) {
            configKeyName = config.name().orElse(keyName);
            params.setType((VaultSecretsTransitKeyType)config.type().map(VaultSecretsTransitKeyType::from).orElse(null));
            params.setConvergentEncryption((Boolean)config.convergentEncryption().map(Boolean::valueOf).orElse(null));
        } else {
            configKeyName = keyName;
        }
        return Uni.createFrom().completionStage(this.transit.encrypt(configKeyName, params)).map(VaultSecretsTransitEncryptResultData::getCiphertext);
    }

    private TransitKeyConfig getTransitConfig(String keyName) {
        return this.getConfig().transit().key().get(keyName);
    }

    @Override
    public Uni<Map<EncryptionRequest, String>> encrypt(String keyName, List<EncryptionRequest> requests) {
        if (requests.size() == 1) {
            EncryptionRequest request = requests.get(0);
            return this.encrypt(keyName, request).map(result -> Map.of(request, result));
        }
        return this.encryptBatch(keyName, requests).map(results -> {
            this.checkBatchErrors((List<? extends VaultTransitBatchResult<?>>)results, errors -> new VaultEncryptionBatchException(errors + " encryption errors", this.zip((List)requests, (List)results)));
            return this.zipRequestToValue((List)requests, (List)results);
        });
    }

    private Uni<List<EncryptionResult>> encryptBatch(String keyName, List<EncryptionRequest> requests) {
        String configKeyName;
        VaultSecretsTransitEncryptBatchParams params = new VaultSecretsTransitEncryptBatchParams();
        params.setBatchInput(requests.stream().map((? super T r) -> new VaultSecretsTransitEncryptBatchItem().setPlaintext(r.getData().getValue()).setContext(r.getContext()).setKeyVersion(r.getKeyVersion())).collect(Collectors.toList()));
        TransitKeyConfig config = this.getTransitConfig(keyName);
        if (config != null) {
            configKeyName = config.name().orElse(keyName);
            params.setType((VaultSecretsTransitKeyType)config.type().map(VaultSecretsTransitKeyType::from).orElse(null));
            params.setConvergentEncryption((Boolean)config.convergentEncryption().map(Boolean::valueOf).orElse(null));
        } else {
            configKeyName = keyName;
        }
        return Uni.createFrom().completionStage(this.transit.encryptBatch(configKeyName, params)).map(result -> result.stream().map((? super T r) -> new EncryptionResult(r.getCiphertext(), r.getError())).collect(Collectors.toList()));
    }

    @Override
    public Uni<ClearData> decrypt(String keyName, String ciphertext) {
        return this.decrypt(keyName, ciphertext, null);
    }

    @Override
    public Uni<ClearData> decrypt(String keyName, String ciphertext, TransitContext transitContext) {
        DecryptionRequest item = new DecryptionRequest(ciphertext, transitContext);
        return this.decryptBatch(keyName, Collections.singletonList(item)).map(results -> (ClearData)((DecryptionResult)results.get(0)).getValueOrElseError());
    }

    @Override
    public Uni<Map<DecryptionRequest, ClearData>> decrypt(String keyName, List<DecryptionRequest> requests) {
        return this.decryptBatch(keyName, requests).map(results -> {
            this.checkBatchErrors((List<? extends VaultTransitBatchResult<?>>)results, errors -> new VaultDecryptionBatchException(errors + " decryption errors", this.zip((List)requests, (List)results)));
            return this.zipRequestToValue((List)requests, (List)results);
        });
    }

    private Uni<List<DecryptionResult>> decryptBatch(String keyName, List<DecryptionRequest> requests) {
        VaultSecretsTransitDecryptBatchParams params = new VaultSecretsTransitDecryptBatchParams().setBatchInput(requests.stream().map((? super T r) -> new VaultSecretsTransitDecryptBatchItem().setCiphertext(r.getCiphertext()).setContext(r.getContext())).collect(Collectors.toList()));
        TransitKeyConfig config = this.getTransitConfig(keyName);
        String configKeyName = config != null ? config.name().orElse(keyName) : keyName;
        return Uni.createFrom().completionStage(this.transit.decryptBatch(configKeyName, params)).map(result -> result.stream().map((? super T r) -> new DecryptionResult(new ClearData(r.getPlaintext()), r.getError())).collect(Collectors.toList()));
    }

    @Override
    public Uni<String> rewrap(String keyName, String ciphertext) {
        return this.rewrap(keyName, ciphertext, null);
    }

    @Override
    public Uni<String> rewrap(String keyName, String ciphertext, TransitContext transitContext) {
        RewrappingRequest item = new RewrappingRequest(ciphertext, transitContext);
        return this.rewrapBatch(keyName, Collections.singletonList(item)).map(results -> (String)((EncryptionResult)results.get(0)).getValueOrElseError());
    }

    @Override
    public Uni<Map<RewrappingRequest, String>> rewrap(String keyName, List<RewrappingRequest> requests) {
        return this.rewrapBatch(keyName, requests).map(results -> {
            this.checkBatchErrors((List<? extends VaultTransitBatchResult<?>>)results, errors -> new VaultRewrappingBatchException(errors + " rewrapping errors", this.zip((List)requests, (List)results)));
            return this.zipRequestToValue((List)requests, (List)results);
        });
    }

    private Uni<List<EncryptionResult>> rewrapBatch(String keyName, List<RewrappingRequest> requests) {
        VaultSecretsTransitRewrapBatchParams params = new VaultSecretsTransitRewrapBatchParams().setBatchInput(requests.stream().map((? super T r) -> new VaultSecretsTransitRewrapBatchItem().setCiphertext(r.getCiphertext()).setKeyVersion(r.getKeyVersion()).setContext(r.getContext())).collect(Collectors.toList()));
        TransitKeyConfig config = this.getTransitConfig(keyName);
        String configKeyName = config != null ? config.name().orElse(keyName) : keyName;
        return Uni.createFrom().completionStage(this.transit.rewrapBatch(configKeyName, params)).map(result -> result.stream().map((? super T r) -> new EncryptionResult(r.getCiphertext(), r.getError())).collect(Collectors.toList()));
    }

    @Override
    public Uni<String> sign(String keyName, String input) {
        return this.sign(keyName, new SigningInput(input), null);
    }

    @Override
    public Uni<String> sign(String keyName, SigningInput input, TransitContext transitContext) {
        return this.sign(keyName, input, null, transitContext);
    }

    @Override
    public Uni<String> sign(String keyName, SigningInput input, SignVerifyOptions options, TransitContext transitContext) {
        SigningRequest item = new SigningRequest(input, transitContext);
        List<SigningRequestResultPair> pairs = Collections.singletonList(new SigningRequestResultPair(item));
        return this.signBatch(keyName, -1, pairs, options).map(v -> (String)((SigningRequestResultPair)pairs.get(0)).getResult().getValueOrElseError());
    }

    @Override
    public Uni<Map<SigningRequest, String>> sign(String keyName, List<SigningRequest> requests) {
        return this.sign(keyName, requests, null);
    }

    @Override
    public Uni<Map<SigningRequest, String>> sign(String keyName, List<SigningRequest> requests, SignVerifyOptions options) {
        return Multi.createFrom().iterable(requests).map(SigningRequestResultPair::new).group().by(SigningRequestResultPair::getKeyVersion).onItem().transformToMultiAndMerge(group -> {
            int keyVersion = (Integer)group.key();
            return group.collect().asList().onItem().transformToMulti(pairs -> this.signBatch(keyName, keyVersion, (List<SigningRequestResultPair>)pairs, options).onItem().transformToMulti(v -> Multi.createFrom().iterable((Iterable)pairs).map(SigningRequestResultPair::getResult)));
        }).collect().asList().map(results -> {
            this.checkBatchErrors((List<? extends VaultTransitBatchResult<?>>)results, errors -> new VaultSigningBatchException(errors + " signing errors", this.zip((List)requests, (List)results)));
            return this.zipRequestToValue((List)requests, (List)results);
        });
    }

    private Uni<Void> signBatch(String keyName, int keyVersion, List<SigningRequestResultPair> pairs, SignVerifyOptions options) {
        Boolean configPrehashed;
        String configSignatureAlgorithm;
        String configHashAlgorithm;
        String configKeyName;
        VaultSecretsTransitSignBatchParams params = new VaultSecretsTransitSignBatchParams().setBatchInput(pairs.stream().map((? super T pair) -> {
            SigningRequest request = pair.getRequest();
            return new VaultSecretsTransitSignBatchItem().setInput(request.getInput().getValue()).setContext(request.getContext());
        }).collect(Collectors.toList())).setKeyVersion(keyVersion == -1 ? null : Integer.valueOf(keyVersion));
        TransitKeyConfig config = this.getTransitConfig(keyName);
        if (config != null) {
            configKeyName = config.name().orElse(keyName);
            configHashAlgorithm = config.hashAlgorithm().orElse(null);
            configSignatureAlgorithm = config.signatureAlgorithm().orElse(null);
            configPrehashed = config.prehashed().orElse(null);
        } else {
            configKeyName = keyName;
            configHashAlgorithm = null;
            configSignatureAlgorithm = null;
            configPrehashed = null;
        }
        if (options != null) {
            params.setHashAlgorithm(VaultHashAlgorithm.from((String)this.defaultIfNull(options.getHashAlgorithm(), configHashAlgorithm)));
            params.setSignatureAlgorithm(VaultSecretsTransitSignatureAlgorithm.from((String)this.defaultIfNull(options.getSignatureAlgorithm(), configSignatureAlgorithm)));
            params.setPrehashed(this.defaultIfNull(options.getPrehashed(), configPrehashed));
            params.setMarshalingAlgorithm(VaultSecretsTransitMarshalingAlgorithm.from((String)this.defaultIfNull(options.getMarshalingAlgorithm(), null)));
        }
        return Uni.createFrom().completionStage(this.transit.signBatch(configKeyName, params)).map(result -> {
            for (int i = 0; i < pairs.size(); ++i) {
                VaultSecretsTransitSignResultBatchItem batchResult = (VaultSecretsTransitSignResultBatchItem)result.get(i);
                SigningRequestResultPair pair = (SigningRequestResultPair)pairs.get(i);
                pair.setResult(new SigningResult(batchResult.getSignature(), batchResult.getError()));
            }
            return null;
        });
    }

    @Override
    public Uni<Void> verifySignature(String keyName, String signature, String input) {
        return this.verifySignature(keyName, signature, new SigningInput(input), null);
    }

    @Override
    public Uni<Void> verifySignature(String keyName, String signature, SigningInput input, TransitContext transitContext) {
        return this.verifySignature(keyName, signature, input, null, transitContext);
    }

    @Override
    public Uni<Void> verifySignature(String keyName, String signature, SigningInput input, SignVerifyOptions options, TransitContext transitContext) {
        VerificationRequest item = new VerificationRequest(signature, input, transitContext);
        return this.verifyBatch(keyName, Collections.singletonList(item), options).map(batch -> {
            Boolean valid = (Boolean)((VerificationResult)batch.get(0)).getValueOrElseError();
            if (!Boolean.TRUE.equals(valid)) {
                throw new VaultException("invalid signature");
            }
            return null;
        });
    }

    @Override
    public Uni<Void> verifySignature(String keyName, List<VerificationRequest> requests) {
        return this.verifySignature(keyName, requests, null);
    }

    @Override
    public Uni<Void> verifySignature(String keyName, List<VerificationRequest> requests, SignVerifyOptions options) {
        return this.verifyBatch(keyName, requests, options).map(results -> {
            Map resultMap = this.zip((List)requests, (List)results);
            this.checkBatchErrors((List<? extends VaultTransitBatchResult<?>>)results, errors -> new VaultVerificationBatchException(errors + " verification errors", resultMap));
            return null;
        });
    }

    private Uni<List<VerificationResult>> verifyBatch(String keyName, List<VerificationRequest> requests, SignVerifyOptions options) {
        Boolean configPrehashed;
        String configSignatureAlgorithm;
        String configHashAlgorithm;
        String configKeyName;
        VaultSecretsTransitVerifyBatchParams params = new VaultSecretsTransitVerifyBatchParams().setBatchInput(requests.stream().map((? super T r) -> new VaultSecretsTransitVerifyBatchItem().setInput(r.getInput().getValue()).setContext(r.getContext()).setSignature(r.getSignature())).collect(Collectors.toList()));
        TransitKeyConfig config = this.getTransitConfig(keyName);
        if (config != null) {
            configKeyName = config.name().orElse(keyName);
            configHashAlgorithm = config.hashAlgorithm().orElse(null);
            configSignatureAlgorithm = config.signatureAlgorithm().orElse(null);
            configPrehashed = config.prehashed().orElse(null);
        } else {
            configKeyName = keyName;
            configHashAlgorithm = null;
            configSignatureAlgorithm = null;
            configPrehashed = null;
        }
        if (options != null) {
            params.setHashAlgorithm(VaultHashAlgorithm.from((String)this.defaultIfNull(options.getHashAlgorithm(), configHashAlgorithm)));
            params.setSignatureAlgorithm(VaultSecretsTransitSignatureAlgorithm.from((String)this.defaultIfNull(options.getSignatureAlgorithm(), configSignatureAlgorithm)));
            params.setPrehashed(this.defaultIfNull(options.getPrehashed(), configPrehashed));
            params.setMarshalingAlgorithm(VaultSecretsTransitMarshalingAlgorithm.from((String)this.defaultIfNull(options.getMarshalingAlgorithm(), null)));
        }
        return Uni.createFrom().completionStage(this.transit.verifyBatch(configKeyName, params)).map(result -> result.stream().map((? super T r) -> {
            if (r.getError() != null) {
                return new VerificationResult(r.isValid(), r.getError());
            }
            return new VerificationResult(r.isValid(), r.isValid() == false ? "invalid signature" : null);
        }).collect(Collectors.toList()));
    }

    @Override
    public Uni<Void> createKey(String keyName, KeyCreationRequestDetail detail) {
        VaultSecretsTransitCreateKeyParams params = new VaultSecretsTransitCreateKeyParams();
        if (detail != null) {
            params.setAllowPlaintextBackup(detail.getAllowPlaintextBackup()).setConvergentEncryption(Boolean.valueOf(detail.getConvergentEncryption())).setDerived(detail.getDerived()).setExportable(detail.getExportable()).setType(VaultSecretsTransitKeyType.from((String)detail.getType()));
        }
        return Uni.createFrom().completionStage(this.transit.createKey(keyName, params)).map(r -> null);
    }

    @Override
    public Uni<Void> updateKeyConfiguration(String keyName, KeyConfigRequestDetail detail) {
        VaultSecretsTransitUpdateKeyParams params = new VaultSecretsTransitUpdateKeyParams().setAllowPlaintextBackup(detail.getAllowPlaintextBackup()).setDeletionAllowed(detail.getDeletionAllowed()).setExportable(detail.getExportable()).setMinDecryptionVersion(detail.getMinDecryptionVersion()).setMinEncryptionVersion(detail.getMinEncryptionVersion());
        return Uni.createFrom().completionStage(this.transit.updateKey(keyName, params));
    }

    @Override
    public Uni<Void> rotateKey(String keyName) {
        VaultSecretsTransitRotateKeyParams params = new VaultSecretsTransitRotateKeyParams();
        return Uni.createFrom().completionStage(this.transit.rotateKey(keyName, params)).map(r -> null);
    }

    @Override
    public Uni<Void> deleteKey(String keyName) {
        return Uni.createFrom().completionStage(this.transit.deleteKey(keyName));
    }

    @Override
    public Uni<VaultTransitKeyExportDetail> exportKey(String keyName, VaultTransitExportKeyType keyType, String keyVersion) {
        return Uni.createFrom().completionStage(this.transit.exportKey(VaultSecretsTransitExportKeyType.from((String)(keyType.name() + "-key")), keyName, keyVersion)).map(result -> new VaultTransitKeyExportDetail().setName(result.getName()).setKeys(result.getKeys()));
    }

    @Override
    public Uni<Optional<VaultTransitKeyDetail<?>>> readKey(String keyName) {
        Uni res = Uni.createFrom().completionStage(this.transit.readKey(keyName)).map(result -> Optional.of(this.map((VaultSecretsTransitKeyInfo)result)));
        return res.plug(Plugs::notFoundToEmpty);
    }

    @Override
    public Uni<List<String>> listKeys() {
        return Uni.createFrom().completionStage(this.transit.listKeys());
    }

    @Override
    public Uni<VaultTransitDataKey> generateDataKey(VaultTransitDataKeyType type, String keyName, VaultTransitDataKeyRequestDetail detail) {
        VaultSecretsTransitDataKeyType keyType = VaultSecretsTransitDataKeyType.from((String)type.name());
        VaultSecretsTransitGenerateDataKeyParams params = detail == null ? null : new VaultSecretsTransitGenerateDataKeyParams().setBits(detail.getBits()).setNonce(detail.getNonce()).setContext(detail.getContext());
        return Uni.createFrom().completionStage(this.transit.generateDataKey(keyType, keyName, params)).map(r -> new VaultTransitDataKey().setCiphertext(r.getCiphertext()).setPlaintext(r.getPlaintext()));
    }

    protected VaultTransitKeyDetail<?> map(VaultSecretsTransitKeyInfo info) {
        VaultTransitKeyDetail<VaultTransitKeyVersion> result;
        VaultSecretsTransitKeyVersion latestVersionData = (VaultSecretsTransitKeyVersion)info.getKeys().get(Integer.toString(info.getLatestVersion()));
        if (latestVersionData.getPublicKey() != null) {
            Map<String, VaultTransitAsymmetricKeyVersion> versions = info.getKeys().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, VaultTransitManager::mapAsymmetricKeyVersion));
            result = new VaultTransitAsymmetricKeyDetail().setVersions(versions);
        } else {
            Map<String, VaultTransitSymmetricKeyVersion> versions = info.getKeys().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, VaultTransitManager::mapSymmetricKeyVersion));
            result = new VaultTransitSymmetricKeyDetail().setVersions(versions);
        }
        result.setDeletionAllowed(info.isDeletionAllowed());
        result.setDerived(info.isDerived());
        result.setExportable(info.isExportable());
        result.setAllowPlaintextBackup(info.isAllowPlaintextBackup());
        result.setLatestVersion(info.getLatestVersion());
        result.setMinAvailableVersion(info.getMinAvailableVersion());
        result.setMinDecryptionVersion(info.getMinDecryptionVersion());
        result.setMinEncryptionVersion(info.getMinEncryptionVersion());
        result.setName(info.getName());
        result.setSupportsEncryption(info.isSupportsEncryption());
        result.setSupportsDecryption(info.isSupportsDecryption());
        result.setSupportsDerivation(info.isSupportsDerivation());
        result.setSupportsSigning(info.isSupportsSigning());
        result.setType(info.getType().getValue());
        return result;
    }

    private static VaultTransitAsymmetricKeyVersion mapAsymmetricKeyVersion(Map.Entry<String, VaultSecretsTransitKeyVersion> entry) {
        VaultSecretsTransitKeyVersion value = entry.getValue();
        VaultTransitAsymmetricKeyVersion version = new VaultTransitAsymmetricKeyVersion();
        version.setName(value.getName());
        version.setPublicKey(value.getPublicKey());
        version.setCreationTime(value.getCreationTime());
        return version;
    }

    private static VaultTransitSymmetricKeyVersion mapSymmetricKeyVersion(Map.Entry<String, VaultSecretsTransitKeyVersion> entry) {
        VaultSecretsTransitKeyVersion value = entry.getValue();
        VaultTransitSymmetricKeyVersion version = new VaultTransitSymmetricKeyVersion();
        version.setCreationTime(value.getCreationTime());
        return version;
    }

    private void checkBatchErrors(List<? extends VaultTransitBatchResult<?>> results, Function<Long, ? extends VaultException> exceptionProducer) {
        long errors = results.stream().filter(VaultTransitBatchResult::isInError).count();
        if (errors != 0L) {
            throw exceptionProducer.apply(errors);
        }
    }

    private <K, V> Map<K, V> zip(List<K> keys, List<V> values) {
        return this.zip(keys, values, Function.identity());
    }

    private <K, V extends VaultTransitBatchResult<T>, T> Map<K, T> zipRequestToValue(List<K> keys, List<V> values) {
        return this.zip(keys, values, VaultTransitBatchResult::getValue);
    }

    private <K, T, V> Map<K, V> zip(List<K> keys, List<T> values, Function<T, V> f) {
        if (keys.size() != values.size()) {
            throw new VaultException("unable to zip " + keys.size() + " keys with " + values.size() + " values");
        }
        IdentityHashMap map = new IdentityHashMap();
        IntStream.range(0, keys.size()).forEach(i -> map.put(keys.get(i), f.apply(values.get(i))));
        return map;
    }

    private <T> T defaultIfNull(T value, T defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

