/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultEnterpriseConfig;
import io.quarkus.vault.runtime.config.VaultTlsConfig;
import io.quarkus.vault.runtime.config.VaultTransitConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.vault")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface VaultRuntimeConfig {
    public static final String NAME = "vault";
    public static final String DEFAULT_CONFIG_ORDINAL = "270";
    public static final String DEFAULT_KUBERNETES_JWT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String DEFAULT_KV_SECRET_ENGINE_MOUNT_PATH = "secret";
    public static final String DEFAULT_TRANSIT_SECRET_ENGINE_MOUNT_PATH = "transit";
    public static final String KV_SECRET_ENGINE_VERSION_V2 = "2";
    public static final String DEFAULT_RENEW_GRACE_PERIOD = "1H";
    public static final String DEFAULT_SECRET_CONFIG_CACHE_PERIOD = "10M";
    public static final String KUBERNETES_CACERT = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String DEFAULT_CONNECT_TIMEOUT = "5S";
    public static final String DEFAULT_READ_TIMEOUT = "5S";
    public static final String DEFAULT_TLS_USE_KUBERNETES_CACERT = "true";
    public static final String DEFAULT_KUBERNETES_AUTH_MOUNT_PATH = "kubernetes";
    public static final String DEFAULT_APPROLE_AUTH_MOUNT_PATH = "approle";
    public static final String DEFAULT_USERPASS_AUTH_MOUNT_PATH = "userpass";

    @WithName(value="kv-secret-engine")
    @ConfigDocMapKey(value="alias")
    public Map<String, KvSecretEngineConfig> kvSecretEngineAlias();

    @WithDefault(value="270")
    public int configOrdinal();

    public Optional<URL> url();

    @ConfigDocSection
    public VaultEnterpriseConfig enterprise();

    @ConfigDocSection
    public VaultAuthenticationConfig authentication();

    @WithDefault(value="1H")
    @WithConverter(value=DurationConverter.class)
    public Duration renewGracePeriod();

    @WithDefault(value="10M")
    @WithConverter(value=DurationConverter.class)
    public Duration secretConfigCachePeriod();

    public Optional<List<String>> secretConfigKvPath();

    @WithName(value="secret-config-kv-path")
    @ConfigDocMapKey(value="prefix")
    public Map<String, KvPathConfig> secretConfigKvPathPrefix();

    @WithDefault(value="1")
    public int mpConfigInitialAttempts();

    @WithDefault(value="medium")
    public LogConfidentialityLevel logConfidentialityLevel();

    @WithDefault(value="2")
    public int kvSecretEngineVersion();

    @WithDefault(value="secret")
    public String kvSecretEngineMountPath();

    @WithDefault(value="transit")
    public String transitSecretEngineMountPath();

    @ConfigDocSection
    public VaultTlsConfig tls();

    @WithDefault(value="5S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectTimeout();

    @WithDefault(value="5S")
    @WithConverter(value=DurationConverter.class)
    public Duration readTimeout();

    public Optional<List<String>> nonProxyHosts();

    public Optional<String> proxyHost();

    @WithDefault(value="3128")
    public Integer proxyPort();

    public Map<String, CredentialsProviderConfig> credentialsProvider();

    @ConfigDocSection
    public VaultTransitConfig transit();

    @Deprecated
    @WithName(value="devservices")
    public Map<String, String> devServices();

    @Deprecated
    public Map<String, String> health();

    default public VaultAuthenticationType getAuthenticationType() {
        if (this.authentication().kubernetes().role().isPresent()) {
            return VaultAuthenticationType.KUBERNETES;
        }
        if (this.authentication().isUserpass()) {
            return VaultAuthenticationType.USERPASS;
        }
        if (this.authentication().isAppRole()) {
            return VaultAuthenticationType.APPROLE;
        }
        return null;
    }

    default public String toStringConfidential() {
        return "VaultRuntimeConfig{url=" + String.valueOf(this.url()) + ", kubernetesAuthenticationMountPath=" + this.authentication().kubernetes().authMountPath() + ", kubernetesAuthenticationRole=" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().kubernetes().role().orElse(""), LogConfidentialityLevel.MEDIUM) + ", kubernetesJwtTokenPath='" + this.authentication().kubernetes().jwtTokenPath() + "', userpassUsername='" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().userpass().username().orElse(""), LogConfidentialityLevel.MEDIUM) + "', userpassPassword='" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().userpass().password().orElse(""), LogConfidentialityLevel.LOW) + "', appRoleRoleId='" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().appRole().roleId().orElse(""), LogConfidentialityLevel.MEDIUM) + "', appRoleSecretId='" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().appRole().secretId().orElse(""), LogConfidentialityLevel.LOW) + "', appRoleSecretIdWrappingToken='" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().appRole().secretIdWrappingToken().orElse(""), LogConfidentialityLevel.LOW) + "', clientToken=" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().clientToken().orElse(""), LogConfidentialityLevel.LOW) + ", clientTokenWrappingToken=" + this.logConfidentialityLevel().maskWithTolerance(this.authentication().clientTokenWrappingToken().orElse(""), LogConfidentialityLevel.LOW) + ", renewGracePeriod=" + String.valueOf(this.renewGracePeriod()) + ", cachePeriod=" + String.valueOf(this.secretConfigCachePeriod()) + ", logConfidentialityLevel=" + String.valueOf(this.logConfidentialityLevel()) + ", kvSecretEngineVersion=" + this.kvSecretEngineVersion() + ", kvSecretEngineMountPath='" + this.kvSecretEngineMountPath() + "', additional named engines='" + this.kvSecretEngineAlias().size() + "', tlsSkipVerify=" + String.valueOf(this.tls().skipVerify()) + ", tlsCaCert=" + String.valueOf(this.tls().caCert()) + ", connectTimeout=" + String.valueOf(this.connectTimeout()) + ", readTimeout=" + String.valueOf(this.readTimeout()) + "}";
    }

    @ConfigGroup
    public static interface KvSecretEngineConfig {
        @WithDefault(value="secret")
        public String mountPath();

        public Optional<List<String>> secretConfigKvPath();

        @WithName(value="secret-config-kv-path")
        @ConfigDocMapKey(value="prefix")
        public Map<String, KvPathConfig> secretConfigKvPathPrefix();

        @WithDefault(value="2")
        public int version();
    }

    @ConfigGroup
    public static interface KvPathConfig {
        @WithParentName
        public List<String> paths();

        public String toString();
    }
}

