/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.ConfiguredEntryPoint;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleConfigAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.ProjectResourcesScannerBuildItem;
import io.quarkiverse.web.bundler.deployment.items.QuteTagsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class BundleWebAssetsScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(BundleWebAssetsScannerProcessor.class);
    private static final String FEATURE = "web-bundler";
    public static final String MAIN_ENTRYPOINT_KEY = "main";

    BundleWebAssetsScannerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ProjectResourcesScannerBuildItem initScanner(ApplicationArchivesBuildItem applicationArchives, CurateOutcomeBuildItem curateOutcome) {
        Set allApplicationArchives = applicationArchives.getAllApplicationArchives();
        List<ResolvedDependency> extensionArtifacts = curateOutcome.getApplicationModel().getDependencies().stream().filter(Dependency::isRuntimeExtensionArtifact).collect(Collectors.toList());
        return new ProjectResourcesScannerBuildItem(allApplicationArchives, extensionArtifacts);
    }

    @BuildStep
    void collect(ProjectResourcesScannerBuildItem scanner, BuildProducer<EntryPointBuildItem> bundles, BuildProducer<QuteTagsBuildItem> quteTagsAssets, BuildProducer<BundleConfigAssetsBuildItem> bundleConfigAssets, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, WebBundlerConfig config, LiveReloadBuildItem liveReload) throws IOException {
        watchedFiles.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setLocationPredicate(s -> s.startsWith(config.webRoot())).setRestartNeeded(true).build());
        HashMap<String, WebBundlerConfig.EntryPointConfig> entryPointsConfig = new HashMap<String, WebBundlerConfig.EntryPointConfig>(config.bundle());
        if (!config.bundle().containsKey("app")) {
            entryPointsConfig.put("app", new ConfiguredEntryPoint("app", "app", MAIN_ENTRYPOINT_KEY));
        }
        WebAssetsLookupDevContext devContext = (WebAssetsLookupDevContext)liveReload.getContextObject(WebAssetsLookupDevContext.class);
        if (liveReload.isLiveReload() && devContext != null && !BundleWebAssetsScannerProcessor.hasChanged(config, liveReload, c -> BundleWebAssetsScannerProcessor.isBundleFile(config, c, entryPointsConfig))) {
            LOGGER.debug((Object)"Web bundler scan not needed for live reload");
            this.produceWebAssets(bundles, quteTagsAssets, bundleConfigAssets, devContext, true);
            return;
        }
        LOGGER.debug((Object)"Web bundler scan started");
        ArrayList<ProjectResourcesScannerBuildItem.Scanner> quteTagsAssetsScanners = new ArrayList<ProjectResourcesScannerBuildItem.Scanner>();
        ArrayList<ProjectResourcesScannerBuildItem.Scanner> bundleConfigAssetsScanners = new ArrayList<ProjectResourcesScannerBuildItem.Scanner>();
        HashMap<String, List<BundleWebAsset>> bundleAssets = new HashMap<String, List<BundleWebAsset>>();
        for (Map.Entry e : entryPointsConfig.entrySet()) {
            if (!((WebBundlerConfig.EntryPointConfig)e.getValue()).enabled()) continue;
            String entryPointKey = ((WebBundlerConfig.EntryPointConfig)e.getValue()).effectiveKey((String)e.getKey());
            bundleAssets.putIfAbsent(entryPointKey, new ArrayList());
            String dirFromWebRoot = config.fromWebRoot(((WebBundlerConfig.EntryPointConfig)e.getValue()).effectiveDir((String)e.getKey()));
            if (((WebBundlerConfig.EntryPointConfig)e.getValue()).quteTags()) {
                quteTagsAssetsScanners.add(new ProjectResourcesScannerBuildItem.Scanner(dirFromWebRoot, "glob:**.html", config.charset()));
            }
            List<WebAsset> assets = scanner.scan(dirFromWebRoot, "regex:^(.(?!\\.html$))*$", config.charset());
            Optional<WebAsset> entryPoint = assets.stream().filter(w -> w.resourceName().startsWith(PathUtils.addTrailingSlash(dirFromWebRoot) + "index.")).findAny();
            for (WebAsset webAsset : assets) {
                BundleWebAsset.BundleType bundleType = entryPoint.map(ep -> webAsset.equals(ep) ? BundleWebAsset.BundleType.ENTRYPOINT : BundleWebAsset.BundleType.MANUAL).orElse(BundleWebAsset.BundleType.AUTO);
                ((List)bundleAssets.get(entryPointKey)).add(new BundleWebAsset(webAsset, bundleType));
            }
        }
        bundleConfigAssetsScanners.add(new ProjectResourcesScannerBuildItem.Scanner(config.webRoot(), "glob:tsconfig.json", config.charset()));
        WebAssetsLookupDevContext context = new WebAssetsLookupDevContext(bundleAssets, scanner.scan(quteTagsAssetsScanners), scanner.scan(bundleConfigAssetsScanners));
        this.produceWebAssets(bundles, quteTagsAssets, bundleConfigAssets, context, false);
        liveReload.setContextObject(WebAssetsLookupDevContext.class, (Object)context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isBundleFile(WebBundlerConfig config, String changedResource, Map<String, WebBundlerConfig.EntryPointConfig> entryPointsConfig) {
        if (config.fromWebRoot("tsconfig.json").equals(changedResource)) return true;
        if (!entryPointsConfig.entrySet().stream().map(e -> config.fromWebRoot(((WebBundlerConfig.EntryPointConfig)e.getValue()).effectiveDir((String)e.getKey()))).anyMatch(changedResource::startsWith)) return false;
        return true;
    }

    static boolean hasChanged(WebBundlerConfig config, LiveReloadBuildItem liveReload, Predicate<String> predicate) {
        return liveReload.getChangedResources().stream().anyMatch(c -> c.startsWith(config.webRoot()) && predicate.test((String)c));
    }

    void produceWebAssets(BuildProducer<EntryPointBuildItem> bundles, BuildProducer<QuteTagsBuildItem> quteTagsAssets, BuildProducer<BundleConfigAssetsBuildItem> bundleConfigAssets, WebAssetsLookupDevContext context, boolean checkIfExists) {
        for (Map.Entry<String, List<BundleWebAsset>> e : context.bundleAssets().entrySet()) {
            bundles.produce((BuildItem)new EntryPointBuildItem(e.getKey(), checkIfExists ? BundleWebAssetsScannerProcessor.checkWebAssets(e.getValue()) : e.getValue()));
        }
        bundleConfigAssets.produce((BuildItem)new BundleConfigAssetsBuildItem(checkIfExists ? BundleWebAssetsScannerProcessor.checkWebAssets(context.bundleConfigWebAssets()) : context.bundleConfigWebAssets()));
        quteTagsAssets.produce((BuildItem)new QuteTagsBuildItem(checkIfExists ? BundleWebAssetsScannerProcessor.checkWebAssets(context.quteWebAssets()) : context.quteWebAssets()));
    }

    private static <T extends WebAsset> List<T> checkWebAssets(List<T> webAssets) {
        return webAssets.stream().filter(w -> w.filePath().isPresent() && Files.isRegularFile(w.filePath().get(), new LinkOption[0])).collect(Collectors.toList());
    }

    record WebAssetsLookupDevContext(Map<String, List<BundleWebAsset>> bundleAssets, List<WebAsset> quteWebAssets, List<WebAsset> bundleConfigWebAssets) {
        public List<WebAsset> allWebAssets() {
            ArrayList<WebAsset> all = new ArrayList<WebAsset>();
            all.addAll(this.quteWebAssets);
            all.addAll(this.bundleConfigWebAssets);
            this.bundleAssets.values().forEach(all::addAll);
            return all;
        }
    }
}

