/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.items;

import io.quarkiverse.web.bundler.deployment.ProjectResourcesScanner;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;

public interface WebAsset {
    default public String pathFromWebRoot(String root) {
        if (!this.resourceName().startsWith(root)) {
            throw new IllegalStateException("Web Bundler must be located under the root: " + root);
        }
        return this.resourceName().substring(root.endsWith("/") ? root.length() : root.length() + 1);
    }

    default public byte[] readContentFromFile() {
        return ProjectResourcesScanner.readTemplateContent(this.filePath().orElseThrow());
    }

    default public byte[] contentOrReadFromFile() {
        return this.hasContent() ? this.content() : this.readContentFromFile();
    }

    default public boolean hasContent() {
        return this.content() != null;
    }

    default public boolean matches(String glob) {
        if (!this.filePath().isPresent()) {
            return false;
        }
        return this.filePath().get().getFileSystem().getPathMatcher(glob).matches(this.filePath().get());
    }

    public String resourceName();

    public Optional<Path> filePath();

    public byte[] content();

    public Charset charset();
}

