/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.staticresources;

import io.quarkus.builder.item.MultiBuildItem;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;

public final class GeneratedStaticResourceBuildItem
extends MultiBuildItem {
    private final Set<Source> origins;
    private final String publicPath;
    private final byte[] content;
    private final boolean nativeEnabled;
    private final WatchMode watchMode;
    private final boolean changed;

    public GeneratedStaticResourceBuildItem(Set<Source> origins, String publicPath, byte[] content, boolean nativeEnabled, WatchMode watchMode, boolean changed) {
        this.origins = origins;
        this.publicPath = publicPath;
        this.content = content;
        this.nativeEnabled = nativeEnabled;
        this.watchMode = watchMode;
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Set<Source> getOrigins() {
        return this.origins;
    }

    public String getResourceName() {
        return "META-INF/resources/" + this.publicPath.replaceAll("^/", "");
    }

    public String getPublicPath() {
        return this.publicPath;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean isNativeEnabled() {
        return this.nativeEnabled;
    }

    public WatchMode getWatchMode() {
        return this.watchMode;
    }

    public static enum WatchMode {
        DISABLED,
        RUNTIME,
        RESTART;

    }

    public static class Source {
        private final String resourceName;
        private final Optional<Path> path;

        public Source(String resourceName, Optional<Path> path) {
            this.resourceName = resourceName;
            this.path = path;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public Optional<Path> getPath() {
            return this.path;
        }
    }
}

