/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.BundleWebAssetsScannerProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ProjectResourcesScannerBuildItem;
import io.quarkiverse.web.bundler.deployment.items.QuteTemplatesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;

public class QuteTemplateAssetsScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(QuteTemplateAssetsScannerProcessor.class);

    @BuildStep
    QuteTemplatesBuildItem scan(ProjectResourcesScannerBuildItem scanner, WebBundlerConfig config, LiveReloadBuildItem liveReload) throws IOException {
        LOGGER.debug((Object)"Web bundler html templates scan started");
        HtmlTemplatesContext context = (HtmlTemplatesContext)liveReload.getContextObject(HtmlTemplatesContext.class);
        if (liveReload.isLiveReload() && context != null && !BundleWebAssetsScannerProcessor.hasChanged(config, liveReload, s -> s.substring(config.webRoot().length()).matches("^/.+\\.html$"))) {
            LOGGER.debug((Object)"Web bundler html templates scan not needed for live reload");
            return new QuteTemplatesBuildItem(context.assets());
        }
        List<WebAsset> assets = scanner.scan(new ProjectResourcesScannerBuildItem.Scanner(config.webRoot(), "glob:*.html", config.charset()));
        liveReload.setContextObject(HtmlTemplatesContext.class, (Object)new HtmlTemplatesContext(assets));
        LOGGER.debugf("Web bundler %d html templates found.", assets.size());
        return new QuteTemplatesBuildItem(assets);
    }

    private record HtmlTemplatesContext(List<WebAsset> assets) {
    }
}

