/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigMapping(prefix="quarkus.web-bundler")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface WebBundlerConfig {
    @WithDefault(value="web")
    public String webRoot();

    default public String fromWebRoot(String dir) {
        return PathUtils.join(this.webRoot(), dir);
    }

    public Map<String, EntryPointConfig> bundle();

    @WithName(value="static")
    @WithDefault(value="static")
    public String staticDir();

    @WithDefault(value="static/bundle")
    public String bundlePath();

    public LoadersConfig loaders();

    public Optional<List<String>> externalImports();

    @WithDefault(value="true")
    public Boolean bundleSplitting();

    public WebDependenciesConfig dependencies();

    @WithDefault(value="false")
    public Boolean bundleRedirect();

    @WithDefault(value="UTF-8")
    public Charset charset();

    default public String httpRootPath() {
        Config allConfig = ConfigProvider.getConfig();
        String rootPath = allConfig.getOptionalValue("quarkus.http.root-path", String.class).orElse("/");
        return PathUtils.prefixWithSlash(rootPath);
    }

    default public String publicBundlePath() {
        return this.isExternalBundlePath() ? this.bundlePath() : PathUtils.join(this.httpRootPath(), this.bundlePath());
    }

    default public boolean isExternalBundlePath() {
        return this.bundlePath().matches("^https?://.*");
    }

    default public boolean shouldQuarkusServeBundle() {
        return !this.isExternalBundlePath();
    }

    public static interface EntryPointConfig {
        @WithParentName
        @WithDefault(value="true")
        public boolean enabled();

        public Optional<String> dir();

        public Optional<String> key();

        @WithDefault(value="false")
        public boolean quteTags();

        default public String effectiveDir(String mapKey) {
            return this.dir().filter(Predicate.not(String::isBlank)).orElse(mapKey);
        }

        default public String effectiveKey(String mapKey) {
            return this.key().filter(Predicate.not(String::isBlank)).orElse(mapKey);
        }
    }

    public static interface LoadersConfig {
        @WithDefault(value="js,cjs,mjs")
        public Optional<Set<String>> js();

        @WithDefault(value="jsx")
        public Optional<Set<String>> jsx();

        @WithDefault(value="tsx")
        public Optional<Set<String>> tsx();

        @WithDefault(value="ts,mts,cts")
        public Optional<Set<String>> ts();

        @WithDefault(value="css")
        public Optional<Set<String>> css();

        @WithDefault(value=".module.css")
        public Optional<Set<String>> localCss();

        public Optional<Set<String>> globalCss();

        @WithDefault(value="aac,abw,arc,avif,avi,azw,bin,bmp,bz,bz2,cda,csv,yaml,yml,doc,docx,eot,epub,gz,gif,htm,html,ico,ics,jar,jpeg,jpg,jsonld,mid,midi,mp3,mp4,mpeg,mpkg,odp,ods,odt,oga,ogv,ogx,opus,otf,png,pdf,ppt,pptx,rar,rtf,svg,tar,tif,tiff,ttf,vsd,wav,weba,webm,webp,woff,woff2,xhtml,xls,xlsx,xml,xul,zip,3gp,3g2,7z")
        public Optional<Set<String>> file();

        public Optional<Set<String>> copy();

        public Optional<Set<String>> base64();

        public Optional<Set<String>> binary();

        public Optional<Set<String>> dataUrl();

        public Optional<Set<String>> empty();

        @WithDefault(value="txt")
        public Optional<Set<String>> text();

        @WithDefault(value="json")
        public Optional<Set<String>> json();
    }

    public static interface AutoImportConfig {
        @WithDefault(value="none")
        @WithParentName
        public Mode mode();

        default public boolean isEnabled() {
            return this.mode() != Mode.NONE;
        }

        public static enum Mode {
            ALL,
            STYLES,
            NONE;

        }
    }

    public static interface WebDependenciesConfig {
        public Optional<String> nodeModules();

        @WithDefault(value="true")
        public boolean compileOnly();

        public AutoImportConfig autoImport();
    }
}

