/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigMapping(prefix="quarkus.web-bundler")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface WebBundlerConfig {
    @WithDefault(value="web")
    public String webRoot();

    default public String fromWebRoot(String dir) {
        return PathUtils.join(this.webRoot(), dir);
    }

    public Map<String, EntryPointConfig> bundle();

    @WithName(value="static")
    @WithDefault(value="static")
    public String staticDir();

    @WithDefault(value="static/bundle")
    public String bundlePath();

    public BundlingConfig bundling();

    public WebDependenciesConfig dependencies();

    @WithDefault(value="true")
    public boolean browserLiveReload();

    @WithDefault(value="false")
    public Boolean bundleRedirect();

    @WithDefault(value="UTF-8")
    public Charset charset();

    default public String httpRootPath() {
        Config allConfig = ConfigProvider.getConfig();
        String rootPath = allConfig.getOptionalValue("quarkus.http.root-path", String.class).orElse("/");
        return PathUtils.prefixWithSlash(rootPath);
    }

    default public String publicBundlePath() {
        return this.isExternalBundlePath() ? this.bundlePath() : PathUtils.join(this.httpRootPath(), this.bundlePath());
    }

    default public boolean isExternalBundlePath() {
        return this.bundlePath().matches("^https?://.*");
    }

    default public boolean shouldQuarkusServeBundle() {
        return !this.isExternalBundlePath();
    }

    public static boolean isEqual(WebBundlerConfig c1, WebBundlerConfig c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        for (Map.Entry<String, EntryPointConfig> entry : c1.bundle().entrySet()) {
            if (EntryPointConfig.isEqual(entry.getValue(), c2.bundle().get(entry.getKey()))) continue;
            return false;
        }
        return Objects.equals(c1.webRoot(), c2.webRoot()) && Objects.equals(c1.bundle(), c2.bundle()) && Objects.equals(c1.staticDir(), c2.staticDir()) && Objects.equals(c1.bundlePath(), c2.bundlePath()) && BundlingConfig.isEqual(c1.bundling(), c2.bundling()) && WebDependenciesConfig.isEqual(c1.dependencies(), c2.dependencies()) && Objects.equals(c1.bundleRedirect(), c2.bundleRedirect()) && Objects.equals(c1.charset(), c2.charset());
    }

    public static interface EntryPointConfig {
        @WithParentName
        @WithDefault(value="true")
        public boolean enabled();

        public Optional<String> dir();

        public Optional<String> key();

        @WithDefault(value="false")
        public boolean quteTags();

        default public String effectiveDir(String mapKey) {
            return this.dir().filter(Predicate.not(String::isBlank)).orElse(mapKey);
        }

        default public String effectiveKey(String mapKey) {
            return this.key().filter(Predicate.not(String::isBlank)).orElse(mapKey);
        }

        public static boolean isEqual(EntryPointConfig c1, EntryPointConfig c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return Objects.equals(c1.enabled(), c2.enabled()) && Objects.equals(c1.dir(), c2.dir()) && Objects.equals(c1.key(), c2.key()) && Objects.equals(c1.quteTags(), c2.quteTags());
        }
    }

    public static interface BundlingConfig {
        @WithDefault(value="true")
        public Boolean splitting();

        public LoadersConfig loaders();

        public Optional<List<String>> external();

        @WithDefault(value="linked")
        public String sourceMap();

        public Map<String, String> envs();

        default public Map<String, String> safeEnvs() {
            if (this.envs().isEmpty()) {
                return Map.of();
            }
            return this.envs().entrySet().stream().collect(Collectors.toMap(e -> BundlingConfig.safeKey((String)e.getKey()), e -> "'" + BundlingConfig.safeValue((String)e.getValue()) + "'"));
        }

        public static String safeKey(String v) {
            return v.replaceAll("^[^a-zA-Z_$]|[^0-9a-zA-Z_$]", "_");
        }

        public static String safeValue(String v) {
            if (v.contains("'")) {
                throw new IllegalArgumentException("Single quote ' must not be used in bundling environment values");
            }
            return v;
        }

        default public boolean sourceMapEnabled() {
            return "linked".equalsIgnoreCase(this.sourceMap()) || "true".equalsIgnoreCase(this.sourceMap()) || "yes".equalsIgnoreCase(this.sourceMap());
        }

        public static boolean isEqual(BundlingConfig c1, BundlingConfig c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return Objects.equals(c1.splitting(), c2.splitting()) && LoadersConfig.isEqual(c1.loaders(), c2.loaders()) && Objects.equals(c1.external(), c2.external()) && Objects.equals(c1.envs(), c2.envs()) && Objects.equals(c1.sourceMap(), c2.sourceMap());
        }
    }

    public static interface WebDependenciesConfig {
        public Optional<String> nodeModules();

        @WithDefault(value="true")
        public boolean compileOnly();

        public AutoImportConfig autoImport();

        public static boolean isEqual(WebDependenciesConfig c1, WebDependenciesConfig c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return Objects.equals(c1.nodeModules(), c2.nodeModules()) && Objects.equals(c1.compileOnly(), c2.compileOnly()) && AutoImportConfig.isEqual(c1.autoImport(), c2.autoImport());
        }
    }

    public static interface LoadersConfig {
        @WithDefault(value="js,cjs,mjs")
        public Optional<Set<String>> js();

        @WithDefault(value="jsx")
        public Optional<Set<String>> jsx();

        @WithDefault(value="tsx")
        public Optional<Set<String>> tsx();

        @WithDefault(value="ts,mts,cts")
        public Optional<Set<String>> ts();

        @WithDefault(value="css")
        public Optional<Set<String>> css();

        @WithDefault(value=".module.css")
        public Optional<Set<String>> localCss();

        public Optional<Set<String>> globalCss();

        @WithDefault(value="aac,abw,arc,avif,avi,azw,bin,bmp,bz,bz2,cda,csv,yaml,yml,doc,docx,eot,epub,gz,gif,htm,html,ico,ics,jar,jpeg,jpg,jsonld,mid,midi,mp3,mp4,mpeg,mpkg,odp,ods,odt,oga,ogv,ogx,opus,otf,png,pdf,ppt,pptx,rar,rtf,svg,tar,tif,tiff,ttf,vsd,wav,weba,webm,webp,woff,woff2,xhtml,xls,xlsx,xml,xul,zip,3gp,3g2,7z")
        public Optional<Set<String>> file();

        public Optional<Set<String>> copy();

        public Optional<Set<String>> base64();

        public Optional<Set<String>> binary();

        public Optional<Set<String>> dataUrl();

        public Optional<Set<String>> empty();

        @WithDefault(value="txt")
        public Optional<Set<String>> text();

        @WithDefault(value="json")
        public Optional<Set<String>> json();

        public static boolean isEqual(LoadersConfig c1, LoadersConfig c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return Objects.equals(c1.js(), c2.js()) && Objects.equals(c1.jsx(), c2.jsx()) && Objects.equals(c1.tsx(), c2.tsx()) && Objects.equals(c1.ts(), c2.ts()) && Objects.equals(c1.css(), c2.css()) && Objects.equals(c1.localCss(), c2.localCss()) && Objects.equals(c1.globalCss(), c2.globalCss()) && Objects.equals(c1.file(), c2.file()) && Objects.equals(c1.copy(), c2.copy()) && Objects.equals(c1.base64(), c2.base64()) && Objects.equals(c1.binary(), c2.binary()) && Objects.equals(c1.dataUrl(), c2.dataUrl()) && Objects.equals(c1.empty(), c2.empty()) && Objects.equals(c1.text(), c2.text()) && Objects.equals(c1.json(), c2.json());
        }
    }

    public static interface AutoImportConfig {
        @WithDefault(value="none")
        @WithParentName
        public Mode mode();

        default public boolean isEnabled() {
            return this.mode() != Mode.NONE;
        }

        public static boolean isEqual(AutoImportConfig c1, AutoImportConfig c2) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null || c2 == null) {
                return false;
            }
            return Objects.equals((Object)c1.mode(), (Object)c2.mode());
        }

        public static enum Mode {
            ALL,
            STYLES,
            NONE;

        }
    }
}

