/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.items;

import io.quarkiverse.web.bundler.deployment.items.DefaultWebAsset;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public final class ProjectResourcesScannerBuildItem
extends SimpleBuildItem {
    private static final Logger LOGGER = Logger.getLogger(ProjectResourcesScannerBuildItem.class);
    Set<ApplicationArchive> allApplicationArchives;
    List<ResolvedDependency> extensionArtifacts;
    private final List<Path> srcResourcesDirs;

    public ProjectResourcesScannerBuildItem(Set<ApplicationArchive> allApplicationArchives, List<ResolvedDependency> extensionArtifacts, List<Path> srcResourcesDirs) {
        this.allApplicationArchives = allApplicationArchives;
        this.extensionArtifacts = extensionArtifacts;
        this.srcResourcesDirs = srcResourcesDirs;
    }

    public List<WebAsset> scan(String dir, String pathMatcher, Charset charset) throws IOException {
        return this.scan(new Scanner(dir, pathMatcher, charset));
    }

    public List<WebAsset> scan(Scanner scanner) throws IOException {
        return this.scan(List.of(scanner));
    }

    public List<WebAsset> scan(List<Scanner> scanners) throws IOException {
        ArrayList<WebAsset> webAssets = new ArrayList<WebAsset>();
        for (Scanner assetsScanner : scanners) {
            this.scanProject(assetsScanner, webAssets::add);
        }
        return webAssets;
    }

    private void scanProject(Scanner scanner, Consumer<WebAsset> webAssetConsumer) throws IOException {
        block7: for (ResolvedDependency artifact : this.extensionArtifacts) {
            if (this.isApplicationArchive(artifact, this.allApplicationArchives)) continue;
            for (Path rootDir : artifact.getResolvedPaths()) {
                if (Files.isDirectory(rootDir, new LinkOption[0])) {
                    Path dirPath = rootDir.resolve(scanner.dir());
                    if (!Files.isDirectory(dirPath, new LinkOption[0]) || !dirPath.toString().endsWith(scanner.dir())) continue;
                    this.scan(rootDir, dirPath, scanner.pathMatcher(), scanner.charset, webAssetConsumer, true);
                    continue block7;
                }
                try {
                    FileSystem artifactFs = ZipUtils.newFileSystem((Path)rootDir);
                    try {
                        Path rootDirFs = artifactFs.getPath("/", new String[0]);
                        Path dirPath = artifactFs.getPath(scanner.dir(), new String[0]);
                        if (!Files.exists(dirPath, new LinkOption[0])) continue;
                        this.scan(rootDirFs, dirPath, scanner.pathMatcher(), scanner.charset(), webAssetConsumer, false);
                    }
                    finally {
                        if (artifactFs == null) continue;
                        artifactFs.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warnf((Throwable)e, "Unable to create the file system from the rootDir: %s", (Object)rootDir);
                }
            }
        }
        for (ApplicationArchive archive : this.allApplicationArchives) {
            archive.accept(tree -> {
                for (Path rootDir : tree.getRoots()) {
                    try {
                        Path dirPath = rootDir.resolve(scanner.dir());
                        if (!Files.isDirectory(dirPath, new LinkOption[0]) || !PathUtils.toUnixPath(dirPath.toString()).endsWith(scanner.dir())) continue;
                        this.scan(rootDir, dirPath, scanner.pathMatcher(), scanner.charset, webAssetConsumer, true);
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
    }

    private void scan(Path root, Path directory, String pathMatcher, Charset charset, Consumer<WebAsset> webAssetConsumer, boolean canReadLater) throws IOException {
        Path toScan = directory == null ? root : directory;
        try (Stream<Path> files = Files.find(toScan, 20, (p, a) -> Files.isRegularFile(p, new LinkOption[0]), new FileVisitOption[0]);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path relativePath;
                PathMatcher assetsPathMatcher;
                boolean isAsset;
                Path filePath = (Path)iter.next();
                if (!toScan.isAbsolute() && filePath.isAbsolute() && filePath.getRoot() != null) {
                    filePath = filePath.getRoot().relativize(filePath);
                }
                if (!(isAsset = (assetsPathMatcher = (relativePath = toScan.relativize(filePath)).getFileSystem().getPathMatcher(pathMatcher)).matches(relativePath))) continue;
                String assetPath = root.relativize(filePath).normalize().toString();
                if (assetPath.contains("\\")) {
                    assetPath = PathUtils.toUnixPath(assetPath);
                }
                if (assetPath.isEmpty()) continue;
                Path srcFilePath = canReadLater ? this.findSrc(assetPath) : null;
                webAssetConsumer.accept(ProjectResourcesScannerBuildItem.toWebAsset(assetPath, filePath.normalize(), srcFilePath, charset, canReadLater));
            }
        }
    }

    Path findSrc(String assetPath) {
        for (Path srcResourcesDir : this.srcResourcesDirs) {
            Path absolutePath = srcResourcesDir.resolve(assetPath);
            if (!Files.isRegularFile(absolutePath, new LinkOption[0])) continue;
            return absolutePath;
        }
        return null;
    }

    static WebAsset toWebAsset(String resourcePath, Path filePath, Path srcFilePath, Charset charset, boolean canReadLater) {
        return new DefaultWebAsset(resourcePath, canReadLater ? new WebAsset.Resource(filePath) : new WebAsset.Resource(ProjectResourcesScannerBuildItem.readTemplateContent(filePath)), Optional.ofNullable(srcFilePath), charset);
    }

    private boolean isApplicationArchive(ResolvedDependency dependency, Set<ApplicationArchive> applicationArchives) {
        for (ApplicationArchive archive : applicationArchives) {
            if (archive.getKey() == null || !dependency.getGroupId().equals(archive.getKey().getGroupId()) || !dependency.getArtifactId().equals(archive.getKey().getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public static byte[] readTemplateContent(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read the content from path: " + path, e);
        }
    }

    public record Scanner(String dir, String pathMatcher, Charset charset) {
    }
}

