/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.BundleWebAssetsScannerProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ProjectResourcesScannerBuildItem;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;

public class StaticAssetsScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(StaticAssetsScannerProcessor.class);

    @BuildStep
    StaticAssetsBuildItem scan(ProjectResourcesScannerBuildItem scanner, WebBundlerConfig config, LiveReloadBuildItem liveReload) throws IOException {
        LOGGER.debug((Object)"Web bundler static assets scan started");
        StaticAssetsContext context = (StaticAssetsContext)liveReload.getContextObject(StaticAssetsContext.class);
        if (liveReload.isLiveReload() && context != null && WebBundlerConfig.isEqual(config, context.config()) && !BundleWebAssetsScannerProcessor.hasChanged(config, liveReload, s -> s.startsWith(config.fromWebRoot(config.staticDir())))) {
            LOGGER.debug((Object)"Web bundler static assets scan not needed for live reload");
            return new StaticAssetsBuildItem(context.assets());
        }
        List<WebAsset> assets = scanner.scan(new ProjectResourcesScannerBuildItem.Scanner(config.fromWebRoot(config.staticDir()), "glob:**", config.charset()));
        liveReload.setContextObject(StaticAssetsContext.class, (Object)new StaticAssetsContext(config, assets));
        LOGGER.debugf("Web bundler %d static assets found.", assets.size());
        return new StaticAssetsBuildItem(assets);
    }

    private record StaticAssetsContext(WebBundlerConfig config, List<WebAsset> assets) {
    }
}

