/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.items;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

public interface WebAsset {
    default public String pathFromWebRoot(String root) {
        if (!this.resourceName().startsWith(root)) {
            throw new IllegalStateException("Web Bundler must be located under the root: " + root);
        }
        return this.resourceName().substring(root.endsWith("/") ? root.length() : root.length() + 1);
    }

    default public boolean isFile() {
        return this.resource().isFile();
    }

    public String resourceName();

    public Optional<Path> srcFilePath();

    public Resource resource();

    public Charset charset();

    public record Resource(byte[] content, Path path) {
        public Resource(byte[] content) {
            this(content, null);
        }

        public Resource(Path path) {
            this(null, path);
        }

        public Resource {
            if (content != null && path != null) {
                throw new IllegalArgumentException("if a resource has content, it means the Path should be null has it is only meant for content which can't be read anymore");
            }
        }

        public byte[] contentOrReadFromFile() {
            try {
                return this.isFile() ? Files.readAllBytes(this.path()) : this.content();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isFile() {
            return this.path != null;
        }
    }
}

