/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.util.ConfiguredPaths;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import jakarta.validation.constraints.NotBlank;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

@ConfigMapping(prefix="quarkus.web-bundler")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface WebBundlerConfig {
    @WithDefault(value="web")
    @NotBlank
    public String webRoot();

    default public String fromWebRoot(String dir) {
        return ConfiguredPaths.addTrailingSlash(this.webRoot()) + ConfiguredPaths.removeLeadingSlash(dir);
    }

    public Map<String, EntryPointConfig> bundle();

    @WithName(value="static")
    @WithDefault(value="static")
    @NotBlank
    public String staticDir();

    @WithName(value="bundle")
    @WithDefault(value="static/bundle")
    @NotBlank
    public String bundleDir();

    public PresetsConfig presets();

    public LoadersConfig loaders();

    public WebDependenciesConfig dependencies();

    @WithDefault(value="UTF-8")
    public Charset charset();

    public static enum WebDependencyType {
        WEBJARS("org.webjars.npm"::equals),
        MVNPM(s -> s.startsWith("org.mvnpm"));

        private final Predicate<String> groupMatcher;

        private WebDependencyType(Predicate<String> groupMatcher) {
            this.groupMatcher = groupMatcher;
        }

        public boolean matches(Dependency dep) {
            return this.groupMatcher.test(dep.getGroupId());
        }
    }

    public static interface EntryPointConfig {
        @WithParentName
        @WithDefault(value="true")
        public boolean enabled();

        public Optional<String> dir();

        public Optional<String> key();

        default public String effectiveDir(String mapKey) {
            return this.dir().filter(Predicate.not(String::isBlank)).orElse(this.effectiveKey(mapKey));
        }

        default public String effectiveKey(String mapKey) {
            return this.key().filter(Predicate.not(String::isBlank)).orElse(mapKey);
        }
    }

    public static interface LoadersConfig {
        @WithDefault(value="js,cjs,mjs")
        public Optional<Set<String>> js();

        @WithDefault(value="jsx")
        public Optional<Set<String>> jsx();

        @WithDefault(value="tsx")
        public Optional<Set<String>> tsx();

        @WithDefault(value="ts,mts,cts")
        public Optional<Set<String>> ts();

        @WithDefault(value="css")
        public Optional<Set<String>> css();

        @WithDefault(value=".module.css")
        public Optional<Set<String>> localCss();

        public Optional<Set<String>> globalCss();

        @WithDefault(value="aac,abw,arc,avif,avi,azw,bin,bmp,bz,bz2,cda,csv,yaml,yml,doc,docx,eot,epub,gz,gif,htm,html,ico,ics,jar,jpeg,jpg,jsonld,mid,midi,mp3,mp4,mpeg,mpkg,odp,ods,odt,oga,ogv,ogx,opus,otf,png,pdf,ppt,pptx,rar,rtf,svg,tar,tif,tiff,ttf,vsd,wav,weba,webm,webp,woff,woff2,xhtml,xls,xlsx,xml,xul,zip,3gp,3g2,7z")
        public Optional<Set<String>> file();

        public Optional<Set<String>> copy();

        public Optional<Set<String>> base64();

        public Optional<Set<String>> binary();

        public Optional<Set<String>> dataUrl();

        public Optional<Set<String>> empty();

        @WithDefault(value="txt")
        public Optional<Set<String>> text();

        @WithDefault(value="json")
        public Optional<Set<String>> json();
    }

    public static interface WebDependenciesConfig {
        @WithDefault(value="mvnpm")
        public WebDependencyType type();
    }

    public static interface PresetConfig {
        @WithParentName
        @WithDefault(value="true")
        public boolean enabled();

        @WithDefault(value="main")
        public Optional<String> entryPointKey();
    }

    public static interface PresetsConfig {
        public PresetConfig app();

        public PresetConfig components();
    }
}

