/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleOptionsBuilder;
import io.mvnpm.esbuild.model.BundleResult;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.EsBuildConfigBuilder;
import io.quarkiverse.web.bundler.deployment.ProjectResourcesScanner;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleConfigAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.QuteTagsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.staticresources.GeneratedStaticResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.util.ConfiguredPaths;
import io.quarkiverse.web.bundler.runtime.Bundle;
import io.quarkiverse.web.bundler.runtime.WebBundlerBuildRecorder;
import io.quarkiverse.web.bundler.runtime.qute.WebBundlerQuteContextRecorder;
import io.quarkiverse.web.bundler.runtime.qute.WebBundlerQuteEngineObserver;
import io.quarkiverse.web.bundler.sass.SassBuildTimeCompiler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class WebBundlerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerProcessor.class);
    private static final Map<EsBuildConfig.Loader, Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>>> LOADER_CONFIGS = Map.ofEntries(Map.entry(EsBuildConfig.Loader.JS, WebBundlerConfig.LoadersConfig::js), Map.entry(EsBuildConfig.Loader.JSX, WebBundlerConfig.LoadersConfig::jsx), Map.entry(EsBuildConfig.Loader.TS, WebBundlerConfig.LoadersConfig::ts), Map.entry(EsBuildConfig.Loader.TSX, WebBundlerConfig.LoadersConfig::tsx), Map.entry(EsBuildConfig.Loader.CSS, WebBundlerConfig.LoadersConfig::css), Map.entry(EsBuildConfig.Loader.LOCAL_CSS, WebBundlerConfig.LoadersConfig::localCss), Map.entry(EsBuildConfig.Loader.GLOBAL_CSS, WebBundlerConfig.LoadersConfig::globalCss), Map.entry(EsBuildConfig.Loader.JSON, WebBundlerConfig.LoadersConfig::json), Map.entry(EsBuildConfig.Loader.TEXT, WebBundlerConfig.LoadersConfig::text), Map.entry(EsBuildConfig.Loader.FILE, WebBundlerConfig.LoadersConfig::file), Map.entry(EsBuildConfig.Loader.EMPTY, WebBundlerConfig.LoadersConfig::empty), Map.entry(EsBuildConfig.Loader.COPY, WebBundlerConfig.LoadersConfig::copy), Map.entry(EsBuildConfig.Loader.DATAURL, WebBundlerConfig.LoadersConfig::dataUrl), Map.entry(EsBuildConfig.Loader.BASE64, WebBundlerConfig.LoadersConfig::base64), Map.entry(EsBuildConfig.Loader.BINARY, WebBundlerConfig.LoadersConfig::binary));
    private static final String TARGET_DIR_NAME = "web-bundler";

    WebBundlerProcessor() {
    }

    @BuildStep
    void bundle(WebBundlerConfig config, WebDependenciesBuildItem webDependencies, List<EntryPointBuildItem> entryPoints, BundleConfigAssetsBuildItem bundleConfigs, BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchMode, OutputTargetBuildItem outputTarget) throws BuildException {
        block30: {
            boolean isLiveReload;
            if (entryPoints.isEmpty()) {
                LOGGER.info((Object)"No bundle to process");
                return;
            }
            BundlesBuildContext bundlesBuildContext = (BundlesBuildContext)liveReload.getContextObject(BundlesBuildContext.class);
            boolean bl = isLiveReload = liveReload.isLiveReload() && bundlesBuildContext != null && bundlesBuildContext.bundleDistDir() != null;
            if (isLiveReload && webDependencies.getDependencies().equals(bundlesBuildContext.webDependencies()) && !liveReload.getChangedResources().contains("web/tsconfig.json") && entryPoints.equals(bundlesBuildContext.entryPoints())) {
                if (entryPoints.stream().map(EntryPointBuildItem::getWebAssets).flatMap(Collection::stream).map(WebAsset::resourceName).noneMatch(liveReload.getChangedResources()::contains) && Files.isDirectory(bundlesBuildContext.bundleDistDir(), new LinkOption[0])) {
                    LOGGER.debug((Object)"Bundling not needed for live reload");
                    this.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, bundlesBuildContext.bundleDistDir(), false);
                    return;
                }
            }
            boolean hasScssChange = isLiveReload && liveReload.getChangedResources().stream().anyMatch(WebBundlerProcessor::isSassFile);
            Bundler.BundleType type = Bundler.BundleType.valueOf((String)webDependencies.getType().toString());
            Path targetDir = outputTarget.getOutputDirectory().resolve(TARGET_DIR_NAME);
            try {
                if (!isLiveReload) {
                    FileUtil.deleteDirectory((Path)targetDir);
                }
                Files.createDirectories(targetDir, new FileAttribute[0]);
                LOGGER.debugf("Preparing bundle in %s", (Object)targetDir);
                if (!bundleConfigs.getWebAssets().isEmpty()) {
                    for (WebAsset webAsset : bundleConfigs.getWebAssets()) {
                        if (!webAsset.filePath().isPresent()) continue;
                        Path targetConfig = targetDir.resolve(webAsset.pathFromWebRoot(config.webRoot()));
                        Files.deleteIfExists(targetConfig);
                        Files.copy(webAsset.filePath().get(), targetConfig, new CopyOption[0]);
                    }
                }
                Map<String, EsBuildConfig.Loader> loaders = this.computeLoaders(config);
                loaders.put(".scss", EsBuildConfig.Loader.CSS);
                BundleOptionsBuilder options = new BundleOptionsBuilder().setWorkFolder(targetDir).withDependencies(webDependencies.getDependencies()).withEsConfig(new EsBuildConfigBuilder().loader(loaders).addExternal(ConfiguredPaths.surroundWithSlashes(config.staticDir()) + "*").minify(launchMode.getLaunchMode().equals((Object)LaunchMode.NORMAL)).build()).withType(type);
                int addedEntryPoints = 0;
                for (EntryPointBuildItem entryPoint : entryPoints) {
                    ArrayList<String> scripts = new ArrayList<String>();
                    for (BundleWebAsset webAsset : entryPoint.getWebAssets()) {
                        String destination = webAsset.pathFromWebRoot(config.webRoot());
                        Path scriptPath = targetDir.resolve(destination);
                        if (hasScssChange && WebBundlerProcessor.isSassFile(scriptPath.getFileName().toString())) {
                            Files.deleteIfExists(scriptPath);
                        }
                        if (!isLiveReload || liveReload.getChangedResources().contains(webAsset.resourceName()) || !Files.exists(scriptPath, new LinkOption[0])) {
                            Files.createDirectories(scriptPath.getParent(), new FileAttribute[0]);
                            if (webAsset.hasContent()) {
                                Files.write(scriptPath, webAsset.content(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            } else {
                                Files.copy(webAsset.filePath().orElseThrow(), scriptPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        if (webAsset.type().equals((Object)BundleWebAsset.BundleType.MANUAL) || WebBundlerProcessor.isImportSassFile(scriptPath.getFileName().toString())) continue;
                        scripts.add(destination);
                    }
                    String scriptsLog = scripts.stream().map(s -> String.format("  - %s", s)).collect(Collectors.joining("\n"));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("Bundling '%s' (%d files):\n%s", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size(), (Object)scriptsLog);
                    } else {
                        LOGGER.infof("Bundling '%s' (%d files)", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size());
                    }
                    if (scripts.size() <= 0) continue;
                    options.addAutoEntryPoint(targetDir, entryPoint.getEntryPointKey(), scripts);
                    ++addedEntryPoints;
                }
                if (addedEntryPoints > 0) {
                    if (!isLiveReload || hasScssChange) {
                        try (Stream<Path> stream = Files.find(targetDir, Integer.MAX_VALUE, (p, a) -> !p.toString().contains("node_modules") && WebBundlerProcessor.isCompiledSassFile(p.getFileName().toString()), new FileVisitOption[0]);){
                            stream.forEach(p -> WebBundlerProcessor.convertToScss(p, targetDir));
                        }
                    }
                    if (isLiveReload && !Objects.equals(webDependencies.getDependencies(), bundlesBuildContext.webDependencies())) {
                        Bundler.install((Path)targetDir, webDependencies.getDependencies(), (Bundler.BundleType)type);
                        deps = webDependencies.getDependencies().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
                        LOGGER.infof("%s Web dependencies changed: %s", (Object)webDependencies.getType(), (Object)deps);
                    } else if (!isLiveReload) {
                        deps = webDependencies.getDependencies().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
                        LOGGER.infof("%s Web dependencies detected: %s", (Object)webDependencies.getType(), (Object)deps);
                    }
                    BundleResult result = Bundler.bundle((BundleOptions)options.build());
                    if (!result.result().output().isBlank()) {
                        LOGGER.debugf(result.result().output(), new Object[0]);
                    }
                    this.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, result.dist(), true);
                    liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext(webDependencies.getDependencies(), entryPoints, result.dist()));
                    break block30;
                }
                liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
                LOGGER.debugf("No entrypoint found, no bundle generated", new Object[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (BundleException e) {
                liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
                throw e;
            }
        }
    }

    private Map<String, EsBuildConfig.Loader> computeLoaders(WebBundlerConfig config) {
        HashMap<String, EsBuildConfig.Loader> loaders = new HashMap<String, EsBuildConfig.Loader>();
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>> configFn = Objects.requireNonNull(LOADER_CONFIGS.get(loader));
            Optional<Set<String>> values = configFn.apply(config.loaders());
            if (!values.isPresent()) continue;
            for (String v : values.get()) {
                Object ext;
                Object object = ext = v.startsWith(".") ? v : "." + v;
                if (loaders.containsKey(ext)) {
                    throw new ConfigurationException("A Web Bundler file extension for loaders is provided more than once: " + (String)ext);
                }
                loaders.put((String)ext, loader);
            }
        }
        return loaders;
    }

    static void convertToScss(Path file, Path root) {
        LOGGER.debugf("Converting %s to css", (Object)file);
        String content = SassBuildTimeCompiler.convertScss((Path)file, (Path)root, (s, s2) -> {});
        try {
            Files.writeString(file, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void handleBundleDistDir(WebBundlerConfig config, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, Path bundleDir, boolean changed) {
        try {
            HashMap<String, String> bundle = new HashMap<String, String>();
            String bundlePublicPath = ConfiguredPaths.surroundWithSlashes(config.bundleDir());
            ArrayList names = new ArrayList();
            StringBuilder mappingString = new StringBuilder();
            try (Stream<Path> stream = Files.find(bundleDir, 20, (p, i) -> Files.isRegularFile(p, new LinkOption[0]), new FileVisitOption[0]);){
                stream.forEach(path -> {
                    String relativePath = bundleDir.relativize((Path)path).toString();
                    String key = relativePath.replaceAll("-[^.]+\\.", ".");
                    String publicPath = bundlePublicPath + relativePath;
                    String fileName = path.getFileName().toString();
                    String ext = fileName.substring(fileName.indexOf("."));
                    if (Bundle.BUNDLE_MAPPING_EXT.contains(ext)) {
                        mappingString.append("  ").append(key).append(" => ").append(publicPath).append("\n");
                        bundle.put(key, publicPath);
                    }
                    names.add(publicPath);
                    WebBundlerProcessor.makePublic(staticResourceProducer, publicPath, path.normalize(), GeneratedStaticResourceBuildItem.WatchMode.DISABLED, changed);
                });
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Bundle generated in %s (%d files):\n  - %s", (Object)bundleDir, (Object)names.size(), (Object)String.join((CharSequence)"\n  - ", names));
            } else {
                LOGGER.infof("Bundle generated in %s (%d files)", (Object)bundleDir, (Object)names.size());
            }
            LOGGER.infof("Bundle#mapping:\n%s", (Object)mappingString);
            generatedBundleProducer.produce((BuildItem)new GeneratedBundleBuildItem(bundleDir, bundle));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    void processStaticWebAssets(WebBundlerConfig config, StaticAssetsBuildItem staticAssets, BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, LiveReloadBuildItem liveReload) {
        for (WebAsset webAsset : staticAssets.getWebAssets()) {
            String publicPath = webAsset.pathFromWebRoot(config.webRoot());
            WebBundlerProcessor.makeWebAssetPublic(staticResourceProducer, ConfiguredPaths.prefixWithSlash(publicPath), liveReload, webAsset);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initQuteTags(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, WebBundlerQuteContextRecorder recorder, QuteTagsBuildItem quteTags) {
        HashMap<CallSite, String> templates = new HashMap<CallSite, String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (WebAsset webAsset : quteTags.getWebAssets()) {
            String tag = webAsset.filePath().get().getFileName().toString();
            String tagName = tag.contains(".") ? tag.substring(0, tag.indexOf(46)) : tag;
            templates.put((CallSite)((Object)("web-bundler/" + tagName)), new String(webAsset.readContentFromFile(), webAsset.charset()));
            tags.add(tagName);
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WebBundlerQuteEngineObserver.class}));
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(WebBundlerQuteContextRecorder.WebBundlerQuteContext.class).supplier(recorder.createContext(tags, templates)).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initBundler(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, GeneratedBundleBuildItem generatedBundle, WebBundlerBuildRecorder recorder) {
        Map<Object, Object> bundle = generatedBundle != null ? generatedBundle.getBundle() : Map.of();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(Bundle.Mapping.class).supplier(recorder.createContext(bundle)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{Bundle.class}));
    }

    private static void makeWebAssetPublic(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, String publicPath, LiveReloadBuildItem liveReload, WebAsset webAsset) {
        WebBundlerProcessor.handleStaticResource(staticResourceProducer, Set.of(new GeneratedStaticResourceBuildItem.Source(webAsset.resourceName(), webAsset.filePath())), publicPath, webAsset.readContentFromFile(), liveReload.isLiveReload() && liveReload.getChangedResources().contains(webAsset.resourceName()), GeneratedStaticResourceBuildItem.WatchMode.RESTART);
    }

    private static void makePublic(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, String publicPath, Path file, GeneratedStaticResourceBuildItem.WatchMode watchMode, boolean changed) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        WebBundlerProcessor.handleStaticResource(staticResourceProducer, Collections.emptySet(), publicPath, ProjectResourcesScanner.readTemplateContent(file), changed, watchMode);
    }

    private static void handleStaticResource(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, Set<GeneratedStaticResourceBuildItem.Source> sources, String publicPath, byte[] content, boolean changed, GeneratedStaticResourceBuildItem.WatchMode watchMode) {
        staticResourceProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(sources, publicPath, content, true, watchMode, changed));
    }

    public static boolean isCompiledSassFile(String filename) {
        return !filename.startsWith("_") && WebBundlerProcessor.isSassFile(filename);
    }

    public static boolean isImportSassFile(String filename) {
        return filename.startsWith("_") && WebBundlerProcessor.isSassFile(filename);
    }

    public static boolean isSassFile(String filename) {
        String lc = filename.toLowerCase();
        return lc.endsWith(".scss") || lc.endsWith(".sass");
    }

    static {
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            if (LOADER_CONFIGS.containsKey(loader)) continue;
            throw new Error("There is no WebBundleConfig.LoadersConfig for this loader : " + loader);
        }
    }

    public record BundlesBuildContext(List<Path> webDependencies, List<EntryPointBuildItem> entryPoints, Path bundleDistDir) {
        public BundlesBuildContext() {
            this(List.of(), List.of(), null);
        }
    }
}

