/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.staticresources;

import io.quarkiverse.web.bundler.deployment.staticresources.GeneratedStaticResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.staticresources.StaticResourcesDevContext;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class GeneratedStaticResourcesProcessor {
    @BuildStep
    public void processStaticFiles(List<GeneratedStaticResourceBuildItem> staticResources, BuildProducer<GeneratedResourceBuildItem> prodResourcesProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourcesProducer, BuildProducer<AdditionalStaticResourceBuildItem> vertxStaticResourcesProducer, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, CurateOutcomeBuildItem curateOutcome, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchModeBuildItem) {
        File buildDir = launchModeBuildItem.getLaunchMode().isDevOrTest() ? GeneratedStaticResourcesProcessor.getBuildDirectory(curateOutcome) : null;
        StaticResourcesDevContext staticResourcesDevContext = (StaticResourcesDevContext)liveReload.getContextObject(StaticResourcesDevContext.class);
        if (liveReload.isLiveReload() && staticResourcesDevContext != null) {
            staticResourcesDevContext.getGeneratedStaticResourceNames().forEach(r -> {
                if (staticResources.stream().map(GeneratedStaticResourceBuildItem::getResourceName).noneMatch(r::equals)) {
                    try {
                        Files.deleteIfExists(buildDir.toPath().resolve((String)r));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        HashSet<String> generatedStaticFiles = new HashSet<String>();
        for (GeneratedStaticResourceBuildItem staticResource : staticResources) {
            Path targetPath;
            if (!staticResource.getOrigins().isEmpty() && !GeneratedStaticResourceBuildItem.WatchMode.DISABLED.equals((Object)staticResource.getWatchMode())) {
                for (GeneratedStaticResourceBuildItem.Source origin : staticResource.getOrigins()) {
                    watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(origin.getResourceName(), GeneratedStaticResourceBuildItem.WatchMode.RESTART.equals((Object)staticResource.getWatchMode())));
                }
            }
            prodResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem(staticResource.getResourceName(), staticResource.getContent(), true));
            if (staticResource.isNativeEnabled()) {
                nativeImageResourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{staticResource.getResourceName()}));
            }
            vertxStaticResourcesProducer.produce((BuildItem)new AdditionalStaticResourceBuildItem(staticResource.getPublicPath(), false));
            if (launchModeBuildItem.getLaunchMode().isDevOrTest() && (!Files.exists(targetPath = buildDir.toPath().resolve(staticResource.getResourceName()), new LinkOption[0]) || staticResource.isChanged())) {
                try {
                    Files.deleteIfExists(targetPath);
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.write(targetPath, staticResource.getContent(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            generatedStaticFiles.add(staticResource.getResourceName());
        }
        liveReload.setContextObject(StaticResourcesDevContext.class, (Object)new StaticResourcesDevContext(generatedStaticFiles));
    }

    public static File getBuildDirectory(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        File buildDir = null;
        ArtifactSources src = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getSources();
        if (src != null) {
            Collection srcDirs = src.getResourceDirs();
            if (srcDirs.isEmpty()) {
                srcDirs = src.getSourceDirs();
            }
            if (!srcDirs.isEmpty()) {
                Path resourcesOutputDir = ((SourceDir)srcDirs.iterator().next()).getOutputDir();
                buildDir = resourcesOutputDir.toFile();
            }
        }
        if (buildDir == null) {
            buildDir = new File(curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getWorkspaceModule().getBuildDir(), "classes");
        }
        return buildDir;
    }
}

