/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class ScriptDependenciesScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(ScriptDependenciesScannerProcessor.class);

    ScriptDependenciesScannerProcessor() {
    }

    @BuildStep
    WebDependenciesBuildItem collectDependencies(ApplicationArchivesBuildItem applicationArchives, CurateOutcomeBuildItem curateOutcome, WebBundlerConfig config) throws IOException {
        List<Path> webDeps = curateOutcome.getApplicationModel().getRuntimeDependencies().stream().filter(ArtifactCoords::isJar).filter(config.dependencies().type()::matches).map(ResolvedDependency::getResolvedPaths).flatMap(PathCollection::stream).filter(p -> p.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
        return new WebDependenciesBuildItem(config.dependencies().type(), webDeps);
    }
}

