/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.ConfiguredEntryPoint;
import io.quarkiverse.web.bundler.deployment.ProjectResourcesScanner;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleConfigAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.QuteTagsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class WebAssetsScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebAssetsScannerProcessor.class);
    private static final String FEATURE = "web-bundler";
    public static final String MAIN_ENTRYPOINT_KEY = "main";

    WebAssetsScannerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void collect(ApplicationArchivesBuildItem applicationArchives, CurateOutcomeBuildItem curateOutcome, BuildProducer<EntryPointBuildItem> bundles, BuildProducer<StaticAssetsBuildItem> staticAssets, BuildProducer<QuteTagsBuildItem> quteTagsAssets, BuildProducer<BundleConfigAssetsBuildItem> bundleConfigAssets, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, WebBundlerConfig config, LiveReloadBuildItem liveReload) throws IOException {
        watchedFiles.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setLocationPredicate(s -> s.startsWith(config.webRoot())).setRestartNeeded(true).build());
        WebAssetsLookupDevContext devContext = (WebAssetsLookupDevContext)liveReload.getContextObject(WebAssetsLookupDevContext.class);
        if (liveReload.isLiveReload() && devContext != null && !WebAssetsScannerProcessor.hasNewWebResources(config, liveReload, devContext)) {
            LOGGER.debug((Object)"Web bundler scan not needed for live reload");
            this.produceWebAssets(bundles, staticAssets, quteTagsAssets, bundleConfigAssets, devContext, true);
            return;
        }
        LOGGER.debug((Object)"Web bundler scan started");
        Set allApplicationArchives = applicationArchives.getAllApplicationArchives();
        List<ResolvedDependency> extensionArtifacts = curateOutcome.getApplicationModel().getDependencies().stream().filter(Dependency::isRuntimeExtensionArtifact).collect(Collectors.toList());
        HashMap<String, WebBundlerConfig.EntryPointConfig> entryPointsConfig = new HashMap<String, WebBundlerConfig.EntryPointConfig>(config.bundle());
        ArrayList<ProjectResourcesScanner.Scanner> staticAssetsScanners = new ArrayList<ProjectResourcesScanner.Scanner>();
        ArrayList<ProjectResourcesScanner.Scanner> quteTagsAssetsScanners = new ArrayList<ProjectResourcesScanner.Scanner>();
        ArrayList<ProjectResourcesScanner.Scanner> bundleConfigAssetsScanners = new ArrayList<ProjectResourcesScanner.Scanner>();
        if (config.presets().components().enabled()) {
            entryPointsConfig.put("components", new ConfiguredEntryPoint("components", "components", config.presets().components().entryPointKey().orElse(MAIN_ENTRYPOINT_KEY)));
            quteTagsAssetsScanners.add(new ProjectResourcesScanner.Scanner(config.fromWebRoot("components"), "glob:**.html", config.charset()));
        }
        ProjectResourcesScanner resourcesScanner = new ProjectResourcesScanner(allApplicationArchives, extensionArtifacts);
        if (config.presets().app().enabled()) {
            entryPointsConfig.put("app", new ConfiguredEntryPoint("app", "app", config.presets().app().entryPointKey().orElse(MAIN_ENTRYPOINT_KEY)));
        }
        staticAssetsScanners.add(new ProjectResourcesScanner.Scanner(config.fromWebRoot(config.staticDir()), "glob:**", config.charset()));
        HashMap<String, List<BundleWebAsset>> bundleAssets = new HashMap<String, List<BundleWebAsset>>();
        for (Map.Entry e : entryPointsConfig.entrySet()) {
            if (!((WebBundlerConfig.EntryPointConfig)e.getValue()).enabled()) continue;
            String entryPointKey = ((WebBundlerConfig.EntryPointConfig)e.getValue()).effectiveKey((String)e.getKey());
            bundleAssets.putIfAbsent(entryPointKey, new ArrayList());
            String dirFromWebRoot = config.fromWebRoot(((WebBundlerConfig.EntryPointConfig)e.getValue()).effectiveDir((String)e.getKey()));
            List<WebAsset> assets = resourcesScanner.scan(dirFromWebRoot, "regex:^(.(?!\\.html$))*$", config.charset());
            Optional<WebAsset> entryPoint = assets.stream().filter(w -> w.resourceName().startsWith(PathUtils.addTrailingSlash(dirFromWebRoot) + "index.")).findAny();
            for (WebAsset webAsset : assets) {
                BundleWebAsset.BundleType bundleType = entryPoint.map(ep -> webAsset.equals(ep) ? BundleWebAsset.BundleType.ENTRYPOINT : BundleWebAsset.BundleType.MANUAL).orElse(BundleWebAsset.BundleType.AUTO);
                ((List)bundleAssets.get(entryPointKey)).add(new BundleWebAsset(webAsset, bundleType));
            }
        }
        bundleConfigAssetsScanners.add(new ProjectResourcesScanner.Scanner(config.webRoot(), "glob:tsconfig.json", config.charset()));
        WebAssetsLookupDevContext context = new WebAssetsLookupDevContext(bundleAssets, resourcesScanner.scan(staticAssetsScanners), resourcesScanner.scan(quteTagsAssetsScanners), resourcesScanner.scan(bundleConfigAssetsScanners));
        this.produceWebAssets(bundles, staticAssets, quteTagsAssets, bundleConfigAssets, context, false);
        liveReload.setContextObject(WebAssetsLookupDevContext.class, (Object)context);
    }

    private static boolean hasNewWebResources(WebBundlerConfig config, LiveReloadBuildItem liveReload, WebAssetsLookupDevContext devContext) {
        Set webAssets = devContext.allWebAssets().stream().map(WebAsset::resourceName).collect(Collectors.toSet());
        return !liveReload.getChangedResources().stream().filter(c -> c.startsWith(config.webRoot())).allMatch(webAssets::contains);
    }

    void produceWebAssets(BuildProducer<EntryPointBuildItem> bundles, BuildProducer<StaticAssetsBuildItem> staticAssets, BuildProducer<QuteTagsBuildItem> quteTagsAssets, BuildProducer<BundleConfigAssetsBuildItem> bundleConfigAssets, WebAssetsLookupDevContext context, boolean checkIfExists) {
        for (Map.Entry<String, List<BundleWebAsset>> e : context.bundleAssets().entrySet()) {
            bundles.produce((BuildItem)new EntryPointBuildItem(e.getKey(), checkIfExists ? WebAssetsScannerProcessor.checkWebAssets(e.getValue()) : e.getValue()));
        }
        staticAssets.produce((BuildItem)new StaticAssetsBuildItem(checkIfExists ? WebAssetsScannerProcessor.checkWebAssets(context.staticWebAssets()) : context.staticWebAssets()));
        bundleConfigAssets.produce((BuildItem)new BundleConfigAssetsBuildItem(checkIfExists ? WebAssetsScannerProcessor.checkWebAssets(context.bundleConfigWebAssets()) : context.bundleConfigWebAssets()));
        quteTagsAssets.produce((BuildItem)new QuteTagsBuildItem(checkIfExists ? WebAssetsScannerProcessor.checkWebAssets(context.quteWebAssets()) : context.quteWebAssets()));
    }

    private static <T extends WebAsset> List<T> checkWebAssets(List<T> webAssets) {
        return webAssets.stream().filter(w -> w.filePath().isPresent() && Files.isRegularFile(w.filePath().get(), new LinkOption[0])).collect(Collectors.toList());
    }

    record WebAssetsLookupDevContext(Map<String, List<BundleWebAsset>> bundleAssets, List<WebAsset> staticWebAssets, List<WebAsset> quteWebAssets, List<WebAsset> bundleConfigWebAssets) {
        public List<WebAsset> allWebAssets() {
            ArrayList<WebAsset> all = new ArrayList<WebAsset>();
            all.addAll(this.staticWebAssets);
            all.addAll(this.quteWebAssets);
            all.addAll(this.bundleConfigWebAssets);
            this.bundleAssets.values().forEach(all::addAll);
            return all;
        }
    }
}

