/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.model.WebDependency;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class WebDependenciesScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebDependenciesScannerProcessor.class);

    WebDependenciesScannerProcessor() {
    }

    @BuildStep
    WebDependenciesBuildItem collectDependencies(CurateOutcomeBuildItem curateOutcome, WebBundlerConfig config) {
        List<WebDependency> webDeps = curateOutcome.getApplicationModel().getRuntimeDependencies().stream().filter(ArtifactCoords::isJar).filter(d -> WebDependency.WebDependencyType.anyMatch((String)d.toCompactCoords())).map(WebDependenciesScannerProcessor::toWebDep).filter(Objects::nonNull).collect(Collectors.toList());
        return new WebDependenciesBuildItem(webDeps);
    }

    private static WebDependency toWebDep(ResolvedDependency d) {
        return d.getResolvedPaths().stream().filter(p -> p.getFileName().toString().endsWith(".jar")).findFirst().map(j -> new WebDependency(d.toCompactCoords(), j, (WebDependency.WebDependencyType)WebDependency.WebDependencyType.resolveType((String)d.toCompactCoords()).orElseThrow())).orElse(null);
    }
}

