/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ProjectResourcesScannerBuildItem;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.staticresources.GeneratedStaticResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;

public class StaticWebAssetsProcessor {
    @BuildStep
    void processStaticWebAssets(WebBundlerConfig config, StaticAssetsBuildItem staticAssets, BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, LiveReloadBuildItem liveReload) {
        for (WebAsset webAsset : staticAssets.getWebAssets()) {
            String publicPath = webAsset.pathFromWebRoot(config.webRoot());
            StaticWebAssetsProcessor.makeWebAssetPublic(staticResourceProducer, PathUtils.prefixWithSlash((String)publicPath), liveReload, webAsset);
        }
    }

    static void makeWebAssetPublic(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, String publicPath, LiveReloadBuildItem liveReload, WebAsset webAsset) {
        StaticWebAssetsProcessor.makeWebAssetPublic(staticResourceProducer, publicPath, webAsset, liveReload.isLiveReload() && liveReload.getChangedResources().contains(webAsset.resourceName()));
    }

    static void makeWebAssetPublic(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, String publicPath, WebAsset webAsset, boolean changed) {
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, Set.of(new GeneratedStaticResourceBuildItem.Source(webAsset.resourceName(), webAsset.filePath())), publicPath, webAsset.contentOrReadFromFile(), changed, GeneratedStaticResourceBuildItem.WatchMode.RESTART);
    }

    static void makePublic(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, String publicPath, Path file, GeneratedStaticResourceBuildItem.WatchMode watchMode, boolean changed) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, Collections.emptySet(), publicPath, ProjectResourcesScannerBuildItem.readTemplateContent((Path)file), changed, watchMode);
    }

    private static void handleStaticResource(BuildProducer<GeneratedStaticResourceBuildItem> staticResourceProducer, Set<GeneratedStaticResourceBuildItem.Source> sources, String publicPath, byte[] content, boolean changed, GeneratedStaticResourceBuildItem.WatchMode watchMode) {
        staticResourceProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(sources, publicPath, content, true, watchMode, changed));
    }
}

