/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.StaticWebAssetsProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.QuteTemplatesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.runtime.Bundle;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Qute;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.config.ConfigProvider;

public class QuteTemplateWebAssetsProcessor {
    @BuildStep
    void processHtmlTemplateWebAssets(WebBundlerConfig config, QuteTemplatesBuildItem htmlTemplates, GeneratedBundleBuildItem generatedBundle, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchMode) {
        final Map<Object, Object> bundle = generatedBundle != null ? generatedBundle.getBundle() : Map.of();
        Bundle.Mapping mapping = new Bundle.Mapping(){

            public String get(String name) {
                return (String)bundle.get(name);
            }

            public Set<String> names() {
                return bundle.keySet();
            }
        };
        Engine engine = Engine.builder().addDefaults().addNamespaceResolver(NamespaceResolver.builder((String)"inject").resolve(c -> c.getName().equals("bundle") ? new Bundle(mapping) : null).build()).addNamespaceResolver(NamespaceResolver.builder((String)"build").resolve(c -> c.getName().equals("launchMode") ? launchMode.getLaunchMode().toString() : null).build()).addNamespaceResolver(NamespaceResolver.builder((String)"config").resolveAsync(this::resolveConfig).build()).addLocator((TemplateLocator)new WebBundlerTagsLocator()).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("bundle", "web-bundler/bundle.html")).addValueResolver((ValueResolver)new ReflectionValueResolver()).addParserHook((ParserHook)new Qute.IndexedArgumentsParserHook()).addResultMapper((ResultMapper)new HtmlEscaper(ImmutableList.of((Object)"text/html", (Object)"text/xml"))).build();
        for (WebAsset webAsset : htmlTemplates.getWebAssets()) {
            byte[] bytes = webAsset.contentOrReadFromFile();
            String content = engine.parse(new String(bytes, webAsset.charset())).render();
            StaticWebAssetsProcessor.makeWebAssetPublic(staticResourceProducer, PathUtils.prefixWithSlash((String)webAsset.pathFromWebRoot(config.webRoot())), HtmlPageWebAsset.of(webAsset, content));
        }
    }

    private CompletionStage<Object> resolveConfig(EvalContext ctx) {
        List params = ctx.getParams();
        String name = ctx.getName();
        if (params.isEmpty()) {
            return QuteTemplateWebAssetsProcessor.findConfig(name, String.class);
        }
        if (name.equals("boolean")) {
            return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> QuteTemplateWebAssetsProcessor.findConfig(propertyName.toString(), Boolean.class));
        }
        if (name.equals("integer")) {
            return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> QuteTemplateWebAssetsProcessor.findConfig(propertyName.toString(), Integer.class));
        }
        return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> QuteTemplateWebAssetsProcessor.findConfig(propertyName.toString(), String.class));
    }

    private static <T> CompletableFuture<Object> findConfig(String propertyName, Class<T> type) {
        Optional val = ConfigProvider.getConfig().getOptionalValue(propertyName, type);
        return CompletableFuture.completedFuture(val.isPresent() ? val.get() : Results.NotFound.from((String)propertyName));
    }

    private static final class WebBundlerTagsLocator
    implements TemplateLocator {
        private WebBundlerTagsLocator() {
        }

        public Optional<TemplateLocator.TemplateLocation> locate(String id) {
            if (!id.startsWith("web-bundler/")) {
                return Optional.empty();
            }
            String name = id.replace("web-bundler/", "");
            final URL resource = this.getClass().getResource("/templates/tags/" + name);
            if (resource == null) {
                return Optional.empty();
            }
            return Optional.of(new TemplateLocator.TemplateLocation(){

                public Reader read() {
                    try {
                        return new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public Optional<Variant> getVariant() {
                    return Optional.empty();
                }
            });
        }
    }

    record HtmlPageWebAsset(String resourceName, byte[] content, Charset charset) implements WebAsset
    {
        static HtmlPageWebAsset of(WebAsset sourceAsset, String content) {
            return new HtmlPageWebAsset(sourceAsset.resourceName(), content.getBytes(sourceAsset.charset()), sourceAsset.charset());
        }

        public Optional<Path> filePath() {
            return Optional.empty();
        }
    }
}

