/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.model.AutoEntryPoint;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleOptionsBuilder;
import io.mvnpm.esbuild.model.BundleResult;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.EsBuildConfigBuilder;
import io.quarkiverse.web.bundler.deployment.StaticWebAssetsProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleConfigAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.runtime.Bundle;
import io.quarkiverse.web.bundler.runtime.BundleRedirectHandlerRecorder;
import io.quarkiverse.web.bundler.runtime.WebBundlerBuildRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class WebBundlerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerProcessor.class);
    private static final Map<EsBuildConfig.Loader, Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>>> LOADER_CONFIGS = Map.ofEntries(Map.entry(EsBuildConfig.Loader.JS, WebBundlerConfig.LoadersConfig::js), Map.entry(EsBuildConfig.Loader.JSX, WebBundlerConfig.LoadersConfig::jsx), Map.entry(EsBuildConfig.Loader.TS, WebBundlerConfig.LoadersConfig::ts), Map.entry(EsBuildConfig.Loader.TSX, WebBundlerConfig.LoadersConfig::tsx), Map.entry(EsBuildConfig.Loader.CSS, WebBundlerConfig.LoadersConfig::css), Map.entry(EsBuildConfig.Loader.LOCAL_CSS, WebBundlerConfig.LoadersConfig::localCss), Map.entry(EsBuildConfig.Loader.GLOBAL_CSS, WebBundlerConfig.LoadersConfig::globalCss), Map.entry(EsBuildConfig.Loader.JSON, WebBundlerConfig.LoadersConfig::json), Map.entry(EsBuildConfig.Loader.TEXT, WebBundlerConfig.LoadersConfig::text), Map.entry(EsBuildConfig.Loader.FILE, WebBundlerConfig.LoadersConfig::file), Map.entry(EsBuildConfig.Loader.EMPTY, WebBundlerConfig.LoadersConfig::empty), Map.entry(EsBuildConfig.Loader.COPY, WebBundlerConfig.LoadersConfig::copy), Map.entry(EsBuildConfig.Loader.DATAURL, WebBundlerConfig.LoadersConfig::dataUrl), Map.entry(EsBuildConfig.Loader.BASE64, WebBundlerConfig.LoadersConfig::base64), Map.entry(EsBuildConfig.Loader.BINARY, WebBundlerConfig.LoadersConfig::binary));
    private static final String TARGET_DIR_NAME = "web-bundler";

    WebBundlerProcessor() {
    }

    @BuildStep
    void bundle(WebBundlerConfig config, WebDependenciesBuildItem webDependencies, List<EntryPointBuildItem> entryPoints, Optional<BundleConfigAssetsBuildItem> bundleConfig, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchMode, OutputTargetBuildItem outputTarget) throws BuildException {
        boolean isLiveReload;
        if (entryPoints.isEmpty()) {
            if (!config.dependencies().autoImport().isEnabled()) {
                LOGGER.warn((Object)"Skipping Web-Bundling because no entry-point detected (create one or enable auto-import)");
                return;
            }
            if (webDependencies.isEmpty()) {
                LOGGER.warn((Object)"Skipping Web-Bundling because no Web Dependencies found for auto-import.");
                return;
            }
            LOGGER.info((Object)"No entry points found, it will be generated based on direct Web Dependencies.");
        }
        BundlesBuildContext bundlesBuildContext = (BundlesBuildContext)liveReload.getContextObject(BundlesBuildContext.class);
        boolean bl = isLiveReload = liveReload.isLiveReload() && bundlesBuildContext != null && bundlesBuildContext.bundleDistDir() != null;
        if (isLiveReload && Objects.equals(webDependencies.list(), bundlesBuildContext.dependencies()) && !liveReload.getChangedResources().contains(config.fromWebRoot("tsconfig.json")) && entryPoints.equals(bundlesBuildContext.entryPoints())) {
            if (entryPoints.stream().map(EntryPointBuildItem::getWebAssets).flatMap(Collection::stream).map(WebAsset::resourceName).noneMatch(liveReload.getChangedResources()::contains) && Files.isDirectory(bundlesBuildContext.bundleDistDir(), new LinkOption[0])) {
                LOGGER.debug((Object)"Bundling not needed for live reload");
                this.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, bundlesBuildContext.bundleDistDir(), null, false);
                return;
            }
        }
        Path targetDir = outputTarget.getOutputDirectory().resolve(TARGET_DIR_NAME);
        Path nodeModulesDir = WebBundlerProcessor.resolveNodeModulesDir(config, outputTarget);
        try {
            if (!isLiveReload) {
                FileUtil.deleteDirectory((Path)targetDir);
            }
            Files.createDirectories(targetDir, new FileAttribute[0]);
            LOGGER.debugf("Preparing bundle in %s", (Object)targetDir);
            if (bundleConfig.isPresent()) {
                for (WebAsset webAsset : bundleConfig.get().getWebAssets()) {
                    if (!webAsset.filePath().isPresent()) continue;
                    Path targetConfig = targetDir.resolve(webAsset.pathFromWebRoot(config.webRoot()));
                    Files.deleteIfExists(targetConfig);
                    Files.copy((Path)webAsset.filePath().get(), targetConfig, new CopyOption[0]);
                }
            }
            Map<String, EsBuildConfig.Loader> loaders = this.computeLoaders(config);
            EsBuildConfigBuilder esBuildConfigBuilder = new EsBuildConfigBuilder().loader(loaders).publicPath(config.publicBundlePath()).splitting(config.bundleSplitting().booleanValue()).minify(launchMode.getLaunchMode().equals((Object)LaunchMode.NORMAL));
            if (config.externalImports().isPresent()) {
                for (String e : (List)config.externalImports().get()) {
                    esBuildConfigBuilder.addExternal(e);
                }
            } else {
                esBuildConfigBuilder.addExternal(PathUtils.join((String)config.httpRootPath(), (String)"static/*"));
            }
            BundleOptionsBuilder optionsBuilder = new BundleOptionsBuilder().withWorkDir(targetDir).withDependencies(webDependencies.list().stream().map(WebDependenciesBuildItem.Dependency::toEsBuildWebDependency).toList()).withEsConfig(esBuildConfigBuilder.build()).withNodeModulesDir(nodeModulesDir);
            Set directWebDependenciesIds = webDependencies.list().stream().filter(WebDependenciesBuildItem.Dependency::direct).map(WebDependenciesBuildItem.Dependency::id).collect(Collectors.toSet());
            int addedEntryPoints = 0;
            AutoEntryPoint.AutoDepsMode autoDepsMode = AutoEntryPoint.AutoDepsMode.valueOf((String)config.dependencies().autoImport().mode().toString());
            for (EntryPointBuildItem entryPoint : entryPoints) {
                ArrayList<String> scripts = new ArrayList<String>();
                for (BundleWebAsset webAsset : entryPoint.getWebAssets()) {
                    String destination = webAsset.pathFromWebRoot(config.webRoot());
                    Path scriptPath = targetDir.resolve(destination);
                    if (!isLiveReload || liveReload.getChangedResources().contains(webAsset.resourceName()) || !Files.exists(scriptPath, new LinkOption[0])) {
                        Files.createDirectories(scriptPath.getParent(), new FileAttribute[0]);
                        if (webAsset.hasContent()) {
                            Files.write(scriptPath, webAsset.content(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        } else {
                            Files.copy((Path)webAsset.filePath().orElseThrow(), scriptPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    if (webAsset.type().equals((Object)BundleWebAsset.BundleType.MANUAL)) continue;
                    scripts.add(destination);
                }
                String scriptsLog = scripts.stream().map(s -> String.format("  - %s", s)).collect(Collectors.joining("\n"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Bundling '%s' (%d files):\n%s", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size(), (Object)scriptsLog);
                } else {
                    LOGGER.infof("Bundling '%s' (%d files)", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size());
                }
                if (scripts.isEmpty()) continue;
                optionsBuilder.addAutoEntryPoint(targetDir, entryPoint.getEntryPointKey(), scripts, autoDepsMode, directWebDependenciesIds::contains);
                ++addedEntryPoints;
            }
            if (addedEntryPoints == 0) {
                optionsBuilder.addAutoEntryPoint(targetDir, "main", List.of(), autoDepsMode, directWebDependenciesIds::contains);
                LOGGER.info((Object)"No custom entry points found, it will be generated based on web dependencies.");
            }
            BundleOptions options = optionsBuilder.build();
            if (!isLiveReload || !Objects.equals(webDependencies.list(), bundlesBuildContext.dependencies())) {
                long startedInstall = Instant.now().toEpochMilli();
                if (Bundler.install((Path)targetDir, (BundleOptions)options)) {
                    long duration = Instant.now().minusMillis(startedInstall).toEpochMilli();
                    if (LOGGER.isDebugEnabled()) {
                        String deps = webDependencies.list().stream().map(WebDependenciesBuildItem.Dependency::id).collect(Collectors.joining(", "));
                        LOGGER.infof("%d web dependencies installed in %sms: %s", (Object)webDependencies.list().size(), (Object)duration, (Object)deps);
                    } else {
                        LOGGER.infof("%d web Dependencies installed in %sms.", (Object)webDependencies.list().size(), (Object)duration);
                    }
                } else if (webDependencies.isEmpty()) {
                    LOGGER.info((Object)"No web dependencies to install.");
                } else {
                    LOGGER.info((Object)"All web dependencies are already installed.");
                }
            }
            long startedBundling = Instant.now().toEpochMilli();
            BundleResult result = Bundler.bundle((BundleOptions)options, (boolean)false);
            if (!result.result().output().isBlank()) {
                LOGGER.debugf(result.result().output(), new Object[0]);
            }
            this.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, result.dist(), startedBundling, true);
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext(webDependencies.list(), entryPoints, result.dist()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (BundleException e) {
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
            throw e;
        }
    }

    private static Path resolveNodeModulesDir(WebBundlerConfig config, OutputTargetBuildItem outputTarget) {
        if (config.dependencies().nodeModules().isEmpty()) {
            return outputTarget.getOutputDirectory().resolve("node_modules");
        }
        Path projectRoot = WebBundlerProcessor.findProjectRoot(outputTarget.getOutputDirectory());
        Path nodeModulesDir = Path.of(((String)config.dependencies().nodeModules().get()).trim(), new String[0]);
        if (nodeModulesDir.isAbsolute() && Files.isDirectory(nodeModulesDir.getParent(), new LinkOption[0])) {
            return nodeModulesDir;
        }
        if (projectRoot == null || !Files.isDirectory(projectRoot, new LinkOption[0])) {
            throw new IllegalStateException("If not absolute, the node_modules directory is resolved relative to the project root, but Web Bundler was not able to find the project root.");
        }
        return projectRoot.resolve(nodeModulesDir);
    }

    private Map<String, EsBuildConfig.Loader> computeLoaders(WebBundlerConfig config) {
        HashMap<String, EsBuildConfig.Loader> loaders = new HashMap<String, EsBuildConfig.Loader>();
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>> configFn = Objects.requireNonNull(LOADER_CONFIGS.get(loader));
            Optional<Set<String>> values = configFn.apply(config.loaders());
            if (!values.isPresent()) continue;
            for (String v : values.get()) {
                Object ext;
                Object object = ext = v.startsWith(".") ? v : "." + v;
                if (loaders.containsKey(ext)) {
                    throw new ConfigurationException("A Web Bundler file extension for loaders is provided more than once: " + (String)ext);
                }
                loaders.put((String)ext, loader);
            }
        }
        return loaders;
    }

    void handleBundleDistDir(WebBundlerConfig config, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, Path bundleDir, Long started, boolean changed) {
        try {
            HashMap<String, String> bundle = new HashMap<String, String>();
            ArrayList names = new ArrayList();
            StringBuilder mappingString = new StringBuilder();
            try (Stream<Path> stream = Files.find(bundleDir, 20, (p, i) -> Files.isRegularFile(p, new LinkOption[0]), new FileVisitOption[0]);){
                stream.forEach(path -> {
                    String relativePath = bundleDir.relativize((Path)path).toString();
                    String key = relativePath.replaceAll("-[^-.]+\\.", ".");
                    String publicBundleAssetPath = PathUtils.join((String)config.publicBundlePath(), (String)relativePath);
                    String fileName = path.getFileName().toString();
                    String ext = fileName.substring(fileName.indexOf("."));
                    if (Bundle.BUNDLE_MAPPING_EXT.contains(ext)) {
                        mappingString.append("  ").append(key).append(" => ").append(publicBundleAssetPath).append("\n");
                        bundle.put(key, publicBundleAssetPath);
                    }
                    names.add(publicBundleAssetPath);
                    if (config.shouldQuarkusServeBundle()) {
                        String resourcePath = PathUtils.surroundWithSlashes((String)config.bundlePath()) + relativePath;
                        StaticWebAssetsProcessor.makePublic(staticResourceProducer, resourcePath, path.normalize());
                    }
                });
            }
            if (started != null) {
                LOGGER.infof("Bundle generated %d files in %sms", (Object)names.size(), (Object)Instant.now().minusMillis(started).toEpochMilli());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Bundle dir: '%s'\n  - %s", (Object)bundleDir, (Object)names.size(), (Object)String.join((CharSequence)"\n  - ", names));
                }
                if (LOGGER.isDebugEnabled() || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                    LOGGER.infof("Bundle#mapping:\n%s", (Object)mappingString);
                }
            }
            generatedBundleProducer.produce((BuildItem)new GeneratedBundleBuildItem(bundleDir, bundle));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initBundleBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, GeneratedBundleBuildItem generatedBundle, WebBundlerBuildRecorder recorder) {
        Map<Object, Object> bundle = generatedBundle != null ? generatedBundle.getBundle() : Map.of();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(Bundle.Mapping.class).supplier(recorder.createContext(bundle)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{Bundle.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initBundleRedirect(WebBundlerConfig config, BuildProducer<RouteBuildItem> routes, BundleRedirectHandlerRecorder recorder, GeneratedBundleBuildItem generatedBundle) {
        if (config.bundleRedirect().booleanValue()) {
            Map<Object, Object> bundle = generatedBundle != null ? generatedBundle.getBundle() : Map.of();
            routes.produce((BuildItem)RouteBuildItem.builder().route(PathUtils.join((String)PathUtils.prefixWithSlash((String)config.bundlePath()), (String)"*")).handler(recorder.handler(bundle)).build());
        }
    }

    static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    static {
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            if (LOADER_CONFIGS.containsKey(loader)) continue;
            throw new Error("There is no WebBundleConfig.LoadersConfig for this loader : " + loader);
        }
    }

    public record BundlesBuildContext(List<WebDependenciesBuildItem.Dependency> dependencies, List<EntryPointBuildItem> entryPoints, Path bundleDistDir) {
        public BundlesBuildContext() {
            this(List.of(), List.of(), null);
        }
    }
}

