/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.model.WebDependency;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;

class WebDependenciesScannerProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebDependenciesScannerProcessor.class);

    WebDependenciesScannerProcessor() {
    }

    @BuildStep
    WebDependenciesBuildItem collectDependencies(LaunchModeBuildItem launchMode, CurateOutcomeBuildItem curateOutcome, List<EntryPointBuildItem> entryPoints, WebBundlerConfig config) {
        if (entryPoints.isEmpty() && !config.dependencies().autoImport().isEnabled()) {
            return new WebDependenciesBuildItem(List.of());
        }
        List<WebDependenciesBuildItem.Dependency> dependencies = StreamSupport.stream(curateOutcome.getApplicationModel().getDependenciesWithAnyFlag(new int[]{4096, 4}).spliterator(), false).filter(ArtifactCoords::isJar).filter(d -> WebDependency.WebDependencyType.anyMatch((String)d.toCompactCoords())).peek(d -> this.checkScope(launchMode, (ResolvedDependency)d, config)).map(WebDependenciesScannerProcessor::toWebDep).filter(Objects::nonNull).collect(Collectors.toList());
        return new WebDependenciesBuildItem(dependencies);
    }

    private void checkScope(LaunchModeBuildItem launchMode, ResolvedDependency d, WebBundlerConfig config) {
        if (!launchMode.getLaunchMode().isDevOrTest() && config.dependencies().compileOnly() && d.isRuntimeCp()) {
            throw new ConfigurationException("The Web Bundler is configured to only include compileOnly web dependencies, but %s is set as runtime. Use a compile only scope (e.g. provided) or set quarkus.web-bundler.dependencies.compile-only=false to allow runtime web dependencies.".formatted(d.toCompactCoords()));
        }
    }

    private static WebDependenciesBuildItem.Dependency toWebDep(ResolvedDependency d) {
        return d.getResolvedPaths().stream().filter(p -> p.getFileName().toString().endsWith(".jar")).findFirst().map(j -> new WebDependenciesBuildItem.Dependency(d.toCompactCoords(), (Path)j, (WebDependency.WebDependencyType)WebDependency.WebDependencyType.resolveType((String)d.toCompactCoords()).orElseThrow(), d.isDirect())).orElse(null);
    }
}

