/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.web;

import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourcesDevContext;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceHandler;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceRecorder;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class GeneratedWebResourcesProcessor {
    private static final Logger LOGGER = Logger.getLogger(GeneratedWebResourcesProcessor.class);

    @BuildStep
    public void processStaticFiles(List<GeneratedWebResourceBuildItem> staticResources, BuildProducer<GeneratedResourceBuildItem> prodResourcesProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourcesProducer, CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchModeBuildItem) {
        if (staticResources.isEmpty()) {
            return;
        }
        if (launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            Path buildDir = GeneratedWebResourcesProcessor.getBuildDirectory(outputTarget, curateOutcome);
            GeneratedWebResourcesDevContext generatedWebResourcesDevContext = (GeneratedWebResourcesDevContext)liveReload.getContextObject(GeneratedWebResourcesDevContext.class);
            HashMap<String, String> hashes = new HashMap<String, String>();
            if (liveReload.isLiveReload() && generatedWebResourcesDevContext != null) {
                for (GeneratedWebResourceBuildItem r : staticResources) {
                    String publicPath = r.publicPath();
                    if (!Objects.equals(generatedWebResourcesDevContext.generatedResourcesHashes().get(publicPath), r.contentHash())) {
                        GeneratedWebResourcesProcessor.createGeneratedResourceOnDisk(r, buildDir);
                    }
                    hashes.put(r.publicPath(), r.contentHash());
                }
            } else {
                try {
                    FileUtil.deleteDirectory((Path)buildDir.resolve("META-INF/web"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (GeneratedWebResourceBuildItem r : staticResources) {
                    GeneratedWebResourcesProcessor.createGeneratedResourceOnDisk(r, buildDir);
                }
            }
            liveReload.setContextObject(GeneratedWebResourcesDevContext.class, (Object)new GeneratedWebResourcesDevContext(hashes));
        }
        for (GeneratedWebResourceBuildItem staticResource : staticResources) {
            prodResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem(staticResource.resourceName(), staticResource.content(), false));
            nativeImageResourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{staticResource.resourceName()}));
        }
    }

    private static void createGeneratedResourceOnDisk(GeneratedWebResourceBuildItem r, Path buildDir) {
        Path targetPath = buildDir.resolve(r.resourceName());
        try {
            Files.deleteIfExists(targetPath);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.write(targetPath, r.content(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(LaunchModeBuildItem launchMode, List<GeneratedWebResourceBuildItem> staticResources, WebBundlerResourceRecorder recorder, CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, BuildProducer<RouteBuildItem> routes) throws IOException {
        if (!staticResources.isEmpty()) {
            String metaInfWeb = launchMode.getLaunchMode().isDevOrTest() ? GeneratedWebResourcesProcessor.getBuildDirectory(outputTarget, curateOutcome).resolve("META-INF/web").toAbsolutePath().toString() : null;
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(WebBundlerResourceHandler.DEFAULT_ROUTE_ORDER)).handler(recorder.createHandler(metaInfWeb, staticResources.stream().map(GeneratedWebResourceBuildItem::publicPath).collect(Collectors.toSet()), launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT)).build());
        }
    }

    public static Path getBuildDirectory(OutputTargetBuildItem outputTarget, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (Files.exists(outputTarget.getOutputDirectory().resolve("classes/META-INF/resources"), new LinkOption[0])) {
            return outputTarget.getOutputDirectory().resolve("classes");
        }
        if (Files.exists(outputTarget.getOutputDirectory().resolve("resources/main/META-INF/resources"), new LinkOption[0])) {
            return outputTarget.getOutputDirectory().resolve("resources/main");
        }
        ArtifactSources src = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getSources();
        if (src != null) {
            Collection dirs = src.getResourceDirs();
            if (dirs.isEmpty()) {
                dirs = src.getSourceDirs();
            }
            if (!dirs.isEmpty()) {
                Set outputDirs = dirs.stream().map(SourceDir::getOutputDir).collect(Collectors.toSet());
                if (outputDirs.size() > 1) {
                    LOGGER.warnf("Multiple resources directories found, using the first one in the list: %s", outputDirs);
                }
                return (Path)outputDirs.iterator().next();
            }
        }
        throw new RuntimeException("Unable to determine the build directory");
    }
}

