/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.Watch;
import io.mvnpm.esbuild.model.BundleOptions;
import io.quarkiverse.web.bundler.deployment.BundlingProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedEntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class DevModeBundlingProcessor {
    private static final Logger LOGGER = Logger.getLogger(DevModeBundlingProcessor.class);
    private static final String DEV_SERVICE_NAME = "web-bundler-dev";
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static final AtomicReference<Watch> watchRef;
    private static final AtomicReference<BundleException> bundleExceptionRef;
    private static final AtomicReference<CountDownLatch> WAITER;
    private static volatile long lastBundling;

    @BuildStep(onlyIf={IsDevelopment.class})
    void watch(WebBundlerConfig config, ReadyForBundlingBuildItem readyForBundling, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<DevServicesResultBuildItem> devServices, BuildProducer<GeneratedEntryPointBuildItem> generatedEntryPointProducer, LiveReloadBuildItem liveReload, CuratedApplicationShutdownBuildItem shutdown) {
        BundlesBuildContext bundlesBuildContext = (BundlesBuildContext)liveReload.getContextObject(BundlesBuildContext.class);
        boolean isLiveReload = liveReload.isLiveReload();
        Watch watch = watchRef.get();
        if (isLiveReload && devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = bundlesBuildContext == null || watch == null || !watch.isAlive() || !WebBundlerConfig.isEqual((WebBundlerConfig)config, (WebBundlerConfig)bundlesBuildContext.config());
            if (!shouldShutdownTheBroker) {
                try {
                    if (readyForBundling.started() == null) {
                        watch.updateEntries(readyForBundling.bundleOptions().entries());
                        this.waitForBundling(readyForBundling);
                    }
                    devServices.produce((BuildItem)devService.toBuildItem());
                    BundlesBuildContext newBundlesBuildContext = new BundlesBuildContext(readyForBundling.bundleOptions(), config, watch.dist());
                    liveReload.setContextObject(BundlesBuildContext.class, (Object)newBundlesBuildContext);
                    BundlingProcessor.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, watch.dist(), readyForBundling.started());
                    BundlingProcessor.processGeneratedEntryPoints(config, readyForBundling.bundleOptions().workDir(), generatedEntryPointProducer);
                }
                catch (IOException e) {
                    this.shutdownDevService();
                    liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
                    throw new UncheckedIOException(e);
                }
                catch (Exception e) {
                    this.shutdownDevService();
                    liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
                    throw e;
                }
                return;
            }
            this.shutdownDevService();
        }
        if (!isLiveReload) {
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownDevService();
                }
            };
            shutdown.addCloseTask(closeTask, true);
        }
        try {
            watch = Bundler.watch((BundleOptions)readyForBundling.bundleOptions(), r -> {
                if (watchRef.get() == null) {
                    LOGGER.error((Object)"Received a bundling event without a watchRef");
                    return;
                }
                LOGGER.debugf("New bundling event received: %s", (Object)r);
                lastBundling = Instant.now().toEpochMilli();
                if (!r.isSuccess()) {
                    bundleExceptionRef.set(r.bundleException());
                    RuntimeUpdatesProcessor.INSTANCE.setRemoteProblem((Throwable)r.bundleException());
                } else {
                    DevModeBundlingProcessor.resetRemoteProblem();
                    bundleExceptionRef.set(null);
                }
                if (!watchRef.get().isAlive()) {
                    this.shutdownDevService();
                }
                this.callNoRestartChangesConsumers(r.isSuccess());
                CountDownLatch countDownLatch = WAITER.get();
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
            }, (boolean)false);
            watchRef.set(watch);
            devService = new DevServicesResultBuildItem.RunningDevService(DEV_SERVICE_NAME, null, () -> ((Watch)watch).stop(), new HashMap());
            devServices.produce((BuildItem)devService.toBuildItem());
            if (!watch.firstBuildResult().isSuccess()) {
                throw watch.firstBuildResult().bundleException();
            }
            BundlesBuildContext newBundlesBuildContext = new BundlesBuildContext(readyForBundling.bundleOptions(), config, watch.dist());
            liveReload.setContextObject(BundlesBuildContext.class, (Object)newBundlesBuildContext);
            BundlingProcessor.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, watch.dist(), readyForBundling.started());
            BundlingProcessor.processGeneratedEntryPoints(config, readyForBundling.bundleOptions().workDir(), generatedEntryPointProducer);
        }
        catch (IOException e) {
            this.shutdownDevService();
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            this.shutdownDevService();
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
            throw e;
        }
    }

    private void callNoRestartChangesConsumers(boolean isSuccess) {
        try {
            Field field = RuntimeUpdatesProcessor.INSTANCE.getClass().getDeclaredField("noRestartChangesConsumers");
            field.setAccessible(true);
            List noRestartChangesConsumers = (List)field.get(RuntimeUpdatesProcessor.INSTANCE);
            for (Consumer consumer : noRestartChangesConsumers) {
                consumer.accept(Set.of(isSuccess ? "web-bundler/build-success" : "web-bundler/build-error"));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static void resetRemoteProblem() {
        if (RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() instanceof BundleException) {
            try {
                RuntimeUpdatesProcessor.INSTANCE.setRemoteProblem(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void shutdownDevService() {
        LOGGER.debug((Object)"Web Bundler: shutdownDevService");
        try {
            if (devService != null) {
                devService.close();
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Failed to stop Web Bundler bundling process", e);
        }
        finally {
            devService = null;
            watchRef.set(null);
            bundleExceptionRef.set(null);
        }
    }

    private void waitForBundling(ReadyForBundlingBuildItem readyForBundling) {
        BundleException bundleException;
        if (readyForBundling.started() != null) {
            if (lastBundling > readyForBundling.started()) {
                LOGGER.debug((Object)"Bundling done, no need to wait");
            } else {
                CountDownLatch latch = new CountDownLatch(1);
                CountDownLatch existingLatch = WAITER.getAndSet(latch);
                WAITER.set(latch);
                LOGGER.info((Object)"Bundling started...");
                try {
                    latch.await();
                    LOGGER.debug((Object)"Bundling completed!");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.shutdownDevService();
                    throw new RuntimeException(e);
                }
                finally {
                    if (existingLatch != null) {
                        existingLatch.countDown();
                    }
                }
            }
        }
        if ((bundleException = bundleExceptionRef.get()) != null) {
            this.shutdownDevService();
            throw bundleException;
        }
    }

    static {
        watchRef = new AtomicReference();
        bundleExceptionRef = new AtomicReference();
        WAITER = new AtomicReference();
        lastBundling = 0L;
    }

    record BundlesBuildContext(BundleOptions bundleOptions, WebBundlerConfig config, Path bundleDistDir) {
        public BundlesBuildContext() {
            this(null, null, null);
        }
    }
}

