/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.web;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.util.HashUtil;

public final class GeneratedWebResourceBuildItem
extends MultiBuildItem {
    private final String publicPath;
    private final byte[] content;
    private final String contentHash;
    private final SourceType type;

    public GeneratedWebResourceBuildItem(String publicPath, byte[] content, SourceType type) {
        this.publicPath = publicPath;
        this.content = content;
        this.contentHash = HashUtil.sha512((byte[])content);
        this.type = type;
    }

    public String resourceName() {
        return "META-INF/web/" + this.publicPath.replaceAll("^/", "");
    }

    public String publicPath() {
        return this.publicPath;
    }

    public byte[] content() {
        return this.content;
    }

    public String contentHash() {
        return this.contentHash;
    }

    public SourceType type() {
        return this.type;
    }

    public static enum SourceType {
        BUILD_TIME_TEMPLATE("build-time template", 1),
        STATIC_ASSET("static asset", 2),
        BUNDLED_ASSET("bundled asset", 3);

        private String label;
        private final int order;

        private SourceType(String label, int order) {
            this.label = label;
            this.order = order;
        }

        public String label() {
            return this.label;
        }

        public int order() {
            return this.order;
        }
    }
}

