/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.web;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourcesDevContext;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceHandler;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class GeneratedWebResourcesProcessor {
    private static final Logger LOGGER = Logger.getLogger(GeneratedWebResourcesProcessor.class);
    public static final String WEB_BUNDLER_LIVE_RELOAD_PATH = "/web-bundler/live";

    @BuildStep
    public void processStaticFiles(BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageProducer, List<GeneratedWebResourceBuildItem> staticResources, ReadyForBundlingBuildItem readyForBundling, BuildProducer<GeneratedResourceBuildItem> prodResourcesProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourcesProducer, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchModeBuildItem) {
        if (staticResources.isEmpty()) {
            return;
        }
        if (launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            Path distDir = readyForBundling.distDir();
            GeneratedWebResourcesDevContext generatedWebResourcesDevContext = (GeneratedWebResourcesDevContext)liveReload.getContextObject(GeneratedWebResourcesDevContext.class);
            HashMap<String, String> hashes = new HashMap<String, String>();
            if (liveReload.isLiveReload() && generatedWebResourcesDevContext != null) {
                HashMap<String, String> cachedHashes = new HashMap<String, String>(generatedWebResourcesDevContext.generatedResourcesHashes());
                for (GeneratedWebResourceBuildItem r : staticResources) {
                    String publicPath = r.publicPath();
                    String cached = (String)cachedHashes.get(publicPath);
                    if (cached == null) {
                        GeneratedWebResourcesProcessor.createGeneratedResourceOnDisk(r, distDir);
                    } else if (!cached.equals(r.contentHash())) {
                        GeneratedWebResourcesProcessor.createGeneratedResourceOnDisk(r, distDir);
                    }
                    cachedHashes.remove(r.publicPath());
                    hashes.put(r.publicPath(), r.contentHash());
                    notFoundPageProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(r.publicPath()));
                }
            } else {
                for (GeneratedWebResourceBuildItem r : staticResources) {
                    hashes.put(r.publicPath(), r.contentHash());
                    GeneratedWebResourcesProcessor.createGeneratedResourceOnDisk(r, distDir);
                    notFoundPageProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(r.publicPath()));
                }
            }
            liveReload.setContextObject(GeneratedWebResourcesDevContext.class, (Object)new GeneratedWebResourcesDevContext(hashes));
        }
        for (GeneratedWebResourceBuildItem staticResource : staticResources) {
            prodResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem(staticResource.resourceName(), staticResource.content(), false));
            nativeImageResourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{staticResource.resourceName()}));
        }
    }

    private static void createGeneratedResourceOnDisk(GeneratedWebResourceBuildItem r, Path buildDir) {
        Path targetPath = buildDir.resolve(PathUtils.removeLeadingSlash((String)r.publicPath()));
        try {
            Files.deleteIfExists(targetPath);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.write(targetPath, r.content(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(LaunchModeBuildItem launchMode, ReadyForBundlingBuildItem readyForBundling, List<GeneratedWebResourceBuildItem> staticResources, WebBundlerResourceRecorder recorder, BuildProducer<RouteBuildItem> routes) throws IOException {
        if (!staticResources.isEmpty()) {
            String webDir = launchMode.getLaunchMode().isDevOrTest() ? readyForBundling.distDir().toAbsolutePath().toString() : null;
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(WebBundlerResourceHandler.DEFAULT_ROUTE_ORDER)).handler(recorder.createHandler(webDir, staticResources.stream().map(GeneratedWebResourceBuildItem::publicPath).collect(Collectors.toSet()), launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT)).build());
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void initChangeEventHandler(WebBundlerConfig config, ReadyForBundlingBuildItem readyForBundling, WebBundlerResourceRecorder recorder, List<GeneratedWebResourceBuildItem> staticResources, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routes) {
        if (config.browserLiveReload()) {
            routes.produce((BuildItem)RouteBuildItem.builder().route(WEB_BUNDLER_LIVE_RELOAD_PATH).handler(recorder.createChangeEventHandler(readyForBundling.distDir().toAbsolutePath().toString(), staticResources.stream().map(GeneratedWebResourceBuildItem::publicPath).collect(Collectors.toSet()), (ShutdownContext)shutdownContext)).build());
        }
    }

    public static String resolveFromRootPath(HttpBuildTimeConfig httpConfig, String path) {
        return PathUtils.join((String)httpConfig.rootPath, (String)path);
    }
}

