/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleResult;
import io.quarkiverse.web.bundler.deployment.StaticWebAssetsProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.DefaultWebAsset;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedEntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.runtime.Bundle;
import io.quarkiverse.web.bundler.runtime.BundleRedirectHandlerRecorder;
import io.quarkiverse.web.bundler.runtime.WebBundlerBuildRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class BundlingProcessor {
    private static final Logger LOGGER = Logger.getLogger(BundlingProcessor.class);

    BundlingProcessor() {
    }

    @BuildStep(onlyIfNot={IsDevelopment.class})
    void bundle(WebBundlerConfig config, ReadyForBundlingBuildItem readyForBundling, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<GeneratedEntryPointBuildItem> generatedEntryPointProducer) {
        if (readyForBundling == null) {
            return;
        }
        try {
            long startedBundling = Instant.now().toEpochMilli();
            BundleResult result = Bundler.bundle((BundleOptions)readyForBundling.bundleOptions(), (boolean)false);
            if (!result.result().output().isBlank()) {
                LOGGER.debugf(result.result().output(), new Object[0]);
            }
            BundlingProcessor.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, result.dist(), startedBundling);
            BundlingProcessor.processGeneratedEntryPoints(config, readyForBundling.bundleOptions().workDir(), generatedEntryPointProducer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void processGeneratedEntryPoints(WebBundlerConfig config, Path targetDir, BuildProducer<GeneratedEntryPointBuildItem> generatedEntryPointProducer) {
        try (Stream<Path> generatedEPStream = Files.find(targetDir, 1, (path, basicFileAttributes) -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(".js"), new FileVisitOption[0]);){
            generatedEPStream.forEach(p -> {
                String key = p.getFileName().toString().replace(".js", "");
                DefaultWebAsset wa = new DefaultWebAsset(PathUtils.join((String)config.webRoot(), (String)p.getFileName().toString()), p, Charset.defaultCharset());
                generatedEntryPointProducer.produce((BuildItem)new GeneratedEntryPointBuildItem(key, new BundleWebAsset((WebAsset)wa, BundleWebAsset.BundleType.GENERATED_ENTRY_POINT)));
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void handleBundleDistDir(WebBundlerConfig config, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, Path bundleDir, Long started) {
        try {
            HashMap<String, String> bundle = new HashMap<String, String>();
            ArrayList names = new ArrayList();
            StringBuilder mappingString = new StringBuilder();
            try (Stream<Path> stream = Files.find(bundleDir, 20, (p, i) -> Files.isRegularFile(p, new LinkOption[0]), new FileVisitOption[0]);){
                stream.forEach(path -> {
                    String relativePath = bundleDir.relativize((Path)path).toString();
                    String key = relativePath.replaceAll("-[^-.]+\\.", ".");
                    String publicBundleAssetPath = PathUtils.join((String)config.publicBundlePath(), (String)relativePath);
                    String fileName = path.getFileName().toString();
                    String ext = fileName.substring(fileName.indexOf("."));
                    if (Bundle.BUNDLE_MAPPING_EXT.contains(ext)) {
                        mappingString.append("  ").append(key).append(" => ").append(publicBundleAssetPath).append("\n");
                        bundle.put(key, publicBundleAssetPath);
                    }
                    names.add(publicBundleAssetPath);
                    if (config.shouldQuarkusServeBundle()) {
                        String resourcePath = PathUtils.surroundWithSlashes((String)config.bundlePath()) + relativePath;
                        StaticWebAssetsProcessor.makePublic(staticResourceProducer, resourcePath, path.normalize(), GeneratedWebResourceBuildItem.SourceType.BUNDLED_ASSET);
                    }
                });
            }
            if (started != null) {
                LOGGER.infof("Bundle generated %d files in %sms", (Object)names.size(), (Object)Instant.now().minusMillis(started).toEpochMilli());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Bundle dir: '%s'\n  - %s", (Object)bundleDir, (Object)names.size(), (Object)String.join((CharSequence)"\n  - ", names));
                }
                if (LOGGER.isDebugEnabled() || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                    LOGGER.infof("Bundle#mapping:\n%s", (Object)mappingString);
                }
            }
            generatedBundleProducer.produce((BuildItem)new GeneratedBundleBuildItem(bundleDir, bundle));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initBundleBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, GeneratedBundleBuildItem generatedBundle, WebBundlerBuildRecorder recorder) {
        Map<Object, Object> bundle = generatedBundle != null ? generatedBundle.getBundle() : Map.of();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(Bundle.Mapping.class).supplier(recorder.createContext(bundle)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{Bundle.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initBundleRedirect(WebBundlerConfig config, BuildProducer<RouteBuildItem> routes, BundleRedirectHandlerRecorder recorder, GeneratedBundleBuildItem generatedBundle) {
        if (config.bundleRedirect().booleanValue() && generatedBundle != null) {
            routes.produce((BuildItem)RouteBuildItem.builder().route(PathUtils.join((String)PathUtils.prefixWithSlash((String)config.bundlePath()), (String)"*")).handler(recorder.handler(generatedBundle.getBundle())).build());
        }
    }
}

