/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ProjectResourcesScannerBuildItem;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class StaticWebAssetsProcessor {
    @BuildStep
    void processStaticWebAssets(WebBundlerConfig config, StaticAssetsBuildItem staticAssets, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer) {
        for (WebAsset webAsset : staticAssets.getWebAssets()) {
            String publicPath = webAsset.pathFromWebRoot(config.webRoot());
            StaticWebAssetsProcessor.makeWebAssetPublic(staticResourceProducer, PathUtils.prefixWithSlash((String)publicPath), webAsset, GeneratedWebResourceBuildItem.SourceType.STATIC_ASSET);
        }
    }

    static void makeWebAssetPublic(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, WebAsset webAsset, GeneratedWebResourceBuildItem.SourceType sourceType) {
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, publicPath, webAsset.contentOrReadFromFile(), sourceType);
    }

    static void makePublic(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, Path file, GeneratedWebResourceBuildItem.SourceType sourceType) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, publicPath, ProjectResourcesScannerBuildItem.readTemplateContent((Path)file), sourceType);
    }

    private static void handleStaticResource(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, byte[] content, GeneratedWebResourceBuildItem.SourceType sourceType) {
        staticResourceProducer.produce((BuildItem)new GeneratedWebResourceBuildItem(publicPath, content, sourceType));
    }
}

