/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.devui;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.devui.DevUIWebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedEntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourcesProcessor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WebBundlerDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void createPages(WebBundlerConfig config, HttpBuildTimeConfig httpConfig, BuildProducer<CardPageBuildItem> cardPageProducer, List<EntryPointBuildItem> entryPoints, List<GeneratedEntryPointBuildItem> generatedEntryPoints, WebDependenciesBuildItem webDependencies, List<GeneratedWebResourceBuildItem> generatedWebResources, DevUIWebDependenciesBuildItem devUIWebDependencies) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        if (!webDependencies.isEmpty()) {
            cardPageBuildItem.addBuildTimeData("webDependencies", devUIWebDependencies.getWebDependencies());
            cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-web-bundler-web-dependencies.js").title("Web Dependencies")).icon("font-awesome-brands:square-js")).staticLabel(String.valueOf(webDependencies.list().size())));
        }
        Map<String, EntryPointItem> generatedEntryPointsMap = generatedEntryPoints.stream().collect(Collectors.toMap(GeneratedEntryPointBuildItem::key, e -> new EntryPointItem(e.webAsset().pathFromWebRoot(config.webRoot()), e.webAsset().type().label(), new String(e.webAsset().contentOrReadFromFile())), (a, b) -> b));
        if (!entryPoints.isEmpty()) {
            List<EntryPoint> entryPointsForDevUI = entryPoints.stream().map(e -> new EntryPoint(e.getEntryPointKey(), WebBundlerDevUIProcessor.getEntryPointItems(config, generatedEntryPointsMap, e))).toList();
            cardPageBuildItem.addBuildTimeData("entryPoints", entryPointsForDevUI);
            cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-web-bundler-entry-points.js").title("Entry Points")).icon("font-awesome-solid:folder-tree")).staticLabel(String.valueOf(entryPointsForDevUI.size())));
        }
        if (!generatedWebResources.isEmpty()) {
            List<WebAsset> assets = generatedWebResources.stream().sorted(Comparator.comparing(w -> w.type().order())).map(w -> new WebAsset(GeneratedWebResourcesProcessor.resolveFromRootPath(httpConfig, w.publicPath()), w.type().label(), new String(w.content()))).toList();
            cardPageBuildItem.addBuildTimeData("staticAssets", assets);
            cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-web-bundler-output.js").title("Static Output")).icon("font-awesome-solid:arrow-right-from-bracket")).staticLabel(String.valueOf(assets.size())));
        }
        cardPageProducer.produce((BuildItem)cardPageBuildItem);
    }

    private static List<EntryPointItem> getEntryPointItems(WebBundlerConfig config, Map<String, EntryPointItem> generatedEntryPoints, EntryPointBuildItem e) {
        ArrayList<EntryPointItem> list = new ArrayList<EntryPointItem>();
        if (generatedEntryPoints.containsKey(e.getEntryPointKey())) {
            list.add(generatedEntryPoints.get(e.getEntryPointKey()));
        }
        list.addAll(e.getWebAssets().stream().map(a -> new EntryPointItem(a.webAsset().pathFromWebRoot(config.webRoot()), a.type().label(), new String(a.webAsset().contentOrReadFromFile()))).toList());
        return list;
    }

    record EntryPointItem(String path, String type, String content) {
    }

    record WebAsset(String path, String type, String content) {
    }

    record EntryPoint(String key, List<EntryPointItem> items) {
    }
}

