/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.quarkiverse.web.bundler.deployment.PrepareForBundlingProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.StaticAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.items.WebBundlerTargetDirBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class StaticWebAssetsProcessor {
    @BuildStep
    void processStaticWebAssets(WebBundlerConfig config, WebBundlerTargetDirBuildItem targetDir, StaticAssetsBuildItem staticAssets, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFileBuildItemProducer, LaunchModeBuildItem launchMode, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer) {
        boolean browserLiveReload = launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) && config.browserLiveReload();
        for (WebAsset webAsset : staticAssets.getWebAssets()) {
            String publicPath = webAsset.pathFromWebRoot(config.webRoot());
            Path targetPath = targetDir.dist().resolve(publicPath);
            try {
                if (!webAsset.isFile()) {
                    StaticWebAssetsProcessor.makeWebAssetPublic(staticResourceProducer, PathUtils.prefixWithSlash((String)publicPath), webAsset, GeneratedWebResourceBuildItem.SourceType.STATIC_ASSET);
                    continue;
                }
                if (browserLiveReload) {
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    PrepareForBundlingProcessor.createSymbolicLinkOrFallback(watchedFileBuildItemProducer, webAsset, targetPath);
                    StaticWebAssetsProcessor.makePublic(staticResourceProducer, PathUtils.prefixWithSlash((String)publicPath), targetPath, GeneratedWebResourceBuildItem.SourceType.STATIC_ASSET);
                    continue;
                }
                StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, PathUtils.prefixWithSlash((String)publicPath), new WebAsset.Resource(webAsset.resource().contentOrReadFromFile()), GeneratedWebResourceBuildItem.SourceType.STATIC_ASSET);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static void makeWebAssetPublic(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, WebAsset webAsset, GeneratedWebResourceBuildItem.SourceType sourceType) {
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, publicPath, webAsset.resource(), sourceType);
    }

    static void makePublic(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, Path path, GeneratedWebResourceBuildItem.SourceType sourceType) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        StaticWebAssetsProcessor.handleStaticResource(staticResourceProducer, publicPath, new WebAsset.Resource(path), sourceType);
    }

    private static void handleStaticResource(BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, String publicPath, WebAsset.Resource resource, GeneratedWebResourceBuildItem.SourceType sourceType) {
        staticResourceProducer.produce((BuildItem)new GeneratedWebResourceBuildItem(publicPath, resource, sourceType));
    }
}

