/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.install.WebDepsInstaller;
import io.mvnpm.esbuild.model.WebDependency;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.InstalledWebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;

class WebDependenciesProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebDependenciesProcessor.class);

    WebDependenciesProcessor() {
    }

    @BuildStep
    WebDependenciesBuildItem collectDependencies(LaunchModeBuildItem launchMode, CurateOutcomeBuildItem curateOutcome, List<EntryPointBuildItem> entryPoints, WebBundlerConfig config) {
        if (entryPoints.isEmpty() && !config.dependencies().autoImport().isEnabled()) {
            return new WebDependenciesBuildItem(List.of());
        }
        List<WebDependenciesBuildItem.Dependency> dependencies = StreamSupport.stream(curateOutcome.getApplicationModel().getDependenciesWithAnyFlag(new int[]{4096, 4}).spliterator(), false).filter(ArtifactCoords::isJar).filter(d -> WebDependency.WebDependencyType.anyMatch((String)d.toCompactCoords())).peek(d -> this.checkScope(launchMode, (ResolvedDependency)d, config)).map(WebDependenciesProcessor::toWebDep).filter(Objects::nonNull).collect(Collectors.toList());
        return new WebDependenciesBuildItem(dependencies);
    }

    @BuildStep
    InstalledWebDependenciesBuildItem installDependencies(LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, OutputTargetBuildItem outputTarget, WebDependenciesBuildItem webDependencies, WebBundlerConfig config) {
        InstalledWebDependenciesContext installedWebDependenciesContext = (InstalledWebDependenciesContext)liveReload.getContextObject(InstalledWebDependenciesContext.class);
        Path nodeModulesDir = WebDependenciesProcessor.resolveNodeModulesDir(config, outputTarget);
        if (liveReload.isLiveReload() && installedWebDependenciesContext != null && WebBundlerConfig.WebDependenciesConfig.isEqual((WebBundlerConfig.WebDependenciesConfig)config.dependencies(), (WebBundlerConfig.WebDependenciesConfig)installedWebDependenciesContext.config().dependencies()) && nodeModulesDir.equals(installedWebDependenciesContext.nodeModulesDir()) && installedWebDependenciesContext.dependencies().equals(webDependencies.list())) {
            return new InstalledWebDependenciesBuildItem(nodeModulesDir, webDependencies.list());
        }
        long startedInstall = Instant.now().toEpochMilli();
        try {
            List<WebDependency> toInstall = webDependencies.toEsBuildWebDependencies();
            if (WebDepsInstaller.install((Path)nodeModulesDir, toInstall)) {
                long duration = Instant.now().minusMillis(startedInstall).toEpochMilli();
                if (LOGGER.isDebugEnabled()) {
                    String deps = webDependencies.list().stream().map(WebDependenciesBuildItem.Dependency::id).collect(Collectors.joining(", "));
                    LOGGER.infof("%d web dependencies installed in %sms: %s", (Object)webDependencies.list().size(), (Object)duration, (Object)deps);
                } else {
                    LOGGER.infof("%d web Dependencies installed in %sms.", (Object)webDependencies.list().size(), (Object)duration);
                }
            } else if (webDependencies.isEmpty()) {
                LOGGER.info((Object)"No web dependencies to install.");
            } else {
                LOGGER.info((Object)"All web dependencies are already installed.");
            }
            liveReload.setContextObject(InstalledWebDependenciesContext.class, (Object)new InstalledWebDependenciesContext(config, nodeModulesDir, webDependencies.list()));
            return new InstalledWebDependenciesBuildItem(nodeModulesDir, webDependencies.list());
        }
        catch (IOException e) {
            liveReload.setContextObject(InstalledWebDependenciesContext.class, (Object)new InstalledWebDependenciesContext());
            throw new RuntimeException(e);
        }
    }

    private void checkScope(LaunchModeBuildItem launchMode, ResolvedDependency d, WebBundlerConfig config) {
        if (!launchMode.getLaunchMode().isDevOrTest() && config.dependencies().compileOnly() && d.isRuntimeCp()) {
            throw new ConfigurationException("The Web Bundler is configured to only include compileOnly web dependencies, but %s is set as runtime. Use a compile only scope (e.g. provided) or set quarkus.web-bundler.dependencies.compile-only=false to allow runtime web dependencies.".formatted(d.toCompactCoords()));
        }
    }

    private static WebDependenciesBuildItem.Dependency toWebDep(ResolvedDependency d) {
        return d.getResolvedPaths().stream().filter(p -> p.getFileName().toString().endsWith(".jar")).findFirst().map(j -> new WebDependenciesBuildItem.Dependency(d, d.toCompactCoords(), (Path)j, (WebDependency.WebDependencyType)WebDependency.WebDependencyType.resolveType((String)d.toCompactCoords()).orElseThrow(), d.isDirect())).orElse(null);
    }

    private static Path resolveNodeModulesDir(WebBundlerConfig config, OutputTargetBuildItem outputTarget) {
        if (config.dependencies().nodeModules().isEmpty()) {
            return outputTarget.getOutputDirectory().resolve("node_modules");
        }
        Path projectRoot = WebDependenciesProcessor.findProjectRoot(outputTarget.getOutputDirectory());
        Path nodeModulesDir = Path.of(((String)config.dependencies().nodeModules().get()).trim(), new String[0]);
        if (nodeModulesDir.isAbsolute() && Files.isDirectory(nodeModulesDir.getParent(), new LinkOption[0])) {
            return nodeModulesDir;
        }
        if (projectRoot == null || !Files.isDirectory(projectRoot, new LinkOption[0])) {
            throw new IllegalStateException("If not absolute, the node_modules directory is resolved relative to the project root, but Web Bundler was not able to find the project root.");
        }
        return projectRoot.resolve(nodeModulesDir);
    }

    static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    record InstalledWebDependenciesContext(WebBundlerConfig config, Path nodeModulesDir, List<WebDependenciesBuildItem.Dependency> dependencies) {
        InstalledWebDependenciesContext() {
            this(null, null, List.of());
        }
    }
}

