/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.model.AutoEntryPoint;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleOptionsBuilder;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.EsBuildConfigBuilder;
import io.quarkiverse.web.bundler.deployment.BundleWebAssetsScannerProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.BundleConfigAssetsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.BundleWebAsset;
import io.quarkiverse.web.bundler.deployment.items.EntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.InstalledWebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.deployment.items.WebBundlerTargetDirBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class PrepareForBundlingProcessor {
    private static final Logger LOGGER = Logger.getLogger(PrepareForBundlingProcessor.class);
    private static final Map<EsBuildConfig.Loader, Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>>> LOADER_CONFIGS = Map.ofEntries(Map.entry(EsBuildConfig.Loader.JS, WebBundlerConfig.LoadersConfig::js), Map.entry(EsBuildConfig.Loader.JSX, WebBundlerConfig.LoadersConfig::jsx), Map.entry(EsBuildConfig.Loader.TS, WebBundlerConfig.LoadersConfig::ts), Map.entry(EsBuildConfig.Loader.TSX, WebBundlerConfig.LoadersConfig::tsx), Map.entry(EsBuildConfig.Loader.CSS, WebBundlerConfig.LoadersConfig::css), Map.entry(EsBuildConfig.Loader.LOCAL_CSS, WebBundlerConfig.LoadersConfig::localCss), Map.entry(EsBuildConfig.Loader.GLOBAL_CSS, WebBundlerConfig.LoadersConfig::globalCss), Map.entry(EsBuildConfig.Loader.JSON, WebBundlerConfig.LoadersConfig::json), Map.entry(EsBuildConfig.Loader.TEXT, WebBundlerConfig.LoadersConfig::text), Map.entry(EsBuildConfig.Loader.FILE, WebBundlerConfig.LoadersConfig::file), Map.entry(EsBuildConfig.Loader.EMPTY, WebBundlerConfig.LoadersConfig::empty), Map.entry(EsBuildConfig.Loader.COPY, WebBundlerConfig.LoadersConfig::copy), Map.entry(EsBuildConfig.Loader.DATAURL, WebBundlerConfig.LoadersConfig::dataUrl), Map.entry(EsBuildConfig.Loader.BASE64, WebBundlerConfig.LoadersConfig::base64), Map.entry(EsBuildConfig.Loader.BINARY, WebBundlerConfig.LoadersConfig::binary));
    public static final String TARGET_DIR_NAME = "web-bundler/";
    public static final String DIST = "dist";
    private static final String LAUNCH_MODE_ENV = "LAUNCH_MODE";

    @BuildStep
    WebBundlerTargetDirBuildItem initTargetDir(OutputTargetBuildItem outputTarget, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload) {
        String targetDirName = TARGET_DIR_NAME + launchMode.getLaunchMode().getDefaultProfile();
        Path targetDir = outputTarget.getOutputDirectory().resolve(targetDirName);
        Path distDir = targetDir.resolve(DIST);
        if (!liveReload.isLiveReload()) {
            try {
                FileUtil.deleteDirectory((Path)targetDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new WebBundlerTargetDirBuildItem(targetDir, distDir);
    }

    @BuildStep
    ReadyForBundlingBuildItem prepareForBundling(WebBundlerConfig config, InstalledWebDependenciesBuildItem installedWebDependencies, List<EntryPointBuildItem> entryPoints, WebBundlerTargetDirBuildItem targetDir, Optional<BundleConfigAssetsBuildItem> bundleConfig, LiveReloadBuildItem liveReload, LaunchModeBuildItem launchMode, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, HttpBuildTimeConfig httpBuildTimeConfig, OutputTargetBuildItem outputTarget) {
        boolean shouldWatch;
        if (entryPoints.isEmpty()) {
            if (!config.dependencies().autoImport().isEnabled()) {
                LOGGER.warn((Object)"Skipping Web-Bundling because no entry-point detected (create one or enable auto-import)");
                return null;
            }
            if (installedWebDependencies.isEmpty()) {
                LOGGER.warn((Object)"Skipping Web-Bundling because no Web Dependencies found for auto-import.");
                return null;
            }
            LOGGER.info((Object)"No entry points found, it will be generated based on direct Web Dependencies.");
        }
        PrepareForBundlingContext prepareForBundlingContext = (PrepareForBundlingContext)liveReload.getContextObject(PrepareForBundlingContext.class);
        boolean isLiveReload = liveReload.isLiveReload() && prepareForBundlingContext != null;
        long started = Instant.now().toEpochMilli();
        boolean bl = shouldWatch = config.browserLiveReload() && BundleWebAssetsScannerProcessor.enableBundlingWatch.get();
        if (isLiveReload && WebBundlerConfig.isEqual((WebBundlerConfig)config, (WebBundlerConfig)prepareForBundlingContext.config()) && Objects.equals(installedWebDependencies.list(), prepareForBundlingContext.dependencies()) && !liveReload.getChangedResources().contains(config.fromWebRoot("tsconfig.json")) && entryPoints.equals(prepareForBundlingContext.entryPoints())) {
            if (entryPoints.stream().map(EntryPointBuildItem::getWebAssets).flatMap(Collection::stream).map(WebAsset::resourceName).noneMatch(liveReload.getChangedResources()::contains)) {
                if (shouldWatch) {
                    for (EntryPointBuildItem entryPoint : entryPoints) {
                        for (BundleWebAsset webAsset : entryPoint.getWebAssets()) {
                            if (!webAsset.isFile() || !webAsset.srcFilePath().isPresent()) continue;
                            watchedFiles.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setRestartNeeded(false).setLocation(webAsset.resourceName()).build());
                        }
                    }
                }
                return new ReadyForBundlingBuildItem(prepareForBundlingContext.bundleOptions(), null, targetDir.dist(), shouldWatch);
            }
        }
        try {
            boolean browserLiveReload;
            Files.createDirectories(targetDir.webBundler(), new FileAttribute[0]);
            LOGGER.debugf("Preparing bundle in %s", (Object)targetDir);
            boolean bl2 = browserLiveReload = launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) && config.browserLiveReload();
            if (bundleConfig.isPresent()) {
                for (WebAsset webAsset : bundleConfig.get().getWebAssets()) {
                    Path targetConfig = targetDir.webBundler().resolve(webAsset.pathFromWebRoot(config.webRoot()));
                    PrepareForBundlingProcessor.createAsset(watchedFiles, webAsset, targetConfig, browserLiveReload);
                }
            }
            Map<String, EsBuildConfig.Loader> loaders = this.computeLoaders(config);
            EsBuildConfigBuilder esBuildConfigBuilder = EsBuildConfig.builder().loader(loaders).outDir(PathUtils.join((String)DIST, (String)config.bundlePath())).publicPath(config.publicBundlePath()).splitting(config.bundling().splitting().booleanValue()).sourceMap(config.bundling().sourceMapEnabled()).define(LAUNCH_MODE_ENV, "'" + launchMode.getLaunchMode().name() + "'");
            if (browserLiveReload) {
                esBuildConfigBuilder.preserveSymlinks().minify(false).define("process.env.LIVE_RELOAD_PATH", "'" + PathUtils.join((String)httpBuildTimeConfig.rootPath, (String)"/web-bundler/live") + "'").fixedEntryNames();
            }
            if (!config.bundling().envs().isEmpty()) {
                esBuildConfigBuilder.define(config.bundling().safeEnvs());
            }
            if (config.bundling().external().isPresent()) {
                for (String e : (List)config.bundling().external().get()) {
                    esBuildConfigBuilder.addExternal(e);
                }
            } else {
                esBuildConfigBuilder.addExternal(PathUtils.join((String)config.httpRootPath(), (String)"static/*"));
            }
            BundleOptionsBuilder optionsBuilder = BundleOptions.builder().withWorkDir(targetDir.webBundler()).withDependencies(installedWebDependencies.toEsBuildWebDependencies()).withEsConfig(esBuildConfigBuilder.build()).withNodeModulesDir(installedWebDependencies.nodeModulesDir());
            Set directWebDependenciesIds = installedWebDependencies.list().stream().filter(WebDependenciesBuildItem.Dependency::direct).map(WebDependenciesBuildItem.Dependency::id).collect(Collectors.toSet());
            int addedEntryPoints = 0;
            AutoEntryPoint.AutoDepsMode autoDepsMode = AutoEntryPoint.AutoDepsMode.valueOf((String)config.dependencies().autoImport().mode().toString());
            for (EntryPointBuildItem entryPoint : entryPoints) {
                ArrayList<String> scripts = new ArrayList<String>();
                for (BundleWebAsset webAsset : entryPoint.getWebAssets()) {
                    String destination = webAsset.pathFromWebRoot(config.webRoot());
                    Path scriptPath = targetDir.webBundler().resolve(destination);
                    if (!isLiveReload || liveReload.getChangedResources().contains(webAsset.resourceName()) || !Files.exists(scriptPath, new LinkOption[0])) {
                        PrepareForBundlingProcessor.createAsset(watchedFiles, (WebAsset)webAsset, scriptPath, browserLiveReload);
                    }
                    if (webAsset.type().equals((Object)BundleWebAsset.BundleType.MANUAL)) continue;
                    scripts.add(destination);
                }
                String scriptsLog = scripts.stream().map(s -> String.format("  - %s", s)).collect(Collectors.joining("\n"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Bundling '%s' (%d files):\n%s", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size(), (Object)scriptsLog);
                } else {
                    LOGGER.infof("Bundling '%s' (%d files)", (Object)entryPoint.getEntryPointKey(), (Object)scripts.size());
                }
                if (scripts.isEmpty()) continue;
                if (browserLiveReload) {
                    Files.write(targetDir.webBundler().resolve("live-reload.js"), this.readLiveReloadJs(), new OpenOption[0]);
                    scripts.add("live-reload.js");
                }
                optionsBuilder.addAutoEntryPoint(targetDir.webBundler(), entryPoint.getEntryPointKey(), scripts, autoDepsMode, directWebDependenciesIds::contains);
                ++addedEntryPoints;
            }
            if (addedEntryPoints == 0) {
                ArrayList<String> scripts = new ArrayList<String>();
                if (browserLiveReload) {
                    Files.write(targetDir.webBundler().resolve("live-reload.js"), this.readLiveReloadJs(), new OpenOption[0]);
                    scripts.add("live-reload.js");
                }
                optionsBuilder.addAutoEntryPoint(targetDir.webBundler(), "main", scripts, autoDepsMode, directWebDependenciesIds::contains);
                LOGGER.info((Object)"No custom entry points found, it will be generated based on web dependencies.");
            }
            BundleOptions options = optionsBuilder.build();
            liveReload.setContextObject(PrepareForBundlingContext.class, (Object)new PrepareForBundlingContext(config, installedWebDependencies.list(), entryPoints, options));
            return new ReadyForBundlingBuildItem(options, started, targetDir.dist(), shouldWatch);
        }
        catch (IOException e) {
            liveReload.setContextObject(PrepareForBundlingContext.class, (Object)new PrepareForBundlingContext());
            throw new UncheckedIOException(e);
        }
    }

    static void createAsset(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, WebAsset webAsset, Path targetPath, boolean browserLiveReload) throws IOException {
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        if (!webAsset.isFile()) {
            Files.write(targetPath, webAsset.resource().content(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        } else if (browserLiveReload && BundleWebAssetsScannerProcessor.enableBundlingWatch.get()) {
            PrepareForBundlingProcessor.createSymbolicLinkOrFallback(watchedFiles, webAsset, targetPath);
        } else {
            Files.copy(webAsset.resource().path(), targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    static void createSymbolicLinkOrFallback(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, WebAsset webAsset, Path targetPath) throws IOException {
        Files.deleteIfExists(targetPath);
        boolean srcDetected = webAsset.srcFilePath().isPresent();
        if (srcDetected) {
            try {
                Files.createSymbolicLink(targetPath, (Path)webAsset.srcFilePath().get(), new FileAttribute[0]);
                watchedFiles.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setRestartNeeded(false).setLocation(webAsset.resourceName()).build());
            }
            catch (FileSystemException e) {
                if (BundleWebAssetsScannerProcessor.enableBundlingWatch.getAndSet(false)) {
                    LOGGER.warn((Object)"Creating a symbolic link was not authorized on this system. It is required by the Web Bundler to allow filesystem watch. As a result, Web Bundler live-reload will use a scheduler as a fallback.\n\nTo resolve this issue, please add the necessary permissions to allow symbolic link creation.");
                }
                Files.copy(webAsset.resource().path(), targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            if (BundleWebAssetsScannerProcessor.enableBundlingWatch.getAndSet(false)) {
                LOGGER.warn((Object)"The sources are necessary by the Web Bundler to allow filesystem watch. Web Bundler live-reload will use a scheduler as a fallback");
            }
            Files.copy(webAsset.resource().path(), targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private byte[] readLiveReloadJs() throws IOException {
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("web-bundler/live-reload.js");){
            Objects.requireNonNull(resourceAsStream, "resource web-bundler/live-reload.js is required");
            byte[] byArray = resourceAsStream.readAllBytes();
            return byArray;
        }
    }

    private Map<String, EsBuildConfig.Loader> computeLoaders(WebBundlerConfig config) {
        HashMap<String, EsBuildConfig.Loader> loaders = new HashMap<String, EsBuildConfig.Loader>();
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            Function<WebBundlerConfig.LoadersConfig, Optional<Set<String>>> configFn = Objects.requireNonNull(LOADER_CONFIGS.get(loader));
            Optional<Set<String>> values = configFn.apply(config.bundling().loaders());
            if (!values.isPresent()) continue;
            for (String v : values.get()) {
                Object ext;
                Object object = ext = v.startsWith(".") ? v : "." + v;
                if (loaders.containsKey(ext)) {
                    throw new ConfigurationException("A Web Bundler file extension for loaders is provided more than once: " + (String)ext);
                }
                loaders.put((String)ext, loader);
            }
        }
        return loaders;
    }

    static {
        for (EsBuildConfig.Loader loader : EsBuildConfig.Loader.values()) {
            if (LOADER_CONFIGS.containsKey(loader)) continue;
            throw new Error("There is no WebBundleConfig.LoadersConfig for this loader : " + loader);
        }
    }

    record PrepareForBundlingContext(WebBundlerConfig config, List<WebDependenciesBuildItem.Dependency> dependencies, List<EntryPointBuildItem> entryPoints, BundleOptions bundleOptions) {
        public PrepareForBundlingContext() {
            this(null, null, null, null);
        }
    }
}

