/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment;

import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.Watch;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleResult;
import io.quarkiverse.web.bundler.deployment.BundlingProcessor;
import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.GeneratedBundleBuildItem;
import io.quarkiverse.web.bundler.deployment.items.GeneratedEntryPointBuildItem;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class DevModeBundlingProcessor {
    private static final Logger LOGGER = Logger.getLogger(DevModeBundlingProcessor.class);
    private static final String DEV_SERVICE_NAME = "web-bundler-dev";
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static final AtomicReference<Watch> watchRef;
    private static final AtomicReference<BundleException> bundleExceptionRef;

    @BuildStep(onlyIf={IsDevelopment.class})
    void watch(WebBundlerConfig config, ReadyForBundlingBuildItem readyForBundling, BuildProducer<GeneratedWebResourceBuildItem> staticResourceProducer, BuildProducer<GeneratedBundleBuildItem> generatedBundleProducer, BuildProducer<DevServicesResultBuildItem> devServices, BuildProducer<GeneratedEntryPointBuildItem> generatedEntryPointProducer, LiveReloadBuildItem liveReload, CuratedApplicationShutdownBuildItem shutdown) {
        if (readyForBundling == null) {
            return;
        }
        BundlesBuildContext bundlesBuildContext = (BundlesBuildContext)liveReload.getContextObject(BundlesBuildContext.class);
        boolean isLiveReload = liveReload.isLiveReload();
        Watch watch = watchRef.get();
        if (readyForBundling.started() == null) {
            boolean isRestartWatchNeeded;
            boolean bl = isRestartWatchNeeded = readyForBundling.enabledBundlingWatch() && (watch == null || !watch.isAlive());
            if (!isRestartWatchNeeded) {
                if (watch != null && watch.isAlive()) {
                    devServices.produce((BuildItem)devService.toBuildItem());
                }
                BundlesBuildContext newBundlesBuildContext = new BundlesBuildContext(readyForBundling.bundleOptions(), bundlesBuildContext.bundleDistDir());
                liveReload.setContextObject(BundlesBuildContext.class, (Object)newBundlesBuildContext);
                BundlingProcessor.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, bundlesBuildContext.bundleDistDir(), readyForBundling.started());
                BundlingProcessor.processGeneratedEntryPoints(config, readyForBundling.bundleOptions().workDir(), generatedEntryPointProducer);
                return;
            }
        }
        if (watch != null) {
            this.shutdownDevService();
        }
        if (!readyForBundling.enabledBundlingWatch()) {
            BundleResult bundleResult = BundlingProcessor.bundleAndProcess(config, readyForBundling, staticResourceProducer, generatedBundleProducer, generatedEntryPointProducer);
            BundlesBuildContext newBundlesBuildContext = new BundlesBuildContext(readyForBundling.bundleOptions(), bundleResult.dist());
            liveReload.setContextObject(BundlesBuildContext.class, (Object)newBundlesBuildContext);
            return;
        }
        if (!isLiveReload) {
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownDevService();
                }
            };
            shutdown.addCloseTask(closeTask, true);
        }
        try {
            watch = Bundler.watch((BundleOptions)readyForBundling.bundleOptions(), r -> {
                if (watchRef.get() == null) {
                    LOGGER.error((Object)"Received a bundling event without a watchRef");
                    return;
                }
                LOGGER.debugf("New bundling event received: %s", (Object)r);
                if (!r.isSuccess()) {
                    bundleExceptionRef.set(r.bundleException());
                    if (RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() != null) {
                        RuntimeUpdatesProcessor.INSTANCE.setRemoteProblem((Throwable)r.bundleException());
                    }
                } else {
                    DevModeBundlingProcessor.resetRemoteProblem();
                    bundleExceptionRef.set(null);
                }
                if (!watchRef.get().isAlive()) {
                    this.shutdownDevService();
                }
                this.callNoRestartChangesConsumers(r.isSuccess());
            }, (boolean)false);
            watchRef.set(watch);
            devService = new DevServicesResultBuildItem.RunningDevService(DEV_SERVICE_NAME, null, () -> ((Watch)watch).close(), new HashMap());
            devServices.produce((BuildItem)devService.toBuildItem());
            if (!watch.firstBuildResult().isSuccess()) {
                throw watch.firstBuildResult().bundleException();
            }
            BundlesBuildContext newBundlesBuildContext = new BundlesBuildContext(readyForBundling.bundleOptions(), watch.dist());
            liveReload.setContextObject(BundlesBuildContext.class, (Object)newBundlesBuildContext);
            BundlingProcessor.handleBundleDistDir(config, generatedBundleProducer, staticResourceProducer, watch.dist(), readyForBundling.started());
            BundlingProcessor.processGeneratedEntryPoints(config, readyForBundling.bundleOptions().workDir(), generatedEntryPointProducer);
        }
        catch (IOException e) {
            this.shutdownDevService();
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            this.shutdownDevService();
            liveReload.setContextObject(BundlesBuildContext.class, (Object)new BundlesBuildContext());
            throw e;
        }
    }

    private void callNoRestartChangesConsumers(boolean isSuccess) {
        RuntimeUpdatesProcessor.INSTANCE.notifyExtensions(Set.of(isSuccess ? "web-bundler/build-success" : "web-bundler/build-error"));
    }

    private static void resetRemoteProblem() {
        if (RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() instanceof BundleException) {
            RuntimeUpdatesProcessor.INSTANCE.setRemoteProblem(null);
        }
    }

    private void shutdownDevService() {
        LOGGER.debug((Object)"Web Bundler: shutdownDevService");
        try {
            if (devService != null) {
                devService.close();
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Failed to stop Web Bundler bundling process", e);
        }
        finally {
            devService = null;
            watchRef.set(null);
            bundleExceptionRef.set(null);
        }
    }

    static {
        watchRef = new AtomicReference();
        bundleExceptionRef = new AtomicReference();
    }

    record BundlesBuildContext(BundleOptions bundleOptions, Path bundleDistDir) {
        public BundlesBuildContext() {
            this(null, null);
        }
    }
}

