/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.devui;

import io.mvnpm.esbuild.model.WebDependency;
import io.quarkiverse.web.bundler.deployment.devui.DevUIWebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebDependenciesBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourcesProcessor;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class WebBundlerDevUIWebDependenciesProcessor {
    private static final String PREFIX = "META-INF/resources/";
    private static final String WEBJARS_PATH = "webjars";
    private static final String MVNPM_PATH = "_static";
    private static final Logger log = Logger.getLogger((String)WebBundlerDevUIWebDependenciesProcessor.class.getName());

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevUIWebDependenciesBuildItem findWebDependenciesAssets(HttpRootPathBuildItem httpRootPath, LiveReloadBuildItem liveReload, WebDependenciesBuildItem webDependencies) {
        DevUIWebDependenciesContext webDependenciesContext = (DevUIWebDependenciesContext)liveReload.getContextObject(DevUIWebDependenciesContext.class);
        if (liveReload.isLiveReload() && webDependenciesContext != null && webDependenciesContext.dependencies().equals(webDependencies.list())) {
            return new DevUIWebDependenciesBuildItem(webDependenciesContext.devUIWebDependencies());
        }
        ArrayList providers = new ArrayList();
        providers.addAll(QuarkusClassLoader.getElements((String)"META-INF/resources/_static", (boolean)false));
        providers.addAll(QuarkusClassLoader.getElements((String)"META-INF/resources/webjars", (boolean)false));
        if (!providers.isEmpty()) {
            Map providersByKeys = providers.stream().filter(provider -> provider.getDependencyKey() != null).collect(Collectors.toMap(ClassPathElement::getDependencyKey, provider -> provider, (a, b) -> b, () -> new HashMap(providers.size())));
            ArrayList<DevUIWebDependenciesBuildItem.DevUIWebDependency> webJarDeps = new ArrayList<DevUIWebDependenciesBuildItem.DevUIWebDependency>(webDependencies.list().size());
            for (WebDependenciesBuildItem.Dependency dependency : webDependencies.list()) {
                DevUIWebDependenciesBuildItem.DevUIWebDependency dep = this.getDep(httpRootPath.getRootPath(), providersByKeys, dependency);
                if (dep == null) continue;
                webJarDeps.add(dep);
            }
            liveReload.setContextObject(DevUIWebDependenciesContext.class, (Object)new DevUIWebDependenciesContext(webDependencies.list(), webJarDeps));
            return new DevUIWebDependenciesBuildItem(webJarDeps);
        }
        liveReload.setContextObject(DevUIWebDependenciesContext.class, (Object)new DevUIWebDependenciesContext());
        return new DevUIWebDependenciesBuildItem(List.of());
    }

    private DevUIWebDependenciesBuildItem.DevUIWebDependency getDep(String rootPath, Map<ArtifactKey, ClassPathElement> providersByKeys, WebDependenciesBuildItem.Dependency webDependency) {
        String path = WebBundlerDevUIWebDependenciesProcessor.getTypePath(webDependency);
        String webDependencyRootPath = PathUtils.addTrailingSlash((String)GeneratedWebResourcesProcessor.resolveFromRootPath(rootPath, path));
        return this.createWebDependency(webDependency, webDependencyRootPath, providersByKeys, path);
    }

    private static String getTypePath(WebDependenciesBuildItem.Dependency webDependency) {
        return switch (webDependency.type()) {
            default -> throw new IncompatibleClassChangeError();
            case WebDependency.WebDependencyType.MVNPM -> MVNPM_PATH;
            case WebDependency.WebDependencyType.WEBJARS -> WEBJARS_PATH;
        };
    }

    private DevUIWebDependenciesBuildItem.DevUIWebDependency createWebDependency(WebDependenciesBuildItem.Dependency webDep, String webDependencyRootPath, Map<ArtifactKey, ClassPathElement> providersByKeys, String path) {
        ResolvedDependency dep = webDep.resolvedDependency();
        ClassPathElement provider = providersByKeys.get(dep.getKey());
        if (provider == null) {
            return null;
        }
        return (DevUIWebDependenciesBuildItem.DevUIWebDependency)provider.apply(tree -> {
            Path nameDir;
            Path webDependenciesDir = tree.getPath(PREFIX + path);
            try (Stream<Path> webDependenciesDirPaths = Files.list(webDependenciesDir);){
                nameDir = webDependenciesDirPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IOException("Could not find name directory for " + dep.getKey().getArtifactId() + " in " + String.valueOf(webDependenciesDir)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Path root = nameDir;
            StringBuilder urlBase = new StringBuilder(webDependencyRootPath);
            boolean appendRootPart = true;
            try {
                Path versionDir = nameDir.resolve(dep.getVersion());
                root = Files.isDirectory(versionDir, new LinkOption[0]) ? versionDir : nameDir;
                urlBase.append(nameDir.getFileName().toString()).append("/");
                appendRootPart = false;
            }
            catch (InvalidPathException e) {
                log.warn((Object)("Could not find version directory for " + dep.getKey().getArtifactId() + " " + dep.getVersion() + " in " + String.valueOf(nameDir) + ", falling back to name directory"));
            }
            try {
                DevUIWebDependenciesBuildItem.WebDependencyAsset asset = this.createAssetForDep(root, urlBase.toString(), appendRootPart);
                return new DevUIWebDependenciesBuildItem.DevUIWebDependency(webDep.type().toString(), provider.getDependencyKey().getGroupId() + ":" + provider.getDependencyKey().getArtifactId(), dep.getVersion(), asset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private DevUIWebDependenciesBuildItem.WebDependencyAsset createAssetForDep(Path rootPath, String urlBase, boolean appendRootPart) throws IOException {
        urlBase = appendRootPart ? urlBase + rootPath.getFileName().toString() + "/" : urlBase;
        DevUIWebDependenciesBuildItem.WebDependencyAsset root = new DevUIWebDependenciesBuildItem.WebDependencyAsset(rootPath.getFileName().toString(), new LinkedList<DevUIWebDependenciesBuildItem.WebDependencyAsset>(), false, urlBase);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath);){
            for (Path childPath : directoryStream) {
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    DevUIWebDependenciesBuildItem.WebDependencyAsset childDir = this.createAssetForDep(childPath, urlBase, true);
                    root.children().add(childDir);
                    continue;
                }
                DevUIWebDependenciesBuildItem.WebDependencyAsset childFile = new DevUIWebDependenciesBuildItem.WebDependencyAsset(childPath.getFileName().toString(), null, true, urlBase + String.valueOf(childPath.getFileName()));
                root.children().add(childFile);
            }
        }
        root.children().sort(Comparator.comparing(DevUIWebDependenciesBuildItem.WebDependencyAsset::fileAsset).thenComparing(DevUIWebDependenciesBuildItem.WebDependencyAsset::name));
        return root;
    }

    record DevUIWebDependenciesContext(List<WebDependenciesBuildItem.Dependency> dependencies, List<DevUIWebDependenciesBuildItem.DevUIWebDependency> devUIWebDependencies) {
        DevUIWebDependenciesContext() {
            this(null, null);
        }
    }
}

