/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.deployment.web;

import io.quarkiverse.web.bundler.deployment.WebBundlerConfig;
import io.quarkiverse.web.bundler.deployment.items.ReadyForBundlingBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebBundlerTargetDirBuildItem;
import io.quarkiverse.web.bundler.deployment.util.PathUtils;
import io.quarkiverse.web.bundler.deployment.web.GeneratedWebResourceBuildItem;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class GeneratedWebResourcesProcessor {
    private static final Logger LOGGER = Logger.getLogger(GeneratedWebResourcesProcessor.class);
    public static final String WEB_BUNDLER_LIVE_RELOAD_PATH = "/web-bundler/live";

    @BuildStep
    public void processStaticFiles(BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageProducer, List<GeneratedWebResourceBuildItem> staticResources, BuildProducer<GeneratedResourceBuildItem> prodResourcesProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourcesProducer, BuildProducer<GeneratedStaticResourceBuildItem> generatedStaticResourceProducer, LaunchModeBuildItem launchModeBuildItem) {
        if (staticResources.isEmpty()) {
            return;
        }
        for (GeneratedWebResourceBuildItem staticResource : staticResources) {
            if (staticResource.resource().isFile()) {
                generatedStaticResourceProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(staticResource.publicPath(), staticResource.resource().path()));
                continue;
            }
            generatedStaticResourceProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(staticResource.publicPath(), staticResource.resource().content()));
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void initChangeEventHandler(WebBundlerConfig config, WebBundlerTargetDirBuildItem targetDir, WebBundlerResourceRecorder recorder, ReadyForBundlingBuildItem readyForBundling, List<GeneratedWebResourceBuildItem> staticResources, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routes) {
        if (config.browserLiveReload() && readyForBundling != null) {
            routes.produce((BuildItem)RouteBuildItem.builder().route(WEB_BUNDLER_LIVE_RELOAD_PATH).handler(recorder.createChangeEventHandler(targetDir.dist().toAbsolutePath().toString(), config.webRoot(), staticResources.stream().map(GeneratedWebResourceBuildItem::publicPath).collect(Collectors.toSet()), (ShutdownContext)shutdownContext)).build());
        }
    }

    public static String resolveFromRootPath(String rootPath, String path) {
        return PathUtils.join((String)rootPath, (String)path);
    }
}

